/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.common.feedetail;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.constant.FeeInfoConstant;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FeeCalTypeEnum;
import kd.tmc.fbp.common.enums.FeeDetailSrcBillStatusEnum;
import kd.tmc.fbp.common.enums.FeeSourceEnum;
import kd.tmc.fbp.common.enums.OppUnitTypeEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.helper.ListConstructorHelper;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.property.FeeDetailEntryProp;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractBizBillFeeTabEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(AbstractBizBillFeeTabEdit.class);
    private static final String OPPACCTBANK_CLOSECALLBACK = "oppacctbank_closeCallBack";
    private static final String FEEBILL_CLOSECALLBACK = "feebill_closeCallBack";

    public void registerListener(EventObject e) {
        EntryGrid entry;
        super.registerListener(e);
        BasedataEdit feeAcctBank = (BasedataEdit)this.getView().getControl("feeacctbank");
        feeAcctBank.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit feeScheme = (BasedataEdit)this.getView().getControl("feescheme");
        feeScheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit oppUnit = (TextEdit)this.getControl("feeoppunittext");
        oppUnit.addClickListener((ClickListener)this);
        TextEdit oppAcctBank = (TextEdit)this.getControl("feeoppacctbank");
        oppAcctBank.addClickListener((ClickListener)this);
        TextEdit feeNumber = (TextEdit)this.getControl("feenumber");
        if (feeNumber != null) {
            feeNumber.addClickListener((ClickListener)this);
        }
        if ((entry = (EntryGrid)this.getControl("feedetail")) != null) {
            entry.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if ("feeacctbank".equals(key)) {
            this.acctBankF7Evt(evt);
        }
        if ("feescheme".equals(key)) {
            this.feeSchemeF7(evt);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "feeoppacctbank": {
                this.dealAndShowBankInfo();
                break;
            }
            case "feeoppunittext": {
                this.dealOppUnitF7();
                break;
            }
            case "feenumber": {
                this.selectFeeBill();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        switch (propertyName) {
            case "feescheme": {
                this.feeSchemeChgEvt(rowIndex, (DynamicObject)newValue);
                break;
            }
            case "feeoppunit": {
                this.oppUnitChgEvt(rowIndex, (DynamicObject)newValue);
                break;
            }
            case "feeoppunittype": {
                this.getModel().setValue("feeoppunittext", null, rowIndex);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"feeoppacctbank", null, (int)rowIndex);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"feeoppbebank", null, (int)rowIndex);
                break;
            }
            case "feeamt": {
                if (this.checkFormId()) {
                    this.checkAmtChgEvt(rowIndex, (BigDecimal)oldValue, (BigDecimal)newValue);
                    this.newCalculate(rowIndex, propertyName);
                    break;
                }
                this.amtCalChgEvt(rowIndex, (BigDecimal)newValue, propertyName);
                break;
            }
            case "feerate": 
            case "excrate": {
                if (this.checkFormId()) {
                    this.newCalculate(rowIndex, propertyName);
                    break;
                }
                this.amtCalChgEvt(rowIndex, (BigDecimal)newValue, propertyName);
                break;
            }
            case "feenumber": {
                this.numberChgEvt(rowIndex, (String)newValue);
                break;
            }
            case "feecurrency": {
                if (!this.checkFormId()) break;
                if (EmptyUtil.isEmpty((Object)newValue)) {
                    this.getModel().setValue("excrate", (Object)BigDecimal.ONE, rowIndex);
                    break;
                }
                this.currencyChgEvt(rowIndex);
            }
        }
        String headCurrency = (String)this.getBizBillCurrencyFieldProp().getLeft();
        String headAmt = (String)this.getBizBillFeeAmtFieldProp().getLeft();
        if (null != headCurrency && headCurrency.equals(propertyName)) {
            this.headCurrencyChg((DynamicObject)newValue);
        } else if (null != headAmt && headAmt.equals(propertyName)) {
            this.headAmtChg();
        }
        this.calcFeeAndRate(false);
        this.calcCompCostRate();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().deleteEntryData("feedetail");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean loadEntry = BillChangeHistoryHelper.loadEntrysInfo((IFormView)this.getView());
        if (loadEntry) {
            return;
        }
        String entityName = this.getModel().getDataEntity().getDynamicObjectType().getName();
        if (TmcDataServiceHelper.exists((Object)this.getModel().getDataEntity().getPkValue(), (String)entityName)) {
            this.loadFeeDetail();
            if (BillStatusEnum.SAVE.getValue().equals(this.getColumn(entityName, "status"))) {
                this.setFeeEntryEnableByScheme(null);
            }
        }
        ComboEdit feeSource = (ComboEdit)this.getControl("feesource");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(4);
        data.add(new ComboItem(new LocaleString(FeeSourceEnum.HAND.getName()), FeeSourceEnum.HAND.getValue()));
        data.add(new ComboItem(new LocaleString(FeeSourceEnum.BATCHINPUT.getName()), FeeSourceEnum.BATCHINPUT.getValue()));
        data.add(new ComboItem(new LocaleString(FeeSourceEnum.LINKGEN.getName()), FeeSourceEnum.LINKGEN.getValue()));
        data.add(new ComboItem(new LocaleString(FeeSourceEnum.BIZPATCH.getName()), FeeSourceEnum.BIZPATCH.getValue()));
        feeSource.setComboItems(data);
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("feedetail");
        for (int rowIndex = 0; rowIndex < entrys.size(); ++rowIndex) {
            if (this.checkFormId()) {
                this.newCalculate(rowIndex, "feeamt");
                continue;
            }
            this.amtCalChgEvt(rowIndex, (BigDecimal)this.getModel().getValue("feeamt", rowIndex), "feeamt");
        }
        this.calcFeeAndRate(true);
        this.calcCompCostRate();
    }

    private String getColumn(String formId, String baseColumn) {
        if ("cfm_creditlimit".equals(TmcBusinessBaseHelper.getBillFormId((String)formId))) {
            return (String)this.getModel().getValue(baseColumn);
        }
        if ("number".equals(baseColumn)) {
            return (String)this.getModel().getValue("billno");
        }
        if ("status".equals(baseColumn)) {
            return (String)this.getModel().getValue("billstatus");
        }
        return "";
    }

    private void calcFeeAndRate(boolean isShowErrorTip) {
        String formId = TmcBusinessBaseHelper.getBillFormId((String)((FormView)this.getView()).getFormId());
        if (!(ProductTypeEnum.LOANCONTRACT_BL_L.getFormId().equals(formId) || ProductTypeEnum.LOANCONTRACT_IC_L.getFormId().equals(formId) || ProductTypeEnum.LOANBILL.getFormId().equals(formId) || ProductTypeEnum.LOANBILL_B_L.getFormId().equals(formId) || ProductTypeEnum.LOANBILL_E_L.getFormId().equals(formId) || ProductTypeEnum.LOANBILL_BOND.getFormId().equals(formId) || ProductTypeEnum.LOANCONTRACT_BO.getFormId().equals(formId) || ProductTypeEnum.GM_LETTEROFGUARANTEE.getFormId().equals(formId) || ProductTypeEnum.GM_PLEDGEBILL.getFormId().equals(formId) || ProductTypeEnum.LC_FORFAIT.getFormId().equals(formId) || ProductTypeEnum.SCF_FIN_DEBTS.getFormId().equals(formId) || ProductTypeEnum.SCF_FIN_CREDIT.getFormId().equals(formId) || ProductTypeEnum.CFM_CREDITLIMIT.getFormId().equals(formId) || ProductTypeEnum.FL_LEASE_CONTRACT_BILL.getFormId().equals(formId) || ProductTypeEnum.GM_GUARANTEECONTRACT.getFormId().equals(formId))) {
            return;
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getProperty("totalfeeamount"))) {
            return;
        }
        BigDecimal totalFee = BigDecimal.ZERO;
        for (DynamicObject feeRow : this.getModel().getEntryEntity("feedetail")) {
            BigDecimal exCrate = feeRow.getBigDecimal("excrate");
            if (EmptyUtil.isEmpty((BigDecimal)exCrate)) {
                if (isShowErrorTip) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d39\u7528\u7f3a\u5c11\u6298\u7b97\u6c47\u7387\uff0c\u4e0d\u5f71\u54cd\u5355\u636e\u6d41\u8f6c\u3002", (String)"AbstractBizBillFeeTabEdit_12", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
                }
                return;
            }
            totalFee = totalFee.add(exCrate.multiply(feeRow.getBigDecimal("feeamt")));
        }
        ProductTypeEnum productTypeEnum = ProductTypeEnum.getEnumByFormId((String)formId);
        String currencyProp = (String)FeeInfoConstant.formIdCurrencyKeyMap.get(productTypeEnum.getEntity());
        DynamicObject currency = (DynamicObject)this.getModel().getValue(currencyProp);
        totalFee = totalFee.setScale(currency != null ? currency.getInt("amtprecision") : 10, RoundingMode.HALF_UP);
        this.getModel().setValue("totalfeeamount", (Object)totalFee);
        if (EmptyUtil.isEmpty((Object)this.getModel().getProperty("generalfeerate"))) {
            return;
        }
        if (productTypeEnum == null) {
            return;
        }
        String headAmt = (String)this.getBizBillFeeAmtFieldProp().getLeft();
        BigDecimal amount = (BigDecimal)this.getModel().getValue(headAmt);
        if (EmptyUtil.isNoEmpty((BigDecimal)amount)) {
            BigDecimal yrBasis = this.getYrBasis(false);
            BigDecimal term = this.getTerm(false);
            if (EmptyUtil.isEmpty((BigDecimal)yrBasis) || EmptyUtil.isEmpty((BigDecimal)term)) {
                this.getModel().setValue("generalfeerate", null);
                return;
            }
            this.getModel().setValue("generalfeerate", (Object)totalFee.multiply(Constants.ONE_HUNDRED).multiply(yrBasis).divide(amount.multiply(term), 2, RoundingMode.HALF_UP));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex;
        String fieldName = evt.getFieldName();
        if ("feenumber".equals(fieldName) && (rowIndex = evt.getRowIndex()) > -1) {
            DynamicObject entry = this.getModel().getEntryRowEntity("feedetail", rowIndex);
            String linkNo = entry.getString("feenumber");
            if (EmptyUtil.isNoEmpty((String)linkNo)) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId("cfm_feebill");
                DynamicObject bizBill = TmcDataServiceHelper.loadSingle((String)"cfm_feebill", (String)"id", (QFilter[])new QFilter("billno", "=", (Object)linkNo).toArray());
                parameter.setPkId(bizBill.getPkValue());
                parameter.setStatus(OperationStatus.VIEW);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)parameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c", (String)"ContractRateAdjustTabEdit_01", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        String billStatus = this.getColumn(billShowParameter.getFormId(), "status");
        if (!BillStatusEnum.SAVE.getValue().equals(billStatus) || billShowParameter.getStatus() == OperationStatus.VIEW) {
            e.setCheckDataChange(false);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        String entryName = entryProp.getName();
        if ("feedetail".equals(entryName)) {
            ProductTypeEnum productTypeEnum = this.getProductTypeEnum();
            DynamicObject currency = (DynamicObject)this.getModel().getValue((String)this.getBizBillCurrencyFieldProp().getLeft());
            for (RowDataEntity row : e.getRowDataEntities()) {
                int index = row.getRowIndex();
                if (index < 0) continue;
                this.getModel().setValue("feecurrency", (Object)currency, index);
                this.getModel().setValue("feesource", (Object)FeeSourceEnum.LINKGEN.getValue(), index);
                if (!EmptyUtil.isNoEmpty((Object)this.getControl("feeproducttype")) || !EmptyUtil.isNoEmpty((Object)productTypeEnum)) continue;
                this.getModel().setValue("feeproducttype", (Object)productTypeEnum.getValue(), index);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (opKey = op.getOperateKey()) {
            case "save": 
            case "submit": {
                op.getOption().setVariableValue("FeeDetailEditPageSaveOp", this.getView().getFormShowParameter().getFormId());
                break;
            }
            case "newentryfee": {
                DynamicObject org;
                Pair<String, String> amtFieldProp = this.getBizBillFeeAmtFieldProp();
                BigDecimal bizAmt = (BigDecimal)this.getModel().getValue((String)amtFieldProp.getLeft());
                if (EmptyUtil.isEmpty((BigDecimal)bizAmt)) {
                    this.getView().showTipNotification(this.getFiledNullTips((String)amtFieldProp.getRight()));
                    args.setCancel(true);
                    return;
                }
                Pair<String, String> currencyFieldProp = this.getBizBillCurrencyFieldProp();
                DynamicObject headCurrency = (DynamicObject)this.getModel().getValue((String)currencyFieldProp.getLeft());
                if (EmptyUtil.isEmpty((DynamicObject)headCurrency)) {
                    this.getView().showTipNotification(this.getFiledNullTips((String)currencyFieldProp.getRight()));
                    args.setCancel(true);
                }
                if (!EmptyUtil.isEmpty((DynamicObject)(org = (DynamicObject)this.getModel().getValue("org")))) break;
                String propLocalName = this.getModel().getProperty("org").getDisplayName().getLocaleValue();
                this.getView().showTipNotification(this.getFiledNullTips(propLocalName));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        List<String> refreshView = Arrays.asList("audit", "unaudit", "unsubmit");
        if (refreshView.contains(e.getOperateKey()) && e.getOperationResult() != null && e.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        int[] rows = e.getRowIndexs();
        EntryProp entryProp = e.getEntryProp();
        if ("feedetail".equals(entryProp.getName()) && rows.length > 0) {
            for (int row : rows) {
                DynamicObject rowInfo = this.getModel().getEntryRowEntity("feedetail", row);
                String feeSource = rowInfo.getString("feesource");
                if (!EmptyUtil.isNoEmpty((String)feeSource) || FeeSourceEnum.LINKGEN.getValue().equals(feeSource) || this.checkFormId() && !EmptyUtil.isEmpty((String)rowInfo.getString("feenumber"))) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c\u3010%d\u3011\u884c\u6765\u6e90\u662f\u975e\u5173\u8054\u751f\u6210\u7684\u8d39\u7528\u660e\u7ec6\u4e0d\u80fd\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"AbstractBizBillFeeTabEdit_01", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), row + 1));
                e.setCancel(true);
                return;
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        EntryProp entryProp = e.getEntryProp();
        if ("feedetail".equals(entryProp.getName())) {
            this.calcFeeAndRate(false);
            this.calcCompCostRate();
        }
    }

    private void dealOppUnitF7() {
        int indexRow = this.getModel().getEntryCurrentRowIndex("feedetail");
        DynamicObject rowInfo = this.getModel().getEntryRowEntity("feedetail", indexRow);
        String oppUnitType = rowInfo.getString("feeoppunittype");
        if (OppUnitTypeEnum.OTHER.getValue().equals(oppUnitType)) {
            return;
        }
        BasedataEdit control = (BasedataEdit)this.getControl("feeoppunit");
        control.click();
    }

    private void dealAndShowBankInfo() {
        int indexRow = this.getModel().getEntryCurrentRowIndex("feedetail");
        DynamicObject rowInfo = this.getModel().getEntryRowEntity("feedetail", indexRow);
        String oppUnitType = rowInfo.getString("feeoppunittype");
        if (OppUnitTypeEnum.FINORGINFO.getValue().equals(oppUnitType) || OppUnitTypeEnum.OTHER.getValue().equals(oppUnitType)) {
            return;
        }
        DynamicObject oppUnit = rowInfo.getDynamicObject("feeoppunit");
        if (EmptyUtil.isNoEmpty((DynamicObject)oppUnit)) {
            String oppUnitEntityType = oppUnit.getDataEntityType().getName();
            Object oppUnitId = oppUnit.getPkValue();
            Object innerOrgId = null;
            if (StringUtils.equals((CharSequence)oppUnitEntityType, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)oppUnitEntityType, (CharSequence)"bd_customer")) {
                DynamicObject innerOrg = TmcBusinessBaseHelper.getInternalOrg((DynamicObject)oppUnit);
                if (EmptyUtil.isEmpty((DynamicObject)innerOrg)) {
                    String qFilter = new QFilter("id", "=", oppUnitId);
                    DynamicObject entryBankDO = TmcDataServiceHelper.loadSingle((String)oppUnitEntityType, (String)"entry_bank", (QFilter[])qFilter.toArray());
                    if (entryBankDO.getDynamicObjectCollection("entry_bank").size() == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u5ba2\u5546\u7684\u94f6\u884c\u4fe1\u606f\u3002", (String)"AbstractBizBillFeeTabEdit_02", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                } else {
                    innerOrgId = innerOrg.getPkValue();
                }
            }
            ListShowParameter lsp = new ListShowParameter();
            switch (oppUnitEntityType) {
                case "bd_supplier": {
                    if (EmptyUtil.isNoEmpty((Object)innerOrgId)) {
                        lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)innerOrgId);
                        break;
                    }
                    lsp = ListConstructorHelper.getSupplierBankInfoShowParameter((Object)oppUnitId);
                    break;
                }
                case "bd_customer": {
                    if (EmptyUtil.isNoEmpty((Object)innerOrgId)) {
                        lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)innerOrgId);
                        break;
                    }
                    lsp = ListConstructorHelper.getCustomerBankInfoShowParameter((Object)oppUnitId);
                    break;
                }
                case "bos_org": {
                    lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)oppUnitId);
                    break;
                }
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, OPPACCTBANK_CLOSECALLBACK);
            lsp.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    private void selectFeeBill() {
        String formId = this.getView().getFormShowParameter().getFormId();
        String entityNumber = FeeDetailEntryProp.BDIM_FEE_FORMID.contains(formId) ? "bdim_feebill" : ("gm_pledgebill".equals(formId) ? formId.replace("bill", "feebill") : ("cfm_creditlimit".equals(TmcBusinessBaseHelper.getBillFormId((String)formId)) ? "creditm_feebill" : formId.split("_")[0] + "_feebill"));
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)entityNumber, (boolean)false);
        listShowParameter.getListFilterParameter().getQFilters().add(this.getFeeNumberQFilter());
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FEEBILL_CLOSECALLBACK));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (!EmptyUtil.isEmpty((Object)returnData)) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            switch (actionId) {
                case "oppacctbank_closeCallBack": {
                    this.oppAcctBankCloseCallBack(selectedRows.get(0));
                    break;
                }
                case "feebill_closeCallBack": {
                    this.feeBillCloseCallBack(selectedRows.get(0));
                }
            }
        }
    }

    private void feeBillCloseCallBack(ListSelectedRow row) {
        IDataModel mode = this.getModel();
        DynamicObject feeBill = TmcDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"cfm_feebill");
        DynamicObjectCollection feeDetailEntrys = mode.getEntryEntity("feedetail");
        String feeNumber = feeBill.getString("billno");
        List exitFeeNumber = feeDetailEntrys.stream().filter(r -> feeNumber.equals(r.getString("feenumber"))).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(exitFeeNumber)) {
            int indexRow = mode.getEntryCurrentRowIndex("feedetail");
            mode.setValue("feenumber", (Object)feeBill.getString("billno"), indexRow);
            mode.setValue("feecurrency", (Object)feeBill.getDynamicObject("currency"), indexRow);
            mode.setValue("feescheme", (Object)feeBill.getDynamicObject("feescheme"), indexRow);
            mode.setValue("feetype", (Object)feeBill.getDynamicObject("feetype"), indexRow);
            mode.setValue("feepaydate", (Object)feeBill.getDate("paydate"), indexRow);
            if (EmptyUtil.isEmpty((Object)mode.getValue("feerate"))) {
                mode.setValue("feerate", (Object)feeBill.getBigDecimal("amountrate"), indexRow);
            }
            mode.setValue("feesettletype", (Object)feeBill.getDynamicObject("settlementtype"), indexRow);
            mode.setValue("feeacctbank", (Object)feeBill.getDynamicObject("feeacctbank"), indexRow);
            mode.setValue("feeoppunittype", (Object)feeBill.getString("oppunittype"), indexRow);
            mode.setValue("feeoppunit", (Object)feeBill.getDynamicObject("oppunit"), indexRow);
            mode.setValue("feeoppunittext", (Object)feeBill.getString("oppunittext"), indexRow);
            mode.setValue("feeoppacctbank", (Object)feeBill.getString("oppacctbank"), indexRow);
            mode.setValue("feeoppbebank", (Object)feeBill.getDynamicObject("oppbebank"), indexRow);
            mode.setValue("feeissettle", (Object)feeBill.getBoolean("issettle"), indexRow);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"feesource", (Object)feeBill.getString("feesource"), (int)indexRow);
            mode.setValue("feeremark", (Object)feeBill.getString("description"), indexRow);
            mode.setValue("feebillid", feeBill.getPkValue(), indexRow);
            mode.setValue("feeamt", (Object)feeBill.getBigDecimal("enpayamt"), indexRow);
            DynamicProperty shareTypeProp = feeDetailEntrys.getDynamicObjectType().getProperty("freesharetype");
            if (shareTypeProp != null) {
                mode.setValue("freesharetype", (Object)feeBill.getString("sharetype"));
            }
            this.setFeeValueAfterSelectFeeNumber(feeBill, indexRow);
        } else {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u76f8\u540c\u7684\u8d39\u7528\u660e\u7ec6[%s]\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u9009\u62e9\u3002", (String)"AbstractBizBillFeeTabEdit_10", (String)"tmc-fbp-formplugin", (Object[])new Object[0]), feeNumber));
        }
    }

    private void oppAcctBankCloseCallBack(ListSelectedRow row) {
        int indexRow = this.getModel().getEntryCurrentRowIndex("feedetail");
        DynamicObject rowInfo = this.getModel().getEntryRowEntity("feedetail", indexRow);
        DynamicObject oppUnit = rowInfo.getDynamicObject("feeoppunit");
        Object entryKey = row.getEntryPrimaryKeyValue();
        String entityName = oppUnit.getDataEntityType().getName();
        DynamicObject innerOrg = null;
        if ("bd_supplier".equals(entityName) || "bd_customer".equals(entityName)) {
            innerOrg = TmcBusinessBaseHelper.getInternalOrg((DynamicObject)oppUnit);
        }
        if ((StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_customer")) && EmptyUtil.isEmpty((DynamicObject)innerOrg)) {
            DynamicObject oppUnitDetail = TmcDataServiceHelper.loadSingle((String)oppUnit.getDataEntityType().getName(), (String)"id,bankaccount,bank", (QFilter[])new QFilter[]{new QFilter("entry_bank.id", "=", entryKey)});
            DynamicObjectCollection entryBank = oppUnitDetail.getDynamicObjectCollection("entry_bank");
            for (DynamicObject entry : entryBank) {
                if (!entry.getPkValue().equals(entryKey)) continue;
                this.getModel().setValue("feeoppacctbank", (Object)entry.getString("bankaccount"), indexRow);
                this.getModel().setValue("feeoppbebank", (Object)entry.getDynamicObject("bank"), indexRow);
                break;
            }
        } else if ("bos_org".equals(entityName) || EmptyUtil.isNoEmpty((DynamicObject)innerOrg)) {
            DynamicObject beBankDO;
            DynamicObject accountBanksDO = TmcDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,bank,number", (QFilter[])new QFilter("id", "=", row.getPrimaryKeyValue()).toArray());
            this.getModel().setValue("feeoppacctbank", (Object)accountBanksDO.getString("number"), indexRow);
            DynamicObject bankDO = accountBanksDO.getDynamicObject("bank");
            if (!EmptyUtil.isEmpty((DynamicObject)bankDO) && !EmptyUtil.isEmpty((DynamicObject)(beBankDO = bankDO.getDynamicObject("bebank")))) {
                this.getModel().setValue("feeoppbebank", beBankDO.getPkValue(), indexRow);
            }
        }
    }

    private void amtCalChgEvt(int rowIndex, BigDecimal newValue, String fieldProp) {
        Pair<String, String> amtFieldProp = this.getBizBillFeeAmtFieldProp();
        BigDecimal bizAmt = (BigDecimal)this.getModel().getValue((String)amtFieldProp.getLeft());
        if (EmptyUtil.isEmpty((BigDecimal)bizAmt)) {
            this.getView().showTipNotification(this.getFiledNullTips((String)amtFieldProp.getRight()));
            return;
        }
        if ("feerate".equals(fieldProp)) {
            BigDecimal feeAmt = bizAmt.multiply(newValue).divide(BigDecimal.valueOf(100L), bizAmt.scale(), RoundingMode.HALF_UP);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"feeamt", (Object)feeAmt, (int)rowIndex);
        } else {
            BigDecimal rateAmt = newValue.multiply(BigDecimal.valueOf(100L)).divide(bizAmt, bizAmt.scale(), RoundingMode.HALF_UP);
            if (rateAmt.compareTo(Constants.MAX_AMOUNT) > 0) {
                rateAmt = Constants.ZERO;
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"feerate", (Object)rateAmt, (int)rowIndex);
        }
    }

    private void newCalculate(int rowIndex, String fieldProp) {
        boolean calRate;
        Pair<String, String> amtFieldProp = this.getBizBillFeeAmtFieldProp();
        BigDecimal bizAmt = (BigDecimal)this.getModel().getValue((String)amtFieldProp.getLeft());
        if (EmptyUtil.isEmpty((BigDecimal)bizAmt)) {
            this.getView().showTipNotification(this.getFiledNullTips((String)amtFieldProp.getRight()));
            return;
        }
        DynamicObject feeCur = (DynamicObject)this.getModel().getValue("feecurrency", rowIndex);
        if (EmptyUtil.isEmpty((DynamicObject)feeCur)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d39\u7528\u4fe1\u606f\u4e2d\u7684\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractBizBillFeeTabEdit_04", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            return;
        }
        BigDecimal excRate = (BigDecimal)this.getModel().getValue("excrate", rowIndex);
        if (EmptyUtil.isEmpty((BigDecimal)excRate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d39\u7528\u4fe1\u606f\u4e2d\u7684\u6298\u503a\u52a1\u5e01\u79cd\u6c47\u7387\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractBizBillFeeTabEdit_15", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            return;
        }
        BigDecimal feeRate = (BigDecimal)this.getModel().getValue("feerate", rowIndex);
        BigDecimal feeAmt = (BigDecimal)this.getModel().getValue("feeamt", rowIndex);
        boolean calAmt = EmptyUtil.isNoEmpty((BigDecimal)feeRate) && EmptyUtil.isNoEmpty((BigDecimal)excRate) && "feerate".equals(fieldProp);
        boolean bl = calRate = EmptyUtil.isNoEmpty((BigDecimal)feeAmt) && EmptyUtil.isNoEmpty((BigDecimal)excRate) && ("feeamt".equals(fieldProp) || "excrate".equals(fieldProp));
        if (calAmt) {
            BigDecimal newAmt = bizAmt.multiply(feeRate).divide(excRate, 10, RoundingMode.HALF_UP).divide(BigDecimal.valueOf(100L), bizAmt.scale(), RoundingMode.HALF_UP);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"feeamt", (Object)newAmt, (int)rowIndex);
        }
        if (calRate) {
            BigDecimal newRate = feeAmt.multiply(excRate).multiply(BigDecimal.valueOf(100L)).divide(bizAmt, bizAmt.scale(), RoundingMode.HALF_UP);
            if (newRate.compareTo(Constants.MAX_AMOUNT) > 0) {
                newRate = Constants.ZERO;
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"feerate", (Object)newRate, (int)rowIndex);
        }
    }

    private void headAmtChg() {
        String currEntity = this.getModel().getDataEntityType().getName();
        List<String> lcEntitys = Arrays.asList(ProductTypeEnum.LC_LETTER.getEntity(), ProductTypeEnum.LC_ARRIVAL.getEntity(), ProductTypeEnum.LC_PRESENT.getEntity(), ProductTypeEnum.LC_FORFAIT.getEntity(), ProductTypeEnum.LC_CHANGE.getEntity(), ProductTypeEnum.LC_APPLY.getEntity());
        if (lcEntitys.contains(currEntity)) {
            return;
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("feedetail");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject feeScheme = ((DynamicObject)entrys.get(i)).getDynamicObject("feescheme");
            if (EmptyUtil.isNoEmpty((DynamicObject)feeScheme)) {
                this.feeSchemeChgEvt(i, feeScheme);
                continue;
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"feeamt", (Object)0, (int)i);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"feerate", (Object)0, (int)i);
        }
    }

    private void headCurrencyChg(DynamicObject curreny) {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("feedetail");
        boolean checkFromId = this.checkFormId();
        for (int i = 0; i < entrys.size(); ++i) {
            String feeNumber;
            String string = feeNumber = checkFromId ? ((DynamicObject)entrys.get(i)).getString("feenumber") : null;
            if (!EmptyUtil.isEmpty(feeNumber)) continue;
            this.getModel().setValue("feecurrency", (Object)curreny, i);
        }
    }

    private void feeSchemeChgEvt(int rowIndex, DynamicObject feeScheme) {
        boolean schemeNoEmpty = EmptyUtil.isNoEmpty((DynamicObject)feeScheme);
        this.getModel().setValue("feetype", schemeNoEmpty ? feeScheme.getDynamicObject("feetype") : Integer.valueOf(0), rowIndex);
        if (schemeNoEmpty) {
            this.getModel().setValue("feeissettle", (Object)(!feeScheme.getBoolean("handsettle") ? 1 : 0), rowIndex);
            String feeCalType = feeScheme.getString("feecaltype");
            BigDecimal amt = feeScheme.getBigDecimal("amountrate");
            if (FeeCalTypeEnum.ratio.getValue().equals(feeCalType)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"feerate", (Object)amt, (int)rowIndex);
                if (this.checkFormId()) {
                    this.newCalculate(rowIndex, "feerate");
                } else {
                    this.amtCalChgEvt(rowIndex, amt, "feerate");
                }
            } else {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"feeamt", (Object)amt, (int)rowIndex);
                if (this.checkFormId()) {
                    this.newCalculate(rowIndex, "feeamt");
                } else {
                    this.amtCalChgEvt(rowIndex, amt, "feeamt");
                }
            }
        } else {
            this.getModel().setValue("feeissettle", (Object)Boolean.FALSE, rowIndex);
        }
        this.setFeeEntryEnableByScheme(rowIndex);
    }

    private void oppUnitChgEvt(int rowIndex, DynamicObject oppUnit) {
        if (EmptyUtil.isNoEmpty((DynamicObject)oppUnit)) {
            this.getModel().setValue("feeoppunittext", (Object)oppUnit.getString("name"), rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"feeoppacctbank", null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"feeoppbebank", null, (int)rowIndex);
        }
    }

    private void checkAmtChgEvt(int rowIndex, BigDecimal oldValue, BigDecimal newValue) {
        if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("feenumber", rowIndex))) {
            DynamicObject feeBill = TmcDataServiceHelper.loadSingle((Object)this.getModel().getValue("feebillid", rowIndex), (String)"cfm_feebill");
            DynamicObjectCollection entrys = feeBill.getDynamicObjectCollection("entry");
            String entityName = this.getModel().getDataEntity().getDynamicObjectType().getName();
            BigDecimal allFeeAmt = entrys.stream().filter(row -> !FeeDetailSrcBillStatusEnum.NOAUDIT.getValue().equals(row.getString("srcstatus")) && !row.getString("srcbillno").equals(this.getColumn(entityName, "number"))).map(row -> row.getBigDecimal("feedetailamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal enPayAmt = feeBill.getBigDecimal("payamt").subtract(allFeeAmt);
            if (enPayAmt.compareTo(BigDecimal.ZERO) < 0 && newValue.compareTo(BigDecimal.ZERO) > 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u8d39\u7528\u660e\u7ec6[%s]\u7684\u8d39\u7528\u91d1\u989d\u4e3a\u8d1f\u6570\uff0c\u5f55\u5165\u7684\u8d39\u7528\u91d1\u989d\u5e94\u4e3a\u8d1f\u6570\u3002", (String)"AbstractBizBillFeeTabEdit_13", (String)"tmc-fbp-formplugin", (Object[])new Object[0]), feeBill.getString("billno")));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"feeamt", (Object)oldValue, (int)rowIndex);
            }
            if (enPayAmt.compareTo(BigDecimal.ZERO) > 0 && newValue.compareTo(BigDecimal.ZERO) < 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u8d39\u7528\u660e\u7ec6[%s]\u7684\u8d39\u7528\u91d1\u989d\u4e3a\u6b63\u6570\uff0c\u5f55\u5165\u7684\u8d39\u7528\u91d1\u989d\u5e94\u4e3a\u6b63\u6570\u3002", (String)"AbstractBizBillFeeTabEdit_14", (String)"tmc-fbp-formplugin", (Object[])new Object[0]), feeBill.getString("billno")));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"feeamt", (Object)oldValue, (int)rowIndex);
            }
            if (newValue.abs().compareTo(enPayAmt.abs()) > 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f55\u5165\u7684\u8d39\u7528\u91d1\u989d\u8d85\u8fc7\u5173\u8054\u7684\u8d39\u7528\u660e\u7ec6[%s]\u7684\u5269\u4f59\u8d39\u7528\u91d1\u989d\u3002", (String)"AbstractBizBillFeeTabEdit_09", (String)"tmc-fbp-formplugin", (Object[])new Object[0]), feeBill.getString("billno")));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"feeamt", (Object)oldValue, (int)rowIndex);
            }
        }
    }

    private void numberChgEvt(int rowIndex, String newValue) {
        if (EmptyUtil.isEmpty((String)newValue)) {
            IDataModel mode = this.getModel();
            IFormView view = this.getView();
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)mode, (String)"feenumber", null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)mode, (String)"feescheme", null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)mode, (String)"feetype", null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)mode, (String)"feepaydate", null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)mode, (String)"feecurrency", null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)mode, (String)"feerate", null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)mode, (String)"feesettletype", null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)mode, (String)"feeacctbank", null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)mode, (String)"feeoppunittype", null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)mode, (String)"feeoppunit", null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)mode, (String)"feeoppunittext", null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)mode, (String)"feeoppacctbank", null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)mode, (String)"feeoppbebank", null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)mode, (String)"feeissettle", null, (int)rowIndex);
            this.getModel().setValue("feesource", (Object)FeeSourceEnum.LINKGEN.getValue(), rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)mode, (String)"feeremark", null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)mode, (String)"feebillid", null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)mode, (String)"feebillentryid", null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)mode, (String)"feeamt", null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)mode, (String)"excrate", (Object)Constants.ONE, (int)rowIndex);
        }
    }

    private void currencyChgEvt(int rowIndex) {
        Pair<String, String> currencyFieldProp = this.getBizBillCurrencyFieldProp();
        DynamicObject headCurrency = (DynamicObject)this.getModel().getValue((String)currencyFieldProp.getLeft());
        DynamicObject feeCurrency = (DynamicObject)this.getModel().getValue("feecurrency", rowIndex);
        String mainOrg = this.getModel().getDataEntityType().getMainOrg();
        DynamicObject org = (DynamicObject)this.getModel().getValue(mainOrg);
        this.getModel().setValue("excrate", (Object)this.getExcRate(org, headCurrency, feeCurrency), rowIndex);
    }

    public void loadFeeDetail() {
        logger.info("loadFeeDetail()\u7236\u7c7b\u65b9\u6cd5,\u6267\u884c");
        Long pkId = (Long)this.getModel().getValue("id");
        if (EmptyUtil.isEmpty((Long)pkId)) {
            return;
        }
        QFilter feeIdFilter = new QFilter("entry.srcbillid", "=", (Object)pkId);
        QFilter dataIsoRateFilter = new QFilter("feesource", "=", (Object)FeeSourceEnum.LINKGEN.getValue()).or(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("feesource", "in", Arrays.asList(FeeSourceEnum.HAND.getValue(), FeeSourceEnum.BIZPATCH.getValue(), FeeSourceEnum.BATCHINPUT.getValue()))));
        this.addFeeBilIdQfilter(feeIdFilter);
        DynamicObjectCollection feeBills = QueryServiceHelper.query((String)"cfm_feebill", (String)"id,billno,org,feescheme,feetype,billstatus,paydate,currency,amountrate,payamt,feeacctbank,settlementtype,oppunittype,oppunit,oppunittext,oppacctbank,oppbebank,sharetype,issettle,feesource,description,entry.id,entry.producttype,entry.srcbillno,entry.srcbillid,entry.feedetailamt,entry.remark,entry.srcstatus,entry.excrate", (QFilter[])new QFilter[]{feeIdFilter, dataIsoRateFilter}, (String)"modifytime asc");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)feeBills)) {
            return;
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        this.addField(vs);
        for (DynamicObject feeBill : feeBills) {
            this.addRow(vs, feeBill);
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        boolean isDataChange = model.isDataLoaded();
        model.batchCreateNewEntryRow("feedetail", vs);
        model.setDataChanged(isDataChange);
        model.endInit();
        this.getView().updateView("feedetail");
    }

    public boolean isLoanOrCreditOrPresentFee(DynamicObject feeBill) {
        return false;
    }

    private String getFeeProductTypeNum(DynamicObject feeBill) {
        String productTypeId = String.valueOf(feeBill.get("entry.producttype"));
        for (ProductTypeEnum productType : ProductTypeEnum.values()) {
            if (!productTypeId.equals(productType.getId())) continue;
            return productType.getValue();
        }
        return "";
    }

    private void feeSchemeF7(BeforeF7SelectEvent evt) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject currency = (DynamicObject)this.getModel().getValue((String)this.getBizBillCurrencyFieldProp().getLeft());
        ProductTypeEnum typeEnum = this.getProductTypeEnum();
        if (EmptyUtil.isEmpty((Object)typeEnum)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u5355\u636e\u5bf9\u5e94\u7684\u4ea7\u54c1\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"AbstractBizBillFeeTabEdit_08", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        if (EmptyUtil.isNoEmpty((DynamicObject)org) && EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            QFilter qFilter = new QFilter("org", "=", org.getPkValue());
            qFilter.and("currency", "=", currency.getPkValue()).and("tradetype", "=", (Object)Long.valueOf(typeEnum.getId()));
            sp.getListFilterParameter().getQFilters().add(qFilter);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u7ec4\u7ec7\u548c\u5e01\u79cd\u3002", (String)"AbstractBizBillFeeTabEdit_03", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    private void acctBankF7Evt(BeforeF7SelectEvent evt) {
        int currRow = evt.getRow();
        DynamicObject currRowInfo = this.getModel().getEntryRowEntity("feedetail", currRow);
        DynamicObject feeCurrency = currRowInfo.getDynamicObject("feecurrency");
        if (EmptyUtil.isEmpty((DynamicObject)feeCurrency)) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d39\u7528\u4fe1\u606f\u4e2d\u7684\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractBizBillFeeTabEdit_04", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject mainOrg = (DynamicObject)this.getModel().getValue("org");
        long orgId = mainOrg == null ? 0L : Long.parseLong(mainOrg.getPkValue().toString());
        QFilter qFilter = TmcAccountHelper.getAccountBankFilterByOrg((Long)orgId).and("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void setFeeEntryEnableByScheme(Integer rowIndex) {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("feedetail");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            if (null != rowIndex && rowIndex == i) {
                this.setRowEnable(rowIndex, entry);
                continue;
            }
            if (null != rowIndex) continue;
            this.setRowEnable(i, entry);
        }
    }

    private void setRowEnable(int i, DynamicObject entry) {
        DynamicObject feeScheme = entry.getDynamicObject("feescheme");
        if (EmptyUtil.isNoEmpty((DynamicObject)feeScheme)) {
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"feetype", "feeissettle"});
            String feeCalType = feeScheme.getString("feecaltype");
            if (FeeCalTypeEnum.ratio.getValue().equals(feeCalType)) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"feerate", "feeamt"});
            } else {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"feeamt", "feerate"});
            }
        } else {
            this.getView().setEnable(Boolean.TRUE, i, new String[]{"feetype", "feeamt", "feerate", "feeissettle"});
        }
    }

    public abstract Pair<String, String> getBizBillFeeAmtFieldProp();

    public BigDecimal getYrBasis(boolean isShowErrorTip) {
        return new BigDecimal(1);
    }

    public BigDecimal getTerm(boolean isShowErrorTip) {
        return new BigDecimal(1);
    }

    public abstract Pair<String, String> getBizBillCurrencyFieldProp();

    public void addFeeBilIdQfilter(QFilter feeIdFilter) {
        logger.info("addFeeBilIdQfilter()\u65b9\u6cd5,\u5b50\u7c7b\u6ca1\u5b9e\u73b0,\u4e0d\u6dfb\u52a0\u8fc7\u6ee4\u6761\u4ef6,\u7a7a\u5b9e\u73b0");
    }

    private String getFiledNullTips(String tip) {
        return String.format(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u4e2d\u7684%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractBizBillFeeTabEdit_05", (String)"tmc-fbp-formplugin", (Object[])new Object[0]), tip);
    }

    private ProductTypeEnum getProductTypeEnum() {
        String formId = this.getView().getFormShowParameter().getFormId();
        ProductTypeEnum productEnum = ProductTypeEnum.getEnumByFormId((String)TmcBusinessBaseHelper.getBillFormId((String)formId));
        if (ProductTypeEnum.LC_APPLY == productEnum && "edit_card".equals(this.getModel().getValue("biztype"))) {
            return ProductTypeEnum.LC_CHANGE;
        }
        return productEnum;
    }

    private boolean checkFormId() {
        String formId = TmcBusinessBaseHelper.getBillFormId((String)this.getView().getFormShowParameter().getFormId());
        return FeeDetailEntryProp.FEENUMER_LIST.contains(formId);
    }

    private BigDecimal getExcRate(DynamicObject org, DynamicObject headCur, DynamicObject feeCur) {
        if (headCur.getPkValue().equals(feeCur.getPkValue())) {
            return BigDecimal.ONE;
        }
        Long exchangeTableId = TmcBusinessBaseHelper.getExchageTableId((Long)org.getLong("id"));
        if (EmptyUtil.isEmpty((Long)exchangeTableId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"%s:\u6ca1\u6709\u5728\u51fa\u7eb3\u521d\u59cb\u5316\u91cc\u7ef4\u62a4\u6c47\u7387\u8868,\u8bf7\u7ef4\u62a4\u3002", (String)"AbstractBizBillFeeTabEdit_16", (String)"tmc-fbp-formplugin", (Object[])new Object[]{org.getString("name")}));
            return BigDecimal.ONE;
        }
        BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeTableId, (Long)feeCur.getLong("id"), (Long)headCur.getLong("id"), null);
        if (EmptyUtil.isNoEmpty((BigDecimal)exchangeRate)) {
            return exchangeRate;
        }
        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s:\u6ca1\u6709\u7ef4\u62a4[%2$s]\u8f6c\u6362[%3$s]\u7684\u6c47\u7387\u3002", (String)"AbstractBizBillFeeTabEdit_11", (String)"tmc-fbp-formplugin", (Object[])new Object[0]), org.getString("name"), feeCur.getString("name"), headCur.getString("name")));
        return BigDecimal.ONE;
    }

    public void addField(TableValueSetter vs) {
        DynamicObjectCollection entryEntity;
        DynamicProperty property;
        vs.addField("loanbillno", new Object[0]).addField("feeproducttype", new Object[0]).addField("feescheme", new Object[0]).addField("feetype", new Object[0]).addField("feepaydate", new Object[0]).addField("feecurrency", new Object[0]).addField("feeamt", new Object[0]).addField("feerate", new Object[0]).addField("feesettletype", new Object[0]).addField("feeacctbank", new Object[0]).addField("feeoppunittype", new Object[0]).addField("feeoppunit", new Object[0]).addField("feeoppunittext", new Object[0]).addField("feeoppacctbank", new Object[0]).addField("feeoppbebank", new Object[0]).addField("feeissettle", new Object[0]).addField("feesource", new Object[0]).addField("feeremark", new Object[0]).addField("feebillnum", new Object[0]).addField("feebillid", new Object[0]).addField("feebillentryid", new Object[0]);
        if (this.checkFormId()) {
            vs.addField("feenumber", new Object[0]);
            vs.addField("excrate", new Object[0]);
        }
        if ((property = (entryEntity = this.getModel().getEntryEntity("feedetail")).getDynamicObjectType().getProperty("freesharetype")) != null) {
            vs.addField("freesharetype", new Object[0]);
        }
    }

    public void addRow(TableValueSetter vs, DynamicObject feeBill) {
        DynamicObjectCollection entryEntity;
        DynamicProperty property;
        vs.addRow(new Object[]{this.isLoanOrCreditOrPresentFee(feeBill) ? feeBill.get("entry.srcbillno") : null, this.getFeeProductTypeNum(feeBill), feeBill.get("feescheme"), feeBill.get("feetype"), feeBill.get("paydate"), feeBill.get("currency"), feeBill.get("entry.feedetailamt"), feeBill.get("amountrate"), feeBill.get("settlementtype"), feeBill.get("feeacctbank"), feeBill.get("oppunittype"), feeBill.get("oppunit"), feeBill.get("oppunittext"), feeBill.get("oppacctbank"), feeBill.get("oppbebank"), feeBill.get("issettle"), feeBill.get("feesource"), feeBill.get("entry.remark"), feeBill.get("billno"), feeBill.get("id"), this.checkFormId() && EmptyUtil.isNoEmpty((Object)feeBill.get("entry.srcstatus")) ? feeBill.get("entry.id") : null});
        if (this.checkFormId()) {
            vs.set("feenumber", EmptyUtil.isNoEmpty((Object)feeBill.get("entry.srcstatus")) || BillStatusEnum.AUDIT.getValue().equals(feeBill.get("billstatus")) ? feeBill.get("billno") : null, vs.getCount() - 1);
            vs.set("excrate", (Object)feeBill.getBigDecimal("entry.excrate"), vs.getCount() - 1);
        }
        if ((property = (entryEntity = this.getModel().getEntryEntity("feedetail")).getDynamicObjectType().getProperty("freesharetype")) != null) {
            vs.set("freesharetype", feeBill.get("sharetype"), vs.getCount() - 1);
        }
    }

    public void setFeeValueAfterSelectFeeNumber(DynamicObject feeBill, int indexRow) {
    }

    public QFilter getFeeNumberQFilter() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String billNo = (String)this.getModel().getValue("billno");
        QFilter qFilter = new QFilter("org", "=", EmptyUtil.isNoEmpty((DynamicObject)org) ? org.getPkValue() : null);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("enpayamt", "!=", (Object)BigDecimal.ZERO);
        qFilter.and(new QFilter("entry.srcbillno", "!=", (Object)billNo).or("entry", "is null", null));
        return qFilter;
    }

    private void calcCompCostRate() {
        if (EmptyUtil.isEmpty((Object)this.getModel().getProperty("compcostrate"))) {
            return;
        }
        BigDecimal compRate = this.calcCompCostRate(this.getModel());
        this.getModel().setValue("compcostrate", (Object)compRate);
    }

    private BigDecimal calcCompCostRate(IDataModel model) {
        int diffDays;
        if (EmptyUtil.isEmpty((Object)model.getProperty("compcostrate"))) {
            return null;
        }
        if (EmptyUtil.isEmpty((Object)model.getProperty("totalfeeamount"))) {
            return null;
        }
        BigDecimal feeAmt = (BigDecimal)model.getValue("totalfeeamount");
        BigDecimal intDoneAmt = (BigDecimal)model.getValue("payinterestamount");
        BigDecimal intFutureAmt = (BigDecimal)model.getValue("notpayinterestamount");
        BigDecimal totalFeeAmt = intDoneAmt.add(intFutureAmt).add(feeAmt);
        String basis = (String)model.getValue("basis");
        Date endDate = (Date)Optional.ofNullable(model.getValue("renewalexpiredate")).orElseGet(() -> model.getValue("enddate"));
        Date startDate = (Date)model.getValue("startdate");
        BigDecimal amount = (BigDecimal)model.getValue("amount");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{basis, endDate, startDate, amount})) {
            return null;
        }
        int yearDay = TermHelper.getBasis_YearDay((Date)startDate, (Date)endDate, (BasisEnum)BasisEnum.getEnum((String)basis));
        DynamicObjectCollection workcalendar = (DynamicObjectCollection)model.getValue("workcalendar");
        DynamicObject[] workCalArr = new DynamicObject[]{};
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)workcalendar)) {
            workCalArr = (DynamicObject[])workcalendar.toArray((Object[])new DynamicObject[0]);
        }
        if ((diffDays = TermHelper.getBasis_BetweenDay((Date)startDate, (Date)endDate, (BasisEnum)BasisEnum.getEnum((String)basis), (DynamicObject[])workCalArr)) < 1) {
            return null;
        }
        return totalFeeAmt.multiply(new BigDecimal(yearDay)).multiply(new BigDecimal("100")).divide(amount.multiply(new BigDecimal(diffDays)), feeAmt.scale(), 4);
    }
}

