/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.common.feedetail;

import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BatchFeeInputList
extends AbstractListPlugin {
    private static final String CLOSECALLBACK_FEEBATCHINPUT = "closeCallBack_feeBatchInput";
    private static final String TBL_BATCHINPUT = "batchinput";

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (TBL_BATCHINPUT.equals(args.getOperateKey()) && operationResult.isSuccess()) {
            String billFormId = TmcBusinessBaseHelper.getBillFormId((String)((ListView)this.getView()).getBillFormId());
            for (ProductTypeEnum productType : this.getBizBillProductTypes()) {
                if (!productType.getFormId().equals(billFormId)) continue;
                String selectedBillNo = this.getSelectedBillNo();
                if (EmptyUtil.isNoEmpty((String)selectedBillNo)) {
                    this.openFeeBatchEdit(selectedBillNo);
                }
                return;
            }
            this.openFeeBatchEdit(null);
        }
    }

    public void closedCallBack(ClosedCallBackEvent args) {
        Map returnData;
        super.closedCallBack(args);
        String actionId = args.getActionId();
        if (CLOSECALLBACK_FEEBATCHINPUT.equals(actionId) && null != (returnData = (Map)args.getReturnData()) && ((Boolean)returnData.get("OK")).booleanValue()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6279\u91cf\u5f55\u5165\u64cd\u4f5c\u6210\u529f\u3002", (String)"BatchFeeInputList_0", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    private void openFeeBatchEdit(String selectedBillNo) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setFormId("cfm_feebathcinput");
        parameter.setCustomParam("billFormId", (Object)((ListView)this.getView()).getBillFormId());
        parameter.setCustomParam("selectedRowBillNo", (Object)selectedBillNo);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_FEEBATCHINPUT));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(parameter);
    }

    protected String getSelectedBillNo() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (selectedRows.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BatchFeeInputList_1", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            return null;
        }
        if (selectedRows.size() > 1 && selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).distinct().count() > 1L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"BatchFeeInputList_2", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            return null;
        }
        if (!BillStatusEnum.AUDIT.getValue().equals(selectedRows.get(0).getBillStatus())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u5ba1\u6838\u7684\u6570\u636e\u3002", (String)"BatchFeeInputList_3", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            return null;
        }
        return "cfm_creditlimit".equals(TmcBusinessBaseHelper.getBillFormId((String)((ListView)this.getView()).getBillFormId())) ? selectedRows.get(0).getNumber() : selectedRows.get(0).getBillNo();
    }

    private ProductTypeEnum[] getBizBillProductTypes() {
        return new ProductTypeEnum[]{ProductTypeEnum.LOANBILL_B_L, ProductTypeEnum.LOANBILL_E_L, ProductTypeEnum.LOANBILL_BOND, ProductTypeEnum.LC_ARRIVAL, ProductTypeEnum.LC_LETTER, ProductTypeEnum.LC_APPLY, ProductTypeEnum.LC_RECEIPT, ProductTypeEnum.LC_PRESENT, ProductTypeEnum.LC_FORFAIT, ProductTypeEnum.GM_LETTEROFGUARANTEE, ProductTypeEnum.GM_PLEDGEBILL, ProductTypeEnum.SCF_FIN_CREDIT, ProductTypeEnum.SCF_FIN_DEBTS, ProductTypeEnum.CFM_CREDITLIMIT, ProductTypeEnum.FL_LEASE_CONTRACT_BILL, ProductTypeEnum.GM_GUARANTEECONTRACT};
    }
}

