/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.common.guaranteeuse;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditLimitLinkGuaranteePlugin
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEnable();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int rowIdx = e.getChangeSet()[0].getRowIndex();
        String entityName = this.getModel().getDataEntityType().getName();
        String creditLimitProp = GuaranteeUseHelper.getBizPropName((String)entityName, (String)"head_creditlimit");
        String entryCreditLimitProp = GuaranteeUseHelper.getBizPropName((String)entityName, (String)"entry_creditlimit");
        String bizAmountProp = GuaranteeUseHelper.getBizPropName((String)entityName, (String)"bizamount");
        if (propertyName.equals(creditLimitProp) || propertyName.equals(entryCreditLimitProp) || propertyName.equals("synccreditlimit")) {
            DynamicObjectCollection guaranteeUseBills;
            bizAmountProp = EmptyUtil.isNoEmpty((Object)this.getModel().getProperty("synccreditlimit")) && EmptyUtil.isNoEmpty((Object)this.getModel().getValue("synccreditlimit")) ? "syncdrawamount" : bizAmountProp;
            Map bankSyncMap = GuaranteeUseHelper.getBankSyncMap((String)entityName, (IDataModel)this.getModel(), (int)rowIdx);
            if (EmptyUtil.isNoEmpty((Object)oldValue) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(guaranteeUseBills = GuaranteeUseHelper.getGuaranteeUseBills((Long)((DynamicObject)oldValue).getLong("id"))))) {
                Set ids = guaranteeUseBills.stream().map(o -> o.getLong("gcontract")).collect(Collectors.toSet());
                ArrayList<Integer> removeIndexes = new ArrayList<Integer>();
                for (int index = 0; index < this.getModel().getEntryRowCount("entry_gcontract"); ++index) {
                    DynamicObject gContract = (DynamicObject)this.getModel().getValue("gcontract", index);
                    if (gContract == null || !ids.contains(gContract.getLong("id"))) continue;
                    if (!bankSyncMap.isEmpty()) {
                        String creditorType = (String)this.getModel().getValue("gcreditortype", index);
                        Long creditor = (Long)this.getModel().getValue("gcreditor", index);
                        if (!EmptyUtil.isNoEmpty((String)creditorType) || !creditorType.equals(bankSyncMap.get("gcreditortype")) || creditor == null || !creditor.equals(bankSyncMap.get("gcreditor"))) continue;
                        removeIndexes.add(index);
                        continue;
                    }
                    removeIndexes.add(index);
                }
                this.getView().getPageCache().put("isDeleteGuaranteeEntry", "yes");
                this.getModel().deleteEntryRows("entry_gcontract", removeIndexes.stream().mapToInt(i -> i).toArray());
            }
            if (EmptyUtil.isNoEmpty((Object)newValue)) {
                DynamicObjectCollection guaranteeUseBills2;
                QFilter qFilter;
                DynamicObject loanApplyDo;
                if ("cfm_loan_apply".equals(entityName) && !CreditorTypeEnum.isSettleCenter((String)((String)this.getModel().getValue("creditortype")))) {
                    return;
                }
                DynamicObject creditUseBill = CreditLimitServiceHelper.getCreditUseBill((Long)((Long)this.getModel().getValue("id")), (String)entityName);
                if (("cfm_loancontract_bl_l".equals(entityName) || "cfm_loancontract_ic_l".equals(entityName) || "cfm_loancontractbill".equals(entityName) || "fl_leasecontractbill".equals(entityName)) && EmptyUtil.isNoEmpty((DynamicObject)(loanApplyDo = TmcDataServiceHelper.loadSingle((String)"cfm_loan_apply", (QFilter[])(qFilter = new QFilter("billno", "=", this.getModel().getValue("lenderapplyno"))).toArray())))) {
                    creditUseBill = CreditLimitServiceHelper.getCreditUseBill((Long)loanApplyDo.getLong("id"), (String)"cfm_loan_apply");
                }
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(guaranteeUseBills2 = GuaranteeUseHelper.getGuaranteeUseBills((Long)((DynamicObject)newValue).getLong("id"))))) {
                    this.createNewEntryRow(guaranteeUseBills2, creditUseBill, bizAmountProp, bankSyncMap);
                }
            }
            this.setEnable();
        }
    }

    protected void setEnable() {
        for (int rowIndex = 0; rowIndex < this.getModel().getEntryRowCount("entry_gcontract"); ++rowIndex) {
            if (!((Boolean)this.getModel().getValue("gcreditguarantee", rowIndex)).booleanValue()) continue;
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"gcontract", "gexchrate", "gcomment"});
        }
    }

    protected void createNewEntryRow(DynamicObjectCollection guaranteeUseBills, DynamicObject creditUseBill, String bizAmountProp, Map<String, Object> bankSyncMap) {
        DynamicObject bizCcy;
        BigDecimal bizAmount = (BigDecimal)this.getModel().getValue(bizAmountProp);
        if (!bankSyncMap.isEmpty()) {
            bizAmount = (BigDecimal)bankSyncMap.get("gsrcbizamount");
        }
        int scale = EmptyUtil.isNoEmpty((DynamicObject)(bizCcy = (DynamicObject)this.getModel().getValue(GuaranteeUseHelper.getBizPropName((String)this.getModel().getDataEntityType().getName(), (String)"bizcurrency")))) ? bizCcy.getInt("amtprecision") : 6;
        BigDecimal sumRatio = guaranteeUseBills.stream().map(g -> g.getBigDecimal("gratio")).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (EmptyUtil.isNoEmpty((DynamicObject)creditUseBill)) {
            sumRatio = guaranteeUseBills.stream().map(g -> g.getBigDecimal("gratio").multiply(creditUseBill.getBigDecimal("creditratio")).divide(Constants.ONE_HUNDRED)).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        BigDecimal sumAmount = BigDecimal.ZERO;
        for (int i = 0; i < guaranteeUseBills.size(); ++i) {
            BigDecimal rate;
            boolean diffCurrency;
            BigDecimal gAmount;
            DynamicObject guaranteeUseBill = (DynamicObject)guaranteeUseBills.get(i);
            int index = this.getModel().createNewEntryRow("entry_gcontract");
            this.getModel().setValue("gcontract", guaranteeUseBill.get("gcontract"), index);
            if (!bankSyncMap.isEmpty()) {
                this.getModel().setValue("gcreditortype", bankSyncMap.get("gcreditortype"), index);
                this.getModel().setValue("gcreditor", bankSyncMap.get("gcreditor"), index);
                this.getModel().setValue("gcreditortext", bankSyncMap.get("gcreditortext"), index);
            }
            BigDecimal gRatio = guaranteeUseBill.getBigDecimal("gratio");
            if (EmptyUtil.isNoEmpty((DynamicObject)creditUseBill)) {
                gRatio = gRatio.multiply(creditUseBill.getBigDecimal("creditratio")).divide(Constants.ONE_HUNDRED);
            }
            this.getModel().setValue("gratio", (Object)gRatio, index);
            if (Constants.ONE_HUNDRED.compareTo(sumRatio) == 0 && i == guaranteeUseBills.size() - 1) {
                gAmount = bizAmount.subtract(sumAmount);
            } else {
                gAmount = bizAmount.multiply(gRatio).divide(Constants.ONE_HUNDRED, scale, RoundingMode.HALF_UP);
                sumAmount = sumAmount.add(gAmount);
            }
            this.getModel().setValue("gamount", (Object)gAmount, index);
            this.getModel().setValue("gcomment", guaranteeUseBill.get("gcomment"), index);
            Long gCcyId = guaranteeUseBill.getLong("gcontract.currency");
            boolean bl = diffCurrency = bizCcy != null && !gCcyId.equals(bizCcy.getPkValue());
            if (diffCurrency) {
                String gOrgPropName = GuaranteeUseHelper.getBizPropName((String)this.getModel().getDataEntityType().getName(), (String)"debtor");
                DynamicObject company = (DynamicObject)this.getModel().getValue(gOrgPropName);
                Long debtorId = EmptyUtil.isNoEmpty((DynamicObject)company) ? Long.valueOf(company.getLong("id")) : (Long)this.getModel().getValue("debtor");
                rate = TmcBusinessBaseHelper.getExchangeRate((long)bizCcy.getLong("id"), (long)gCcyId, (long)debtorId, (Date)DateUtils.getCurrentDate());
            } else {
                rate = BigDecimal.ONE;
            }
            this.getModel().setValue("gexchrate", (Object)rate, index);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        if (e.isCancel()) {
            return;
        }
        if ("entry_gcontract".equals(e.getEntryProp().getName())) {
            if ("yes".equals(this.getView().getPageCache().get("isDeleteGuaranteeEntry"))) {
                this.getView().getPageCache().put("isDeleteGuaranteeEntry", "no");
                return;
            }
            for (int rowIndex : e.getRowIndexs()) {
                if (!((Boolean)this.getModel().getValue("gcreditguarantee", rowIndex)).booleanValue()) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6388\u4fe1\u643a\u5e26\u8fc7\u6765\u7684\u62c5\u4fdd\u4fe1\u606f\u4e0d\u53ef\u4ee5\u5220\u9664\u3002", (String)"CreditLimitLinkGuaranteePlugin_0", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
        }
    }
}

