/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.common.selectprop;

import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.util.EmptyUtil;

public class EntityFilterHelper {
    public static final String FILTER_TAG = "filterTag";
    public static final String BILL_NUMBER = "billNumber";
    public static final String ENTITY_BILLFILTER = "tmc_billfilter";

    public static void showBillFilterForm(String billNumber, String filterTag, IFormView view, IFormPlugin plugin, String actionId) {
        if (billNumber == null) {
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setFormId(ENTITY_BILLFILTER);
        parameter.setCustomParam(BILL_NUMBER, (Object)billNumber);
        parameter.setCustomParam(FILTER_TAG, (Object)filterTag);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack(plugin, actionId));
        view.showForm(parameter);
    }

    public static void initFilterGrid(IFormView formView, String filterGridName, String entityNumber) {
        if (EmptyUtil.isEmpty((String)entityNumber)) {
            return;
        }
        FilterGrid filterGrid = (FilterGrid)formView.getControl(filterGridName);
        filterGrid.setEntityNumber(entityNumber);
        filterGrid.SetValue(new FilterCondition());
        formView.updateView(filterGridName);
    }

    public static void loadFilterGrid(IFormView formView, String filterGridName, String filterTag) {
        if (EmptyUtil.isEmpty((String)filterTag)) {
            return;
        }
        FilterGrid filterGrid = (FilterGrid)formView.getControl(filterGridName);
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterTag, FilterCondition.class);
        if (filterCondition != null) {
            filterGrid.SetValue(filterCondition);
        }
    }

    public static String getFilterGridData(IFormView formView, String filterGridName) {
        FilterGrid filterGrid = (FilterGrid)formView.getControl(filterGridName);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        return SerializationUtils.toJsonString((Object)filterGridState.getFilterCondition());
    }

    public static QFilter getFilterGridFilter(String filterTag, String entityName) {
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterTag, FilterCondition.class);
        FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityName), filterCondition, true);
        fb.buildFilter(true);
        return fb.getQFilter();
    }
}

