/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.common.surety;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.SuretyHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public abstract class AbstractSuretyRepayEntryEdit
extends AbstractBasePlugIn
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        EntryGrid entry = (EntryGrid)this.getControl("entry_surety");
        if (entry != null) {
            entry.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initSuretyInfo();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "issuretyrepay": {
                this.isSuretyRepayEvt();
                break;
            }
        }
    }

    private void isSuretyRepayEvt() {
        if (this.getModel().getDataEntity().getBoolean("issuretyrepay")) {
            if (!this.checkSuretyRepay()) {
                return;
            }
            this.setSuretyInfo();
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"suretyrepayamt"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconap_surety"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap_surety"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"suretyrepayamt"});
            this.getModel().deleteEntryData("entry_surety");
        }
    }

    protected boolean checkSuretyRepay() {
        long debitCurrencyId = this.getDebitCurrencyId();
        DynamicObject surety = this.loadSurety();
        if (EmptyUtil.isEmpty((DynamicObject)surety) || EmptyUtil.isEmpty((Long)debitCurrencyId)) {
            return false;
        }
        long suretyCurrencyId = surety.getLong("currency");
        if (debitCurrencyId != suretyCurrencyId) {
            this.getModel().setValue("issuretyrepay", (Object)false);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u503a\u52a1\u5355\u636e\u5e01\u79cd\u4e0e\u4fdd\u8bc1\u91d1\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u8fdb\u884c\u62b5\u6263\u3002", (String)"AbstractSuretyRepayEntryEdit_0", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected DynamicObject loadSurety() {
        QFilter qFilter = new QFilter("entry.debtbillid", "=", (Object)this.getDebitBill().getLong("id"));
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        return QueryServiceHelper.queryOne((String)"fbd_suretybill", (String)"currency", (QFilter[])new QFilter[]{qFilter});
    }

    protected long getDebitCurrencyId() {
        DynamicObject debitBill = this.getDebitBill();
        if (EmptyUtil.isNoEmpty((DynamicObject)debitBill) && EmptyUtil.isNoEmpty((DynamicObject)debitBill.getDynamicObject(this.getDebitCurrencyProp()))) {
            return debitBill.getDynamicObject(this.getDebitCurrencyProp()).getLong("id");
        }
        return 0L;
    }

    protected abstract String getDebitCurrencyProp();

    protected void initSuretyInfo() {
        this.setSuretyInfo();
        this.setSuretyEntryVisible();
        this.getModel().setDataChanged(false);
    }

    protected void setSuretyInfo() {
        DynamicObject suretyBill = this.getSuretyBill();
        if (EmptyUtil.isEmpty((DynamicObject)suretyBill)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"issuretyrepay"});
            this.getModel().setValue("issuretyrepay", (Object)false);
            this.getModel().deleteEntryData("entry_surety");
            return;
        }
        this.fillEntryData(suretyBill);
        this.setEntryFiledEnable();
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"issuretyrepay"});
    }

    protected void setSuretyEntryVisible() {
        if (this.getModel().getDataEntity().getBoolean("issuretyrepay")) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconap_surety"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"suretyrepayamt"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap_surety"});
        }
    }

    private DynamicObject getSuretyBill() {
        DynamicObject debtBill = this.getDebitBill();
        if (EmptyUtil.isEmpty((DynamicObject)debtBill)) {
            return null;
        }
        return SuretyHelper.loadSuretyBillByDebit((Long)debtBill.getLong("id"));
    }

    protected abstract DynamicObject getDebitBill();

    private void fillEntryData(DynamicObject suretyBill) {
        ArrayList<HashMap<String, Object>> suretyEntryList = new ArrayList<HashMap<String, Object>>(1);
        HashMap<String, Object> suretyEntry = new HashMap<String, Object>(16);
        DynamicObjectCollection exitSuretyEntries = this.getModel().getEntryEntity("entry_surety");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)exitSuretyEntries)) {
            AbstractSuretyRepayEntryEdit.setSuretyEntry(suretyBill, suretyEntry);
            suretyEntryList.add(suretyEntry);
        } else {
            AbstractSuretyRepayEntryEdit.setSuretyEntry(suretyBill, suretyEntry);
            suretyEntry.put("suretyrepayamt", ((DynamicObject)exitSuretyEntries.get(0)).get("suretyrepayamt"));
            suretyEntryList.add(suretyEntry);
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TmcViewInputHelper.batchFillEntity((String)"entry_surety", (AbstractFormDataModel)model, suretyEntryList);
        model.endInit();
        this.getView().updateView("entry_surety");
    }

    private static void setSuretyEntry(DynamicObject suretyBill, Map<String, Object> suretyEntry) {
        suretyEntry.put("suretybill", suretyBill);
        suretyEntry.put("suretyinvestorgtype", suretyBill.getString("investorgtype"));
        suretyEntry.put("suretyfinorg", suretyBill.get("finorginfo"));
        suretyEntry.put("suretyfinorgother", suretyBill.getString("finorgother"));
        suretyEntry.put("suretyaccount", suretyBill.get("settleaccount"));
        suretyEntry.put("suretycurrency", suretyBill.get("currency"));
        suretyEntry.put("suretyamount", suretyBill.getBigDecimal("amount"));
        suretyEntry.put("suretysurplusamount", suretyBill.getBigDecimal("surplusamount"));
        suretyEntry.put("suretyintdate", suretyBill.getDate("intdate"));
        suretyEntry.put("suretyterm", suretyBill.getString("term"));
        suretyEntry.put("suretyexpiredate", suretyBill.getDate("expiredate"));
    }

    private void setEntryFiledEnable() {
        int index = this.getModel().getEntryRowCount("entry_surety");
        for (int i = 0; i < index; ++i) {
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"suretybill", "suretyinvestorgtype", "suretyfinorg", "suretyfinorgother", "suretyaccount", "suretycurrency", "suretyamount", "suretysurplusamount", "suretyintdate", "suretyterm", "suretyexpiredate"});
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName;
        switch (fieldName = evt.getFieldName()) {
            case "suretybill": {
                int rowIndex = evt.getRowIndex();
                if (rowIndex <= -1) break;
                DynamicObject entry = this.getModel().getEntryRowEntity("entry_surety", rowIndex);
                DynamicObject suretyBill = entry.getDynamicObject("suretybill");
                if (EmptyUtil.isNoEmpty((DynamicObject)suretyBill)) {
                    BillShowParameter parameter = new BillShowParameter();
                    parameter.setFormId("fbd_suretybill");
                    parameter.setPkId((Object)suretyBill.getLong("id"));
                    parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    parameter.setStatus(OperationStatus.VIEW);
                    this.getView().showForm((FormShowParameter)parameter);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AbstractSuretyRepayEntryEdit_1", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }
}

