/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.common.surety;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillSourceEnum;
import kd.tmc.fbp.common.enums.GuaranteeWayEnum;
import kd.tmc.fbp.common.enums.OppUnitTypeEnum;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.helper.GuaranteeEntryHelper;
import kd.tmc.fbp.common.helper.SuretyHelper;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyBizEntryPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(SuretyBizEntryPlugin.class);
    protected final String[] STPROPS = new String[]{"finorginfo", "currency", "amount", "surplusamount", "finorgother", "investorgtype", "settleaccount", "intdate", "term", "expiredate", "entry.debtbillid", "entry.suretysource"};

    public void registerListener(EventObject e) {
        TextEdit finOrgOther;
        EntryGrid entry;
        BasedataEdit suretyBill;
        BasedataEdit account = (BasedataEdit)this.getControl("suretyaccount");
        if (EmptyUtil.isNoEmpty((Object)account)) {
            account.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (EmptyUtil.isNoEmpty((Object)(suretyBill = (BasedataEdit)this.getControl("suretybill")))) {
            suretyBill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entry = (EntryGrid)this.getControl("entry_surety")) != null) {
            entry.addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((finOrgOther = (TextEdit)this.getControl("suretyfinorgother")) != null) {
            finOrgOther.addClickListener((ClickListener)this);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "suretyfinorgother": {
                this.dealFinOrgOther();
                break;
            }
        }
    }

    private void dealFinOrgOther() {
        int indexRow = this.getModel().getEntryCurrentRowIndex("entry_surety");
        DynamicObject rowInfo = this.getModel().getEntryRowEntity("entry_surety", indexRow);
        String investOrgType = rowInfo.getString("suretyinvestorgtype");
        if (OppUnitTypeEnum.OTHER.getValue().equals(investOrgType)) {
            return;
        }
        BasedataEdit control = (BasedataEdit)this.getControl("suretyfinorg");
        control.click();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        block3: {
            String entryName;
            block2: {
                super.afterAddRow(e);
                EntryProp entryProp = e.getEntryProp();
                entryName = entryProp.getName();
                if (!"entry_surety".equals(entryName)) break block2;
                for (RowDataEntity row : e.getRowDataEntities()) {
                    int index = row.getRowIndex();
                    if (index < 0) continue;
                    this.newSuretyEntry(index);
                }
                break block3;
            }
            if (!"entryentity1".equals(entryName)) break block3;
            String notePool = ResManager.loadKDString((String)"\u7968\u636e\u6c60", (String)"SuretyBizEntryPlugin_4", (String)"tmc-fbp-formplugin", (Object[])new Object[0]);
            for (RowDataEntity row : e.getRowDataEntities()) {
                int index = row.getRowIndex();
                if (index < 0) continue;
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"guaranteetype1", (Object)notePool, (int)index);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean loadEntry = BillChangeHistoryHelper.loadEntrysInfo((IFormView)this.getView());
        if (loadEntry) {
            return;
        }
        Object pk = this.getModel().getDataEntity().getPkValue();
        if (EmptyUtil.isEmpty((Object)pk)) {
            return;
        }
        if (TmcDataServiceHelper.exists((Object)pk, (String)this.getModel().getDataEntityType().getName())) {
            this.loadSurety();
        }
        this.setEntryEnable();
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String propName = event.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        if ("suretyaccount".equals(propName)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entry_surety");
            if (StringUtils.equals((CharSequence)((String)this.getModel().getValue("suretyinvestorgtype")), (CharSequence)OppUnitTypeEnum.FINORGINFO.getValue())) {
                String orgProp;
                DynamicObject currency;
                DynamicObject suretyFinOrg = (DynamicObject)this.getModel().getValue("suretyfinorg", rowIndex);
                if (EmptyUtil.isNoEmpty((DynamicObject)suretyFinOrg)) {
                    showParameter.getListFilterParameter().getQFilters().add(new QFilter("bank", "=", suretyFinOrg.getPkValue()));
                }
                if (EmptyUtil.isNoEmpty((DynamicObject)(currency = (DynamicObject)this.getModel().getValue("suretycurrency", rowIndex)))) {
                    showParameter.getListFilterParameter().getQFilters().add(new QFilter("currency.fbasedataid.id", "=", currency.getPkValue()));
                }
                if (EmptyUtil.isEmpty((String)(orgProp = this.getBizPropName("org")))) {
                    return;
                }
                DynamicObject org = (DynamicObject)this.getModel().getValue(orgProp);
                if (EmptyUtil.isNoEmpty((DynamicObject)org)) {
                    showParameter.getListFilterParameter().getQFilters().add(new QFilter("company", "=", org.getPkValue()));
                }
            }
        } else if ("suretybill".equals(propName)) {
            QFilter suretyFilter;
            String orgProp = this.getBizPropName("org");
            if (EmptyUtil.isEmpty((String)orgProp)) {
                return;
            }
            DynamicObject org = (DynamicObject)this.getModel().getValue(orgProp);
            ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
            if (EmptyUtil.isNoEmpty((DynamicObject)org)) {
                filters.add(new QFilter("org", "=", org.getPkValue()));
            }
            if (Arrays.asList("lc_lettercredit", "lc_lettercredit_init").contains(this.getModel().getDataEntityType().getName())) {
                String guaWay = (String)this.getModel().getValue("guarantee");
                List guaWayList = Arrays.stream(guaWay.split(",")).filter(r -> EmptyUtil.isNoEmpty((String)r)).collect(Collectors.toList());
                BigDecimal proMisRate = (BigDecimal)this.getModel().getValue("promisrate");
                if (!guaWayList.contains(GuaranteeWayEnum.ENSUAMT.getNumberValue()) || EmptyUtil.isEmpty((BigDecimal)proMisRate) || proMisRate.compareTo(Constants.ZERO) == 0) {
                    filters.add(QFilter.of((String)"1!=1", (Object[])new Object[0]));
                }
            }
            if (this.getModel().getDataEntity().containsProperty("suretycur") && EmptyUtil.isNoEmpty((DynamicObject)((DynamicObject)this.getModel().getValue("suretycur")))) {
                filters.add(new QFilter("currency", "=", ((DynamicObject)this.getModel().getValue("suretycur")).getPkValue()));
            }
            if (this.getModel().getDataEntity().containsProperty("suretymoney") && EmptyUtil.isNoEmpty((BigDecimal)((BigDecimal)this.getModel().getValue("suretymoney")))) {
                filters.add(new QFilter("surplusamount", ">=", this.getModel().getValue("suretymoney")));
            }
            if (StringUtils.equals((CharSequence)"cfm_creditlimit", (CharSequence)this.getModel().getDataEntityType().getName())) {
                DynamicObjectCollection notCloseSureties = QueryServiceHelper.query((String)"fbd_suretybill", (String)"id", (QFilter[])new QFilter[]{new QFilter(String.join((CharSequence)".", "entry_credit", "creditbillid", "isclose"), "=", (Object)false)});
                List notCloseIds = notCloseSureties.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
                suretyFilter = new QFilter("investvarieties.islimitsurety", "=", (Object)true).and(new QFilter(String.join((CharSequence)".", "entry_credit", "creditbillid"), "is null", null).or(new QFilter(String.join((CharSequence)".", "entry_credit", "creditbillid"), "is not null", null).and("id", "not in", notCloseIds)));
            } else {
                suretyFilter = new QFilter("investvarieties.islimitsurety", "=", (Object)false);
            }
            DynamicObjectCollection suretyIds = QueryServiceHelper.query((String)"fbd_suretybill", (String)"id", (QFilter[])new QFilter[]{suretyFilter});
            filters.add(new QFilter("id", "in", suretyIds.stream().map(d -> d.getLong("id")).collect(Collectors.toList())));
            logger.info("suretyBill filters:" + ((Object)filters).toString());
            showParameter.setMultiSelect(false);
            showParameter.getListFilterParameter().getQFilters().addAll(filters);
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        boolean rightFormat;
        Control source = (Control)e.getSource();
        String fieldName = source.getKey();
        int rowIndex = e.getRowIndex();
        Object value = e.getValue();
        if (EmptyUtil.isEmpty((Object)value)) {
            return;
        }
        if ("suretyterm".equals(fieldName) && !(rightFormat = TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)value.toString()))) {
            this.getView().updateView(fieldName, rowIndex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyName) {
            case "suretybill": {
                this.suretyBillChgEvt(rowIndex, newValue);
                break;
            }
            case "suretyintdate": {
                this.intDateChgEvt(rowIndex);
                break;
            }
            case "suretyterm": {
                this.calExpireDate(rowIndex);
                break;
            }
            case "suretyexpiredate": {
                this.calTermOrIntDate(rowIndex);
                break;
            }
            case "suretyfinorg": {
                this.clearPropsValue(rowIndex, "suretyaccount");
                this.fillSuretyFinOrgOther(rowIndex, (DynamicObject)newValue);
                break;
            }
            case "suretyinvestorgtype": {
                this.clearPropsValue(rowIndex, "suretyfinorg", "suretyfinorgother");
                break;
            }
            case "suretycurrency": {
                this.clearPropsValue(rowIndex, "suretyaccount");
                break;
            }
        }
    }

    private void fillSuretyFinOrgOther(int rowIndex, DynamicObject finOrgInfo) {
        if (EmptyUtil.isNoEmpty((DynamicObject)finOrgInfo)) {
            this.getModel().setValue("suretyfinorgother", finOrgInfo.get("name"), rowIndex);
        }
    }

    private void clearPropsValue(int row, String ... fields) {
        for (String field : fields) {
            this.getModel().setValue(field, null, row);
        }
    }

    private void calTermOrIntDate(int rowIndex) {
        Date expireDate = (Date)this.getModel().getValue("suretyexpiredate", rowIndex);
        Date intDate = (Date)this.getModel().getValue("suretyintdate", rowIndex);
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{intDate, expireDate})) {
            return;
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"suretyterm", (Object)TermHelper.callTermLargeEqualZore((Date)intDate, (Date)expireDate), (int)rowIndex);
    }

    private void intDateChgEvt(int rowIndex) {
        this.calExpireDate(rowIndex);
        Date intDate = (Date)this.getModel().getValue("suretyintdate", rowIndex);
        if (EmptyUtil.isNoEmpty((Object)intDate)) {
            DateEdit expireDateEdit = (DateEdit)this.getView().getFlexControl("suretyexpiredate", rowIndex);
            expireDateEdit.setMinDate(DateUtils.getNextDay((Date)intDate, (int)1));
        }
    }

    private void calExpireDate(int rowIndex) {
        Date intDate = (Date)this.getModel().getValue("suretyintdate", rowIndex);
        String term = (String)this.getModel().getValue("suretyterm", rowIndex);
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{intDate, term})) {
            return;
        }
        Date expireDate = TermHelper.getDateByBaseDate4ymd((String)term, (Date)intDate);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"suretyexpiredate", (Object)expireDate, (int)rowIndex);
    }

    private void suretyBillChgEvt(int rowIndex, Object newValue) {
        if (EmptyUtil.isNoEmpty((Object)newValue)) {
            DynamicObject suretyBill = (DynamicObject)this.getModel().getValue("suretybill", rowIndex);
            if (EmptyUtil.isNoEmpty((Object)newValue)) {
                this.setOrgTypeComboItem();
            } else {
                this.setOrgTypeComboItemWithOutOther();
            }
            if (this.haveSelect(suretyBill, rowIndex)) {
                this.getModel().setValue("suretybill", null, rowIndex);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u8fc7\u8be5\u4fdd\u8bc1\u91d1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SuretyBizEntryPlugin_1", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().setValue("suretyinvestorgtype", (Object)suretyBill.getString("investorgtype"), rowIndex);
            this.getModel().setValue("suretyfinorg", (Object)suretyBill.getDynamicObject("finorginfo"), rowIndex);
            this.getModel().setValue("suretyfinorgother", (Object)suretyBill.getString("finorgother"), rowIndex);
            this.getModel().setValue("suretyaccount", (Object)suretyBill.getDynamicObject("settleaccount"), rowIndex);
            this.getModel().setValue("suretycurrency", (Object)suretyBill.getDynamicObject("currency"), rowIndex);
            this.getModel().setValue("suretyamount", (Object)suretyBill.getBigDecimal("amount"), rowIndex);
            this.getModel().setValue("suretysurplusamount", (Object)suretyBill.getBigDecimal("surplusamount"), rowIndex);
            this.getModel().setValue("suretyintdate", (Object)suretyBill.getDate("intdate"), rowIndex);
            this.getModel().setValue("suretyterm", (Object)suretyBill.getString("term"), rowIndex);
            this.getModel().setValue("suretyexpiredate", (Object)suretyBill.getDate("expiredate"), rowIndex);
            this.getModel().setValue("suretysource", (Object)BillSourceEnum.HAND.getValue(), rowIndex);
            if (this.getModel().getDataEntity().containsProperty("suretycur")) {
                this.getModel().setValue("suretycur", suretyBill.get("currency"));
            }
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"suretyfinorg", "suretyinvestorgtype", "suretyfinorgother", "suretyaccount", "suretycurrency", "suretyamount", "suretysurplusamount", "suretyintdate", "suretyterm", "suretyexpiredate", "suretysource"});
        } else {
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (int)rowIndex, (String[])new String[]{"suretyinvestorgtype", "suretyfinorg", "suretyfinorgother", "suretyaccount", "suretycurrency", "suretyamount", "suretysurplusamount", "suretyintdate", "suretyterm", "suretyexpiredate", "suretysource"});
        }
    }

    private boolean haveSelect(DynamicObject suretyBill, int rowIndex) {
        Long id = (Long)suretyBill.getPkValue();
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry_surety");
        for (int i = 0; i < entrys.size(); ++i) {
            Long existId;
            DynamicObject entry;
            DynamicObject existSuretyBill;
            if (i == rowIndex || !EmptyUtil.isNoEmpty((DynamicObject)(existSuretyBill = (entry = (DynamicObject)entrys.get(i)).getDynamicObject("suretybill"))) || !id.equals(existId = (Long)existSuretyBill.getPkValue())) continue;
            return true;
        }
        return false;
    }

    private void loadSurety() {
        Long id = this.getSuretySrcbillid();
        logger.info("loadSurety is srat:" + id);
        if (EmptyUtil.isEmpty((Long)id)) {
            return;
        }
        QFilter idFilter = StringUtils.equals((CharSequence)"cfm_creditlimit", (CharSequence)this.getModel().getDataEntityType().getName()) ? new QFilter("entry_credit.creditbillid", "=", (Object)id) : new QFilter("entry.debtbillid", "=", (Object)id);
        Object[] suretyBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)String.join((CharSequence)",", this.STPROPS), (QFilter[])new QFilter[]{idFilter});
        if (EmptyUtil.isEmpty((Object[])suretyBills)) {
            String name = this.getModel().getDataEntityType().getName();
            logger.info("start to check:" + name);
            if ("cdm_payablebill".equals(name)) {
                id = this.getSourcebillid();
                if (EmptyUtil.isEmpty((Long)id)) {
                    logger.info("getSourcebillid id is null:");
                    return;
                }
                logger.info("start to check by sourceid" + id);
                idFilter = new QFilter("entry.debtbillid", "=", (Object)id);
                suretyBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)String.join((CharSequence)",", this.STPROPS), (QFilter[])new QFilter[]{idFilter});
            }
        } else {
            logger.info("fisrt suretyBills is null");
        }
        if (EmptyUtil.isEmpty((Object[])suretyBills)) {
            logger.info("second suretyBills is null");
            return;
        }
        logger.info(" suretyBills is not null");
        ArrayList suretyEntryList = new ArrayList(suretyBills.length);
        for (Object suretyBill : suretyBills) {
            HashMap<String, Object> suretyEntry = new HashMap<String, Object>(16);
            suretyEntry.put("suretybill", suretyBill.getPkValue());
            suretyEntry.put("suretyfinorg", suretyBill.getDynamicObject("finorginfo"));
            suretyEntry.put("suretyfinorgother", suretyBill.getString("finorgother"));
            suretyEntry.put("suretyinvestorgtype", suretyBill.getString("investorgtype"));
            suretyEntry.put("suretycurrency", suretyBill.getDynamicObject("currency"));
            suretyEntry.put("suretyamount", suretyBill.getBigDecimal("amount"));
            suretyEntry.put("suretysurplusamount", suretyBill.getBigDecimal("surplusamount"));
            suretyEntry.put("suretyaccount", suretyBill.getDynamicObject("settleaccount"));
            suretyEntry.put("suretyintdate", suretyBill.getDate("intdate"));
            suretyEntry.put("suretyterm", suretyBill.getString("term"));
            suretyEntry.put("suretyexpiredate", suretyBill.getDate("expiredate"));
            suretyEntry.put("suretysource", this.getSuretySource(id, (DynamicObject)suretyBill));
            suretyEntryList.add(suretyEntry);
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        boolean dataChanged = this.getModel().getDataChanged();
        model.beginInit();
        TmcViewInputHelper.batchFillEntity((String)"entry_surety", (AbstractFormDataModel)model, suretyEntryList);
        GuaranteeEntryHelper.setCreditGuarantee((IDataModel)this.getModel());
        model.endInit();
        this.getView().updateView("entry_surety");
        this.getModel().setDataChanged(dataChanged);
        logger.info("loadSurety end");
    }

    private String getSuretySource(Long id, DynamicObject suretyBill) {
        DynamicObjectCollection entrys = suretyBill.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entrys) {
            Long debtBillId = entry.getLong("debtbillid");
            if (!id.equals(debtBillId)) continue;
            return entry.getString("suretysource");
        }
        return BillSourceEnum.HAND.getValue();
    }

    private void newSuretyEntry(int index) {
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"suretysource", (Object)BillSourceEnum.HAND.getValue(), (int)index);
        this.setOrgTypeComboItemWithOutOther();
    }

    private void setOrgTypeComboItemWithOutOther() {
        ComboEdit investOrgTypeCombo = (ComboEdit)this.getControl("suretyinvestorgtype");
        if (EmptyUtil.isEmpty((Object)investOrgTypeCombo)) {
            return;
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(3);
        comboItems.add(new ComboItem(new LocaleString(OppUnitTypeEnum.FINORGINFO.getName()), OppUnitTypeEnum.FINORGINFO.getValue()));
        comboItems.add(new ComboItem(new LocaleString(OppUnitTypeEnum.CUSTOMER.getName()), OppUnitTypeEnum.CUSTOMER.getValue()));
        comboItems.add(new ComboItem(new LocaleString(OppUnitTypeEnum.SUPPLIER.getName()), OppUnitTypeEnum.SUPPLIER.getValue()));
        investOrgTypeCombo.setComboItems(comboItems);
    }

    private void setOrgTypeComboItem() {
        ComboEdit investOrgTypeCombo = (ComboEdit)this.getControl("suretyinvestorgtype");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(3);
        comboItems.add(new ComboItem(new LocaleString(OppUnitTypeEnum.FINORGINFO.getName()), OppUnitTypeEnum.FINORGINFO.getValue()));
        comboItems.add(new ComboItem(new LocaleString(OppUnitTypeEnum.CUSTOMER.getName()), OppUnitTypeEnum.CUSTOMER.getValue()));
        comboItems.add(new ComboItem(new LocaleString(OppUnitTypeEnum.SUPPLIER.getName()), OppUnitTypeEnum.SUPPLIER.getValue()));
        comboItems.add(new ComboItem(new LocaleString(OppUnitTypeEnum.OTHER.getName()), OppUnitTypeEnum.OTHER.getValue()));
        investOrgTypeCombo.setComboItems(comboItems);
    }

    protected String getBizPropName(String prop) {
        String entityName = this.getModel().getDataEntityType().getName();
        return SuretyHelper.getBizPropName((String)entityName, (String)prop);
    }

    protected Long getSuretySrcbillid() {
        return (Long)this.getModel().getValue("id");
    }

    protected Long getSourcebillid() {
        Long entryId = (Long)this.getModel().getValue("sourcebillid");
        logger.info("sourcebillid is:" + entryId);
        if (EmptyUtil.isEmpty((Long)entryId) || entryId == 0L) {
            return null;
        }
        QFilter idFilter = new QFilter("entryentity.id", "=", (Object)entryId);
        DynamicObject payableBillApply = QueryServiceHelper.queryOne((String)"cdm_payablebill_ap_manual", (String)"id", (QFilter[])new QFilter[]{idFilter});
        if (EmptyUtil.isEmpty((DynamicObject)payableBillApply)) {
            logger.info("start to check cdm_payablebill_apply");
            QFilter oldIdFilter = new QFilter("id", "=", (Object)entryId);
            payableBillApply = QueryServiceHelper.queryOne((String)"cdm_payablebill_apply", (String)"id", (QFilter[])new QFilter[]{oldIdFilter});
            if (EmptyUtil.isEmpty((DynamicObject)payableBillApply)) {
                logger.info("check cdm_payablebill_apply is null");
                return null;
            }
        } else {
            logger.info("check cdm_payablebill_ap_manual has result");
        }
        return payableBillApply.getLong("id");
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName;
        switch (fieldName = evt.getFieldName()) {
            case "suretybill": {
                int rowIndex = evt.getRowIndex();
                if (rowIndex <= -1) break;
                DynamicObject entry = this.getModel().getEntryRowEntity("entry_surety", rowIndex);
                DynamicObject suretyBill = entry.getDynamicObject("suretybill");
                if (EmptyUtil.isNoEmpty((DynamicObject)suretyBill)) {
                    BillShowParameter parameter = new BillShowParameter();
                    parameter.setFormId("fbd_suretybill");
                    parameter.setPkId((Object)suretyBill.getLong("id"));
                    parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    parameter.setStatus(OperationStatus.VIEW);
                    this.getView().showForm((FormShowParameter)parameter);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SuretyBizEntryPlugin_2", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "addsuretyentry": {
                if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)this.getModel().getEntryEntity("entry_surety"))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u6dfb\u52a0\u4e00\u6761\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u3002", (String)"SuretyBizEntryPlugin_3", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "save": 
            case "submit": {
                if (this.getModel().getEntryRowCount("entry_surety") > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u6dfb\u52a0\u4e00\u6761\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u3002", (String)"SuretyBizEntryPlugin_3", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                formOperate.getOption().setVariableValue("formId", ((BillView)this.getView()).getFormId());
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "addsuretyentry": {
                this.addSuretyEvent();
                break;
            }
        }
    }

    private void addSuretyEvent() {
        this.setEntryEnable();
    }

    private void setEntryEnable() {
        int entryRowCount = this.getModel().getEntryRowCount("entry_surety");
        for (int i = 0; i < entryRowCount; ++i) {
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"suretyfinorg", "suretyfinorgother", "suretyinvestorgtype", "suretycurrency", "suretyamount", "suretyinvestorgtype", "suretysurplusamount", "suretyaccount", "suretyintdate", "suretyterm", "suretyexpiredate", "suretysource"});
        }
    }
}

