/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.common.surety;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.SuretyHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class SuretyBizListPlugin
extends AbstractTmcBillBaseList {
    private static final List<String> rewriteBill = Arrays.asList("cfm_creditlimit", "lc_lettercredit");
    private static final String BILL_NO = "billno";
    private static final String IS_EDIT_SURETY_AMOUNT = "iseditsuretyamount";
    private static final String PAYABLE_APPLY_PROPS = String.join((CharSequence)",", "billno", "iseditsuretyamount", "id");

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "suretyconfigm": {
                if (EmptyUtil.isEmpty((Long)this.getSelectedId()) || !this.checkBeforeSurety()) {
                    args.setCancel(true);
                    return;
                }
                formOperate.getOption().setVariableValue("formId", this.getBillFormId());
                break;
            }
            case "suretyrelease": {
                if (!EmptyUtil.isEmpty((Long)this.getSelectedId()) && this.checkBeforeSuretyRelease()) break;
                args.setCancel(true);
                return;
            }
            case "suretyappend": {
                if (!EmptyUtil.isEmpty((Long)this.getSelectedId()) && this.checkBeforeSuretyAppend()) break;
                args.setCancel(true);
                return;
            }
            case "submit": {
                formOperate.getOption().setVariableValue("op_from_list_form", this.getView().getModel().getDataEntityType().getName());
                formOperate.getOption().setVariableValue("formId", this.getBillFormId());
                break;
            }
            case "viewsurety": {
                if (this.checkViewSurety()) break;
                args.setCancel(true);
                break;
            }
        }
    }

    private boolean checkViewSurety() {
        if (!QueryServiceHelper.exists((String)"fbd_suretybill", (QFilter[])new QFilter[]{this.getSuretyFilter()})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5173\u8054\u4fdd\u8bc1\u91d1\u3002", (String)"SuretyRepayListPlugin_5", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public boolean checkBeforeSurety() {
        return true;
    }

    public boolean checkBeforeSuretyRelease() {
        return true;
    }

    public boolean checkBeforeSuretyAppend() {
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "suretyconfigm": {
                if (!args.getOperationResult().isSuccess()) break;
                this.suretyConfirm();
                break;
            }
            case "suretyappend": {
                if (!args.getOperationResult().isSuccess()) break;
                this.suretyAppend();
                break;
            }
            case "suretyrelease": {
                if (!args.getOperationResult().isSuccess()) break;
                this.suretyRelease();
                break;
            }
            case "viewsurety": {
                if (!args.getOperationResult().isSuccess()) break;
                this.viewSuretyEvt();
                break;
            }
            case "save": 
            case "submit": {
                if (!args.getOperationResult().isSuccess()) break;
                this.updateIsSuretyInfoTrue();
                break;
            }
        }
    }

    private void viewSuretyEvt() {
        this.viewSuretyListForm();
        if (this.isViewSuretyRelease()) {
            this.viewSuretyReleaseListForm();
        }
    }

    protected boolean isViewSuretyRelease() {
        return false;
    }

    private void updateIsSuretyInfoTrue() {
        if (!rewriteBill.contains(this.getDataEntityName())) {
            return;
        }
        List<Long> lcIds = this.getAlreadySuretyId();
        this.saveIsSuretyInfo(true, lcIds);
    }

    private List<Long> getAlreadySuretyId() {
        List<Long> selectedIdList = this.getSelectedIdList();
        if ("cfm_creditlimit".equals(this.getDataEntityName())) {
            DynamicObjectCollection suretyBills = QueryServiceHelper.query((String)"fbd_suretybill", (String)String.join((CharSequence)".", "entry_credit", "creditbillid"), (QFilter[])new QFilter[]{new QFilter(String.join((CharSequence)".", "entry_credit", "creditbillid"), "in", selectedIdList)});
            return suretyBills.stream().map(d -> d.getLong(String.join((CharSequence)".", "entry_credit", "creditbillid"))).collect(Collectors.toList());
        }
        DynamicObjectCollection suretyBills = QueryServiceHelper.query((String)"fbd_suretybill", (String)String.join((CharSequence)".", "entry", "debtbillid"), (QFilter[])new QFilter[]{new QFilter(String.join((CharSequence)".", "entry", "debtbillid"), "in", selectedIdList).and(String.join((CharSequence)".", "entry", "debttype"), "=", (Object)this.getDataEntityName())});
        return suretyBills.stream().map(d -> d.getLong(String.join((CharSequence)".", "entry", "debtbillid"))).collect(Collectors.toList());
    }

    private void saveIsSuretyInfo(boolean isSurety, List<Long> idList) {
        Object[] isSuretyChangeList = TmcDataServiceHelper.load((String)this.getDataEntityName(), (String)"issurety", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
        Arrays.stream(isSuretyChangeList).forEach(d -> d.set("issurety", (Object)isSurety));
        if (EmptyUtil.isNoEmpty((Object[])isSuretyChangeList)) {
            SaveServiceHelper.save((DynamicObject[])isSuretyChangeList);
        }
    }

    private void viewSuretyListForm() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("fbd_suretybill");
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getListFilterParameter().setFilter(this.getSuretyFilter());
        parameter.getCustomParams().put("dataSource", "bizBill");
        this.getView().showForm((FormShowParameter)parameter);
    }

    private QFilter getSuretyFilter() {
        if ("cdm_payablebill_ap_manual".equals(this.getDataEntityName())) {
            List singleEntryIds;
            DynamicObjectCollection applyBills = QueryServiceHelper.query((String)this.getDataEntityName(), (String)PAYABLE_APPLY_PROPS, (QFilter[])new QFilter[]{new QFilter("id", "in", this.getDebitIds())});
            List multiEntries = applyBills.stream().filter(d -> d.getBoolean(IS_EDIT_SURETY_AMOUNT)).collect(Collectors.toList());
            QFilter qFilter = null;
            if (EmptyUtil.isNoEmpty(multiEntries)) {
                List isMultiEntryNos = multiEntries.stream().map(d -> d.getString(BILL_NO)).collect(Collectors.toList());
                qFilter = new QFilter("entry.applybillno", "in", isMultiEntryNos);
            }
            if (EmptyUtil.isNoEmpty(singleEntryIds = applyBills.stream().filter(d -> !d.getBoolean(IS_EDIT_SURETY_AMOUNT)).map(d -> d.getLong("id")).collect(Collectors.toList()))) {
                QFilter singleEntryFilter = new QFilter("entry.debtbillid", "in", singleEntryIds);
                if (null != qFilter) {
                    qFilter.or(singleEntryFilter);
                } else {
                    qFilter = singleEntryFilter;
                }
            }
            return qFilter;
        }
        return SuretyHelper.getBatchSuretyEntryFilter(this.getDebitIds(), (String)this.getBillFormId());
    }

    private void viewSuretyReleaseListForm() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("fbd_suretyreleasebill");
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        QFilter qFilter = new QFilter("repaybillid", "in", this.getRepayBillIds()).and("repaybilltype", "=", (Object)this.getDataEntityName());
        if (!QueryServiceHelper.exists((String)"fbd_suretyreleasebill", (QFilter[])new QFilter[]{qFilter})) {
            return;
        }
        parameter.setCustomParam("viewSurety", (Object)true);
        parameter.getListFilterParameter().setFilter(qFilter);
        parameter.getCustomParams().put("dataSource", "bizBill");
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected List<Long> getRepayBillIds() {
        return this.getSelectedIdList();
    }

    protected Long getRepayBillId() {
        return this.getSelectedId();
    }

    protected List<Long> getDebitIds() {
        return this.getSelectedIdList();
    }

    private void suretyConfirm() {
        QFilter qFilter = SuretyHelper.getSuretyEntryFilterWithSave((Long)this.getSelectedId(), (String)this.getBillFormId());
        qFilter.and("enable", "=", (Object)true);
        Object[] suretyBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)"id", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isNoEmpty((Object[])suretyBills)) {
            for (Object suretyBill : suretyBills) {
                this.showSuretyForm((DynamicObject)suretyBill);
            }
            this.updateIsSuretyStatus();
        }
    }

    private void updateIsSuretyStatus() {
        if (rewriteBill.contains(this.getDataEntityName())) {
            DynamicObject bizBill = TmcDataServiceHelper.loadSingle((String)this.getDataEntityName(), (String)"issurety", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getSelectedId())});
            bizBill.set("issurety", (Object)true);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizBill});
        }
    }

    private void suretyAppend() {
        Long selectedId = this.getSelectedId();
        QFilter qFilter = SuretyHelper.getSuretyEntryFilterWithSave((Long)selectedId, (String)this.getDataEntityName());
        Object[] suretyAppends = TmcDataServiceHelper.load((String)"fbd_surety_append", (String)"id", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isNoEmpty((Object[])suretyAppends)) {
            this.showSuretyForm((DynamicObject)suretyAppends[0]);
        }
    }

    private void suretyRelease() {
        Long selectedId = this.getSelectedId();
        QFilter qFilter = SuretyHelper.getSuretyEntryFilterWithSave((Long)selectedId, (String)this.getDataEntityName());
        Object[] suretyReleases = TmcDataServiceHelper.load((String)"fbd_suretyreleasebill", (String)"id", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isNoEmpty((Object[])suretyReleases)) {
            this.showSuretyForm((DynamicObject)suretyReleases[0]);
        }
    }

    private void showSuretyForm(DynamicObject suretyBill) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setFormId(suretyBill.getDataEntityType().getName());
        parameter.setPkId(suretyBill.getPkValue());
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

