/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.common.surety;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.SuretyHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class SuretyRepayListPlugin
extends AbstractTmcBillBaseList {
    private static final String SURETY_RELEASE_PROPS = String.join((CharSequence)",", "id", "amount", "billstatus", "repaybillid");
    private static final String BIZ_BILL_PROPS = "arrivalamount,arrivalno,arrivalcurrency,arrivaltype";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "suretyrepay": {
                if (this.checkSuretyRepay()) break;
                args.setCancel(true);
                break;
            }
            case "unaudit": {
                if (this.checkCanUnAudit()) break;
                args.setCancel(true);
                break;
            }
            case "viewsurety": {
                if (this.checkViewSurety()) break;
                args.setCancel(true);
                break;
            }
        }
    }

    private boolean checkViewSurety() {
        QFilter qFilter = SuretyHelper.getBatchSuretyEntryFilter(this.getSrcIds(), (String)this.getBillFormId());
        if (!QueryServiceHelper.exists((String)"fbd_suretybill", (QFilter[])new QFilter[]{qFilter})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5173\u8054\u4fdd\u8bc1\u91d1\u3002", (String)"SuretyRepayListPlugin_5", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkCanUnAudit() {
        List<Long> selectedIdList = this.getSelectedIdList();
        if (EmptyUtil.isEmpty(selectedIdList)) {
            return false;
        }
        for (Long id : selectedIdList) {
            if (!SuretyHelper.alreadySuretyRepay((Long)id, (String)this.getEntityId())) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6709\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"SuretyRepayListPlugin_2", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkSuretyRepay() {
        Long selectedId = this.getSelectedId();
        if (EmptyUtil.isEmpty((Long)selectedId)) {
            return false;
        }
        if (SuretyHelper.alreadySuretyRepay((Long)this.getCurrId(), (String)this.getEntityId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u4f7f\u7528\u8fc7\u4fdd\u8bc1\u91d1\u62b5\u6263\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u4f7f\u7528\u4fdd\u8bc1\u91d1\u62b5\u6263\u3002", (String)"SuretyRepayListPlugin_3", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "suretyrepay": {
                if (!args.getOperationResult().isSuccess()) break;
                this.suretyRepay();
                break;
            }
            case "cancelsuretyrepay": {
                if (!args.getOperationResult().isSuccess()) break;
                this.cancelSuretyRepay();
                break;
            }
            case "viewsurety": {
                this.viewSuretyEvt();
                break;
            }
        }
    }

    private void viewSuretyEvt() {
        this.viewSuretyListForm();
        this.viewSuretyReleaseListForm();
    }

    private void viewSuretyListForm() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("fbd_suretybill");
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        QFilter qFilter = SuretyHelper.getBatchSuretyEntryFilter(this.getSrcIds(), (String)this.getBillFormId());
        parameter.getListFilterParameter().setFilter(qFilter);
        parameter.getCustomParams().put("dataSource", "bizBill");
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void viewSuretyReleaseListForm() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("fbd_suretyreleasebill");
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        QFilter qFilter = new QFilter("repaybillid", "in", this.getSelectedIdList()).and("repaybilltype", "=", (Object)this.getDataEntityName());
        if (!QueryServiceHelper.exists((String)"fbd_suretyreleasebill", (QFilter[])new QFilter[]{qFilter})) {
            return;
        }
        parameter.setCustomParam("viewSurety", (Object)true);
        parameter.getListFilterParameter().setFilter(qFilter);
        parameter.getCustomParams().put("dataSource", "bizBill");
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void cancelSuretyRepay() {
        DynamicObjectCollection suretyReleases = SuretyRepayListPlugin.loadSuretyReleaseByRepayBill(this.getCurrId());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)suretyReleases)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4fdd\u8bc1\u91d1\u62b5\u6263\u8bb0\u5f55\u3002", (String)"SuretyRepayListPlugin_6", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            return;
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("debitType", this.getEntityId());
        List suretyIds = suretyReleases.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
        OperationResult suretyRepay = TmcOperateServiceHelper.execOperate((String)"cancelsuretyrepay", (String)"fbd_suretyreleasebill", (Object[])suretyIds.toArray(), (OperateOption)operateOption);
        if (suretyRepay.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u4fdd\u8bc1\u91d1\u62b5\u6263\u6210\u529f\u3002", (String)"SuretyRepayListPlugin_8", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
        }
    }

    public static DynamicObjectCollection loadSuretyReleaseByRepayBill(Long repayBillId) {
        QFilter qFilter = new QFilter("repaybillid", "=", (Object)repayBillId);
        return QueryServiceHelper.query((String)"fbd_suretyreleasebill", (String)SURETY_RELEASE_PROPS, (QFilter[])new QFilter[]{qFilter});
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (StringUtils.equals((CharSequence)"CLOSE_BACK_KEY_SURETY_REPAY", (CharSequence)evt.getActionId()) && null != evt.getReturnData()) {
            Map returnDataMap = (Map)evt.getReturnData();
            OperateOption operateOption = OperateOption.create();
            String returnData = SerializationUtils.toJsonString((Object)returnDataMap);
            operateOption.setVariableValue("returnDataMap", returnData);
            operateOption.setVariableValue("debitId", this.getCurrId().toString());
            operateOption.setVariableValue("debitType", this.getEntityId());
            Map dataMap = (Map)returnDataMap.get("valueMap");
            DynamicObject repayEntry = dataMap.values().stream().findFirst().orElse(null);
            if (EmptyUtil.isNoEmpty((DynamicObject)repayEntry)) {
                operateOption.setVariableValue("repayType", repayEntry.getString("deducttype"));
                operateOption.setVariableValue("repayIntAmt", repayEntry.getBigDecimal("repayintamount").toString());
            }
            operateOption.setVariableValue("suretyReleaseDebtBillIdStr", this.getSrcId().toString());
            List suretyId = dataMap.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList());
            OperationResult suretyRepay = TmcOperateServiceHelper.execOperate((String)"suretyrepay", (String)"fbd_suretybill", (Object[])suretyId.toArray(), (OperateOption)operateOption);
            if (suretyRepay.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u8bc1\u91d1\u62b5\u6263\u6210\u529f\uff0c\u5bf9\u5e94\u4fdd\u8bc1\u91d1\u5355\u636e\u5df2\u5b8c\u6210\u5b58\u51fa\u3002", (String)"SuretyRepayListPlugin_0", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void suretyRepay() {
        DynamicObject bizEntity = this.getBizEntity();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("fbd_suretyentry");
        parameter.getCustomParams().put("srcId", this.getSrcId());
        parameter.getCustomParams().put("srcEntity", this.getEntityId());
        parameter.getCustomParams().put("bizId", this.getCurrId());
        long arrivalCurrencyId = bizEntity.getLong("arrivalcurrency");
        if (EmptyUtil.isNoEmpty((Long)arrivalCurrencyId)) {
            parameter.getCustomParams().put("srcCurrencyId", arrivalCurrencyId);
        }
        parameter.getCustomParams().put("todoamount", bizEntity.getBigDecimal("arrivalamount"));
        parameter.getCustomParams().put("bizno", bizEntity.getString("arrivalno"));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CLOSE_BACK_KEY_SURETY_REPAY"));
        this.getView().showForm(parameter);
    }

    protected Long getSrcId() {
        DynamicObject bizBill = QueryServiceHelper.queryOne((String)this.getEntityId(), (String)"lettercredit", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getCurrId())});
        return bizBill.getLong("lettercredit");
    }

    private List<Long> getSrcIds() {
        DynamicObjectCollection suretyRelease = QueryServiceHelper.query((String)this.getEntityId(), (String)"lettercredit", (QFilter[])new QFilter[]{new QFilter("id", "in", this.getSelectedIdList())});
        return suretyRelease.stream().map(d -> d.getLong("lettercredit")).collect(Collectors.toList());
    }

    private DynamicObject getBizEntity() {
        return QueryServiceHelper.queryOne((String)this.getEntityId(), (String)BIZ_BILL_PROPS, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getCurrId())});
    }

    private Long getCurrId() {
        return this.getSelectedId();
    }

    private String getEntityId() {
        BillList billList = (BillList)this.getControl("billlistap");
        return billList.getEntityId();
    }
}

