/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.list.preint;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.preint.TmcIntBillListParam;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractTmcIntBillBatchEdit
extends AbstractFormPlugin
implements HyperLinkClickListener {
    protected static final String CLOSE_BAKE_KEY_FILTER = "CLOSE_BAKE_KEY_FILTER";

    protected abstract TmcIntBillListParam getIntBillListParam();

    protected void customAddNewNavForm(FormShowParameter showParameter) {
    }

    private void openAddNewNavigateForm(FormShowParameter showParameter) {
        Map customParams = showParameter.getCustomParams();
        customParams.put("entity", this.getView().getEntityId());
        customParams.put("formid", this.getView().getEntityId());
        showParameter.setFormId(this.getIntBillListParam().getNavAddNewFormId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE_BAKE_KEY_FILTER));
        this.customAddNewNavForm(showParameter);
        this.getView().showForm(showParameter);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "addentryloans": {
                args.setCancel(true);
                this.openAddNewNavigateForm(this.initParams());
                break;
            }
        }
    }

    private FormShowParameter initParams() {
        HashMap<String, Object> initParams = new HashMap<String, Object>();
        FormShowParameter showParameter = new FormShowParameter();
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        List loanIds = entrys.stream().map(dny -> dny.getLong("loanbillid")).collect(Collectors.toList());
        showParameter.getCustomParams().put("loanIds", loanIds);
        initParams.put("bizdate", this.getModel().getValue("bizdate"));
        HashSet<String> orgIds = new HashSet<String>(entrys.size());
        HashSet<String> currenyIds = new HashSet<String>(entrys.size());
        for (DynamicObject dyn : entrys) {
            orgIds.add(dyn.getDynamicObject("company").getPkValue().toString());
            currenyIds.add(dyn.getDynamicObject("currency").getPkValue().toString());
        }
        initParams.put("orgs", orgIds);
        initParams.put("currencys", currenyIds);
        showParameter.getCustomParams().put("initParams", initParams);
        return showParameter;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
    }

    public void afterCreateNewData(EventObject e) {
        Map<?, ?> navParam = this.getNavParam();
        if (EmptyUtil.isNoEmpty(navParam)) {
            Date bizDate = DateUtils.stringToDate((String)((String)navParam.get("bizdate")), (String)"yyyy-MM-dd");
            this.getModel().setValue("bizdate", (Object)bizDate);
        }
        this.loadIntDetail();
        DynamicObject permOrg = TmcOrgDataHelper.getCurrentAuthPermOrg((String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getEntityId(), (String)"47150e89000000ac", (long)RequestContext.get().getOrgId());
        if (EmptyUtil.isNoEmpty((DynamicObject)permOrg)) {
            this.getModel().setValue("org", permOrg.getPkValue());
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (StringUtils.equals((CharSequence)CLOSE_BAKE_KEY_FILTER, (CharSequence)evt.getActionId()) && null != evt.getReturnData()) {
            Map navparam = (Map)evt.getReturnData();
            this.addNewEntry(navparam.get("calcIntResult").toString());
        }
    }

    private Map<?, ?> getNavParam() {
        Map param = this.getView().getFormShowParameter().getCustomParams();
        Map navParam = (Map)SerializationUtils.fromJsonString((String)param.get("navparam").toString(), Map.class);
        return navParam;
    }

    protected String getParentFormId() {
        Map param = this.getView().getFormShowParameter().getCustomParams();
        Map navParam = (Map)SerializationUtils.fromJsonString((String)param.get("navparam").toString(), Map.class);
        Object formid = navParam.get("formid");
        return EmptyUtil.isNoEmpty(formid) ? formid.toString() : "";
    }

    protected abstract void loadIntDetail();

    protected abstract void addNewEntry(String var1);

    protected abstract String getEntityName();
}

