/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.list.preint;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;
import kd.tmc.fbp.formplugin.list.preint.TmcIntBillListParam;

public abstract class AbstractTmcIntBillBatchList
extends AbstractTmcListPlugin {
    private static final String OP_NEW = "new";
    private static final String OP_TRACKUP = "trackup";
    private static final String OP_TRACKDOWN = "trackdown";
    protected static final String CLOSE_BAKE_KEY_FILTER = "CLOSE_BAKE_KEY_FILTER";
    protected static final String CLOSE_BAKE_KEY_EXIST = "CLOSE_BAKE_KEY_EXIST";
    private static final String PARAM_ISSHOWTOOLBARAP = "isshowtoolbarap";

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        ListView source = (ListView)e.getSource();
        BillShowParameter billShowParameter = e.getParameter();
        billShowParameter.setFormId(source.getBillFormId());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs eventArgs) {
        String operateKey;
        super.beforeDoOperation(eventArgs);
        AbstractOperate operate = (AbstractOperate)eventArgs.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "new": {
                eventArgs.setCancel(true);
                this.openAddNewNavigateForm();
                break;
            }
            case "trackup": {
                eventArgs.setCancel(true);
                this.showTrackView(this.getTrackUpEntityIds(this.getSelectedBatchBills(eventArgs)), this.getIntBillListParam().getTrackUpEntityName());
                break;
            }
            case "trackdown": {
                eventArgs.setCancel(true);
                this.showTrackView(this.getTrackDownEntityIds(this.getSelectedBatchBills(eventArgs)), this.getIntBillListParam().getTrackDownEntityName());
                break;
            }
        }
    }

    private DynamicObject[] getSelectedBatchBills(BeforeDoOperationEventArgs eventArgs) {
        ListSelectedRowCollection listSelectedData = eventArgs.getListSelectedData();
        if (CollectionUtils.isEmpty((Collection)listSelectedData)) {
            return null;
        }
        Object[] batchBillIds = listSelectedData.getPrimaryKeyValues();
        return TmcDataServiceHelper.load((Object[])batchBillIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getEntityId()));
    }

    protected abstract TmcIntBillListParam getIntBillListParam();

    protected void customAddNewNavForm(FormShowParameter showParameter) {
    }

    private void openAddNewNavigateForm() {
        FormShowParameter showParameter = new FormShowParameter();
        Map customParams = showParameter.getCustomParams();
        customParams.put("entity", this.getEntityId());
        customParams.put("formid", this.getFormId());
        showParameter.setFormId(this.getIntBillListParam().getNavAddNewFormId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE_BAKE_KEY_FILTER));
        this.customAddNewNavForm(showParameter);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        switch (evt.getActionId()) {
            case "CLOSE_BAKE_KEY_FILTER": {
                if (evt.getReturnData() == null) break;
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setFormId(this.getFormId());
                showParameter.setStatus(OperationStatus.EDIT);
                showParameter.setCustomParam("navparam", evt.getReturnData());
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE_BAKE_KEY_EXIST));
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "CLOSE_BAKE_KEY_EXIST": {
                this.getBillList().refresh();
                break;
            }
        }
    }

    protected void showTrackView(List<Long> pkIds, String trackViewFormId) {
        IFormView view = this.getView();
        if (pkIds.size() == 1) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId((Object)pkIds.get(0));
            showParameter.setFormId(trackViewFormId);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam(PARAM_ISSHOWTOOLBARAP, (Object)"no");
            view.showForm((FormShowParameter)showParameter);
        } else {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setIsolationOrg(false);
            showParameter.setBillFormId(trackViewFormId);
            showParameter.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter("id", "in", pkIds)));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam(PARAM_ISSHOWTOOLBARAP, (Object)"yes");
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            view.showForm((FormShowParameter)showParameter);
        }
    }

    protected abstract List<Long> getTrackUpEntityIds(DynamicObject[] var1);

    protected abstract List<Long> getTrackDownEntityIds(DynamicObject[] var1);

    private BillList getBillList() {
        return (BillList)this.getControl("billlistap");
    }

    protected final String getFormId() {
        return this.getBillList().getBillFormId();
    }

    protected final String getEntityId() {
        return this.getBillList().getEntityId();
    }
}

