/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.tool;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TmcMetaDataToolPlugin
extends AbstractFormPlugin {
    private static final String TEMPLATEID = "templateid";
    private static final String APPID = "appid";
    private static final String CHECK_RESULT = "checkresult";
    private static final String ISSHOW_EXTEND = "isshowextend";
    private static final String ISSHOW_NOEXTEND = "isshownoextend";
    private static final String GET_RESULIT = "getresulit";
    private static final String METADATA = "metadata";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("check".equals(operateKey)) {
            DynamicObject template = (DynamicObject)this.getModel().getValue(TEMPLATEID);
            if (EmptyUtil.isEmpty((DynamicObject)template)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9700\u8981\u68c0\u67e5\u7ee7\u627f\u7684\u6a21\u7248\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TmcMetaDataToolPlugin_0", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.getModel().setValue(CHECK_RESULT, null);
            this.getModel().setValue(CHECK_RESULT, (Object)this.checkMetaDataExtend(template));
        } else if ("getfields".equals(operateKey)) {
            DynamicObjectCollection metaDatas = (DynamicObjectCollection)this.getModel().getValue(METADATA);
            if (EmptyUtil.isEmpty((DynamicObjectCollection)metaDatas)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9700\u8981\u83b7\u53d6\u5b57\u6bb5\u7684\u5143\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TmcMetaDataToolPlugin_1", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.getModel().setValue(GET_RESULIT, null);
            this.getModel().setValue(GET_RESULIT, (Object)this.getMetaDataFields(metaDatas));
        }
    }

    private String getMetaDataFields(DynamicObjectCollection metadatas) {
        List metaDataKeys = metadatas.stream().map(s -> s.getString("fbasedataid.number")).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        for (String metaDataKey : metaDataKeys) {
            sb.append("--------------------------------").append(metaDataKey).append("--------------------------------\n");
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)metaDataKey);
            Map allFields = dataEntityType.getAllFields();
            sb.append(String.join((CharSequence)"\n", allFields.keySet()));
            sb.append("\n");
        }
        return sb.toString();
    }

    private String checkMetaDataExtend(DynamicObject template) {
        Set formMetaDataIds;
        String modeltype = template.getString("modeltype");
        String templateId = template.getString("id");
        DynamicObjectCollection appidCollection = (DynamicObjectCollection)this.getModel().getValue(APPID);
        Map<String, String> appIdNumberMap = EmptyUtil.isNoEmpty((DynamicObjectCollection)appidCollection) ? appidCollection.stream().collect(Collectors.toMap(k -> k.getString("fbasedataid.id"), v -> v.getString("fbasedataid.number"))) : QueryServiceHelper.query((String)"bos_devp_bizapplist", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("bizcloud", "=", (Object)"/LOQO9724P0L")}).stream().collect(Collectors.toMap(k -> k.getString("id"), v -> v.getString("number")));
        DynamicObjectCollection formMetaDatas = QueryServiceHelper.query((String)"bos_formmeta", (String)"id,number,name,inheritpath,bizappid", (QFilter[])new QFilter[]{new QFilter("modeltype", "=", (Object)modeltype).and("bizappid", "in", appIdNumberMap.keySet())});
        Map<String, String> idNumberMap = formMetaDatas.stream().collect(Collectors.toMap(k -> k.getString("id"), v -> v.getString("number")));
        Map<String, String> idNameMap = formMetaDatas.stream().collect(Collectors.toMap(k -> k.getString("id"), v -> v.getString("name")));
        boolean isShowExtend = (Boolean)this.getModel().getValue(ISSHOW_EXTEND);
        boolean isShowNoExtend = (Boolean)this.getModel().getValue(ISSHOW_NOEXTEND);
        StringBuilder sb = new StringBuilder();
        if (isShowExtend) {
            Map extendMap = formMetaDatas.stream().filter(s -> s.getString("inheritpath").contains(templateId)).collect(Collectors.groupingBy(s -> s.getString("bizappid"), Collectors.mapping(s -> s.getString("id"), Collectors.toSet())));
            sb.append("-----------------------------------------------extend---------------------------------------------\n");
            for (Map.Entry entry : extendMap.entrySet()) {
                sb.append(appIdNumberMap.get(entry.getKey())).append(":\n");
                formMetaDataIds = entry.getValue();
                for (String formMetaDataId : formMetaDataIds) {
                    sb.append(idNameMap.get(formMetaDataId)).append(idNumberMap.get(formMetaDataId)).append("\n");
                }
            }
        }
        if (isShowNoExtend) {
            Map noExtendMap = formMetaDatas.stream().filter(s -> !s.getString("inheritpath").contains(templateId)).collect(Collectors.groupingBy(s -> s.getString("bizappid"), Collectors.mapping(s -> s.getString("id"), Collectors.toSet())));
            sb.append("-----------------------------------------------noextend-------------------------------------------\n");
            for (Map.Entry entry : noExtendMap.entrySet()) {
                sb.append(appIdNumberMap.get(entry.getKey())).append(":\n");
                formMetaDataIds = entry.getValue();
                for (String formMetaDataId : formMetaDataIds) {
                    sb.append(idNameMap.get(formMetaDataId)).append(idNumberMap.get(formMetaDataId)).append("\n");
                }
            }
        }
        return sb.toString();
    }
}

