/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.tool;

import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.formplugin.tool.ITmcToolExecute;
import kd.tmc.fbp.formplugin.tool.TmcToolTabFactory;

public class TmcPracticalToolPlugin
extends AbstractFormPlugin
implements ItemClickListener,
ClickListener {
    private static final Log logger = LogFactory.getLog(TmcPracticalToolPlugin.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (key = op.getOperateKey()) {
            case "execute": 
            case "download": {
                this.beforeExecute(args);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (key = op.getOperateKey()) {
            case "execute": 
            case "download": 
            case "propreplace": {
                this.execute(args);
                break;
            }
            case "importoperation": {
                this.showImportPage();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        Tab tabap = (Tab)this.getView().getControl("tab");
        String currentTab = tabap.getCurrentTab();
        ITmcToolExecute tmcToolImpl = new TmcToolTabFactory().getTmcToolImpl(currentTab);
        try {
            tmcToolImpl.propertyChanged(this.getView(), args);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private void beforeExecute(BeforeDoOperationEventArgs args) {
        Tab tabap = (Tab)this.getView().getControl("tab");
        String currentTab = tabap.getCurrentTab();
        ITmcToolExecute tmcToolImpl = new TmcToolTabFactory().getTmcToolImpl(currentTab);
        try {
            tmcToolImpl.volidate(this.getView(), args);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private void execute(AfterDoOperationEventArgs args) {
        Tab tabap = (Tab)this.getView().getControl("tab");
        String currentTab = tabap.getCurrentTab();
        ITmcToolExecute tmcToolImpl = new TmcToolTabFactory().getTmcToolImpl(currentTab);
        try {
            if (tmcToolImpl != null) {
                tmcToolImpl.execute(this.getView(), args);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(tabap + ":An error is occurred  " + e.getMessage());
        }
    }

    private void showImportPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getCustomParams().put("BillFormId", "kdtest_pelog");
        showParameter.getCustomParams().put("ImportPlugin", "kd.tmc.fbp.formplugin.tool.WriteOperationLogImpl");
        showParameter.setFormId("bos_importstart");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }
}

