/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.tool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.ListUtils;

public class TmcVoucherUpgradPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(TmcVoucherUpgradPlugin.class);
    private static List<String> cfmList = Arrays.asList("cim_invest_loanbill", "cim_invest_repaybill", "cim_invest_interestbill", "cim_preinterestbill");
    private static List<String> ifmList = Arrays.asList("ifm_loanbill", "ifm_repaymentbill", "ifm_interestbill", "ifm_preinterestbill", "ifm_deposit", "ifm_release", "ifm_notice_release", "ifm_depositpreint", "ifm_dptrevenue", "ifm_notice_deposit");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        DynamicObject billentity = (DynamicObject)this.getModel().getValue("billentity");
        if ("btnok".equals(key) && EmptyUtil.isNoEmpty((DynamicObject)billentity)) {
            this.update(billentity);
        }
    }

    private void update(DynamicObject billentity) {
        try {
            String entity = billentity.getString("number");
            String tableName = billentity.getString("tablename");
            String queryEntitySql = "select fid from " + tableName + " where fbillstatus = 'C' and " + this.getUpdateField(entity) + " = '0'";
            if ("ifm_transhandlebill".equals(entity)) {
                tableName = tableName + "_e";
                queryEntitySql = "select fid from " + tableName + " where " + this.getUpdateField(entity) + " = '0'";
            }
            DataSet entityDS = DB.queryDataSet((String)"queryEntity", (DBRoute)DBRouteConst.TMC, (String)queryEntitySql);
            ArrayList<Long> idList = new ArrayList<Long>(16);
            for (Row row : entityDS) {
                idList.add(row.getLong("fid"));
            }
            List lists = ListUtils.splitList(idList, (long)1000L);
            HashSet<Long> set = new HashSet<Long>(2);
            for (List list : lists) {
                this.batchUpdate(entity, tableName, list, set);
            }
            if (set.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5347\u7ea7\u7684\u6570\u636e\u3002", (String)"TmcVoucherUpgradPlugin_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f\u3002", (String)"TmcVoucherUpgradPlugin_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            logger.error(String.format("updateVoucher error, msg:{%s}", e.getMessage()), (Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u6ca1\u6709\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u80fd\u5347\u7ea7\u3002", (String)"TmcVoucherUpgradPlugin_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
        }
    }

    private void batchUpdate(String entity, String tableName, List<Long> idList, Set<Long> set) {
        String querySql = "select fsourcebillid from t_ai_daptracker where fsourcebillid in " + idList + " and fbilltype = '" + entity + "'";
        querySql = querySql.replace('[', '(').replace(']', ')');
        DataSet dapTrackerDS = DB.queryDataSet((String)"queryDAPtracker", (DBRoute)new DBRoute("fi"), (String)querySql);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
        for (Row row : dapTrackerDS) {
            paramList.add(new Object[]{row.getLong("fsourcebillid")});
        }
        if (paramList.size() > 0) {
            String updateSql = "update " + tableName + " set " + this.getUpdateField(entity) + " = '1' where fid = ?";
            DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)updateSql, paramList);
            set.add(1L);
        }
    }

    private String getUpdateField(String entity) {
        if (cfmList.contains(entity)) {
            return "fiscfmvoucher";
        }
        if (ifmList.contains(entity)) {
            return "fisifmvoucher";
        }
        return "fisvoucher";
    }
}

