/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.tree;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.CreateTreeListViewEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.property.TmcTreeNodeProp;
import kd.tmc.fbp.common.property.TmcTreeNodeRefProp;
import kd.tmc.fbp.common.property.TmcTreeNodeTypeProp;
import kd.tmc.fbp.common.util.EmptyUtil;

public abstract class AbstractTmcTreeList
extends StandardTreeListPlugin {
    public static final int MAX_LEVEL = 99;

    public void initialize() {
        super.initialize();
        this.checkNodeType();
    }

    public void createTreeListView(CreateTreeListViewEvent e) {
        super.createTreeListView(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap11", "flexpanel_treebtn"});
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        TreeNode currNode = this.getNodeById(e.getNodeId());
        TmcTreeNodeProp TmcTreeNodeProp2 = new TmcTreeNodeProp(currNode, this.getTreeModel().getRoot(), this.getTreeNodeTypeList());
        if (currNode.getChildren() != null && !currNode.getChildren().isEmpty()) {
            e.setChildNodes(currNode.getChildren());
        } else if (TmcTreeNodeTypeProp.LeafMode.LEAF == TmcTreeNodeProp2.getLeafMode()) {
            e.setChildNodes(null);
        } else {
            List<TmcTreeNodeRefProp> list = this.loadTreeNodeList(TmcTreeNodeProp2);
            List<TreeNode> childTreeNodeList = this.transferTreeNodeList(TmcTreeNodeProp2, list);
            e.setChildNodes(childTreeNodeList);
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        this.treeListView.getTreeView().queryTreeNodeChildren(e.getParentNodeId().toString(), nodeId);
        this.refreshBillList();
        super.treeNodeClick(e);
    }

    public void expendTreeNode(TreeNodeEvent e) {
        super.expendTreeNode(e);
        String nodeId = e.getNodeId().toString();
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode currNode = root.getTreeNode(nodeId, 99);
        currNode.setIsOpened(true);
        currNode.setExpend(true);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        e.setCancel(true);
        TreeNode treeNode = this.getNodeById(e.getNodeId());
        TmcTreeNodeProp nodeModel = new TmcTreeNodeProp(treeNode, this.getTreeModel().getRoot(), this.getTreeNodeTypeList());
        QFilter qFilter = this.getBillListFilter(nodeModel);
        e.addQFilter(qFilter);
    }

    protected abstract List<TmcTreeNodeTypeProp> getTreeNodeTypeList();

    protected abstract List<TmcTreeNodeRefProp> loadTreeNodeList(TmcTreeNodeProp var1);

    protected abstract QFilter getBillListFilter(TmcTreeNodeProp var1);

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.getEntryState().setCurrentPageIndex(Integer.valueOf(0));
        billList.refresh();
    }

    private List<TreeNode> transferTreeNodeList(TmcTreeNodeProp pNodeModel, List<TmcTreeNodeRefProp> childList) {
        if (CollectionUtils.isEmpty(childList)) {
            return null;
        }
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(childList.size());
        for (TmcTreeNodeRefProp treeNodeRef : childList) {
            boolean isLeaf;
            TmcTreeNodeTypeProp childNodeType = treeNodeRef.getNodeType();
            TreeNode node = new TreeNode();
            String nodeID = pNodeModel.generateChildNodeId(treeNodeRef);
            node.setText(treeNodeRef.getNodeName());
            node.setParentid(pNodeModel.getNodeId());
            node.setId(nodeID);
            boolean bl = isLeaf = childNodeType.getLeafMode() == TmcTreeNodeTypeProp.LeafMode.LEAF || this.getNodeIsLeaf(treeNodeRef);
            if (!isLeaf) {
                node.setChildren(new ArrayList());
            }
            nodeList.add(node);
        }
        return nodeList;
    }

    protected TmcTreeNodeProp getCurrentNodeModel() {
        TreeNode currNode = this.getCurrentNode();
        TmcTreeNodeProp TmcTreeNodeProp2 = new TmcTreeNodeProp(currNode, this.getTreeModel().getRoot(), this.getTreeNodeTypeList());
        return TmcTreeNodeProp2;
    }

    protected TreeNode getCurrentNode() {
        TreeNode currNode = this.getNodeById(this.getTreeModel().getCurrentNodeId());
        return currNode;
    }

    protected TreeNode getNodeById(Object nodeId) {
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode currNode = root.getTreeNode((String)nodeId, 99);
        return currNode;
    }

    protected boolean getNodeIsLeaf(TmcTreeNodeRefProp nodeRefModel) {
        return false;
    }

    private void checkNodeType() {
        List<TmcTreeNodeTypeProp> treeNodeTypeList = this.getTreeNodeTypeList();
        if (treeNodeTypeList == null) {
            throw new KDException(BosErrorCode.beanNotOfRequiredType, new Object[]{ResManager.loadKDString((String)"\u8282\u70b9\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractTmcTreeList_0", (String)"tmc-fbp-formplugin", (Object[])new Object[0])});
        }
        ArrayList<String> nameList = new ArrayList<String>(treeNodeTypeList.size());
        for (TmcTreeNodeTypeProp typeModel : treeNodeTypeList) {
            String typeName = typeModel.getName();
            if (EmptyUtil.isEmpty((String)typeName)) {
                throw new KDException(BosErrorCode.beanNotOfRequiredType, new Object[]{ResManager.loadKDString((String)"\u8282\u70b9\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractTmcTreeList_1", (String)"tmc-fbp-formplugin", (Object[])new Object[0])});
            }
            if (typeName.contains(String.valueOf('#')) || typeName.contains(String.valueOf('/'))) {
                throw new KDException(BosErrorCode.beanNotOfRequiredType, new Object[]{ResManager.loadKDString((String)"\u8282\u70b9\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26:%1$s\u6216%2$s\u3002", (String)"AbstractTmcTreeList_2", (String)"tmc-fbp-formplugin", (Object[])new Object[0]), Character.valueOf('/'), Character.valueOf('#')});
            }
            if (nameList.contains(typeName)) {
                throw new KDException(BosErrorCode.beanNotOfRequiredType, new Object[]{ResManager.loadKDString((String)"\u8282\u70b9\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u91cd\u590d\u3002", (String)"AbstractTmcTreeList_3", (String)"tmc-fbp-formplugin", (Object[])new Object[0])});
            }
            if (typeModel.getParent() == null) {
                throw new KDException(BosErrorCode.beanNotOfRequiredType, new Object[]{ResManager.loadKDString((String)"\u7236\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a, \u5982\u679c\u4e3a\u4e00\u7ea7\u8282\u70b9, \u8bf7\u6307\u5b9a\u7236\u8282\u70b9\u4e3a:%s#ROOT\u3002", (String)"AbstractTmcTreeList_4", (String)"tmc-fbp-formplugin", (Object[])new Object[0]), TmcTreeNodeTypeProp.class.getName()});
            }
            nameList.add(typeName);
        }
    }
}

