/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractBatchBillBotpCreateService
extends AbstractTmcBizOppService {
    @Override
    public List<String> getSelector() {
        List<String> selector = super.getSelector();
        selector.add(this.getEntryName());
        selector.add(this.getUppBillField());
        selector.add(this.getDownBillField());
        return selector;
    }

    @Override
    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    @Override
    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        this.createDownBotp(dataEntities);
        this.createUpperBotp(dataEntities);
    }

    private void createUpperBotp(DynamicObject[] dataEntities) {
        ArrayList<Pair<Long, Long>> srcTarIds = new ArrayList<Pair<Long, Long>>();
        for (DynamicObject dataEntity : dataEntities) {
            Long pkValue = dataEntity.getLong("id");
            DynamicObjectCollection entries = dataEntity.getDynamicObjectCollection(this.getEntryName());
            entries.stream().map(v -> v.getLong(this.getUppBillField())).filter(EmptyUtil::isNoEmpty).map(v -> Pair.of((Object)v, (Object)pkValue)).forEach(srcTarIds::add);
        }
        this.batchSaveRelation(dataEntities[0], srcTarIds, "upper");
    }

    private void createDownBotp(DynamicObject[] dataEntities) {
        ArrayList<Pair<Long, Long>> srcTarIds = new ArrayList<Pair<Long, Long>>();
        for (DynamicObject dataEntity : dataEntities) {
            Long pkValue = dataEntity.getLong("id");
            DynamicObjectCollection entries = dataEntity.getDynamicObjectCollection(this.getEntryName());
            entries.stream().map(v -> v.getLong(this.getDownBillField())).filter(EmptyUtil::isNoEmpty).map(v -> Pair.of((Object)pkValue, (Object)v)).forEach(srcTarIds::add);
        }
        this.batchSaveRelation(dataEntities[0], srcTarIds, "down");
    }

    protected boolean isUpper(String relateType) {
        return StringUtils.equals((CharSequence)relateType, (CharSequence)"upper");
    }

    private void batchSaveRelation(DynamicObject data, List<Pair<Long, Long>> srcTarIds, String relateType) {
        Pair<String, String> botpPair = this.getBotpPair(data, relateType);
        if (this.deDupAndValidate(srcTarIds, botpPair, relateType)) {
            TmcBotpHelper.batchSaveRelation((String)((String)botpPair.getLeft()), (String)((String)botpPair.getRight()), srcTarIds, (String)relateType);
        }
    }

    private boolean deDupAndValidate(List<Pair<Long, Long>> srcTarIds, Pair<String, String> botpPair, String relateType) {
        Map pairMap;
        Set batchBillIds;
        if (CollectionUtils.isEmpty(srcTarIds) || null == botpPair) {
            return false;
        }
        ArrayList<Long> otherSideIds = new ArrayList<Long>();
        if (this.isUpper(relateType)) {
            batchBillIds = srcTarIds.stream().map(Pair::getRight).collect(Collectors.toSet());
            for (Long batchBillId : batchBillIds) {
                Long[] sourceBillIds = TmcBotpHelper.getSourceBillIds((String)((String)botpPair.getRight()), (Object)batchBillId, (String)((String)botpPair.getLeft()));
                if (null == sourceBillIds || sourceBillIds.length <= 0) continue;
                otherSideIds.addAll(Arrays.asList(sourceBillIds));
            }
            pairMap = srcTarIds.stream().collect(Collectors.toMap(Pair::getLeft, Function.identity()));
        } else {
            batchBillIds = srcTarIds.stream().map(Pair::getLeft).collect(Collectors.toSet());
            for (Long batchBillId : batchBillIds) {
                Long[] targetBillIds = TmcBotpHelper.getTargetBillIds((String)((String)botpPair.getLeft()), (Object)batchBillId, (String)((String)botpPair.getRight()));
                if (null == targetBillIds || targetBillIds.length <= 0) continue;
                otherSideIds.addAll(Arrays.asList(targetBillIds));
            }
            pairMap = srcTarIds.stream().collect(Collectors.toMap(Pair::getRight, Function.identity()));
        }
        if (EmptyUtil.isEmpty(otherSideIds)) {
            return true;
        }
        for (Map.Entry entry : pairMap.entrySet()) {
            if (!otherSideIds.contains(entry.getKey())) continue;
            srcTarIds.remove(entry.getValue());
        }
        return !CollectionUtils.isEmpty(srcTarIds);
    }

    public abstract String getEntryName();

    public abstract String getUppBillField();

    public abstract String getDownBillField();

    public abstract Pair<String, String> getBotpPair(DynamicObject var1, String var2);
}

