/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.feedetail;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.property.AmountProp;
import kd.bos.exception.KDException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sdk.tmc.fbp.extpoint.IFeeDetailSaveAndSubmitAddFields;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FeeDetailSrcBillStatusEnum;
import kd.tmc.fbp.common.enums.FeeSourceEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.ShareTypeEnum;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.property.FeeDetailEntryProp;
import kd.tmc.fbp.common.resource.TmcBizResource;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FeeDetailSaveOrSubmitOpService
extends AbstractTmcBizOppService {
    @Override
    public List<String> getSelector() {
        List<String> sic = super.getSelector();
        sic.add("billno");
        sic.add("id");
        sic.add("feedetail");
        sic.add("lettercredit");
        sic.add("creditno");
        sic.add("arrivalno");
        return sic;
    }

    @Override
    public void process(DynamicObject[] dynamicObjects) throws KDException {
        String formId = TmcBusinessBaseHelper.getBillFormId((String)((String)this.operationVariable.get("FeeDetailEditPageSaveOp")));
        if (EmptyUtil.isNoEmpty((String)formId)) {
            DynamicObject info = dynamicObjects[0];
            DynamicObjectCollection feeDetailEntrys = info.getDynamicObjectCollection("feedetail");
            if ("true".equals(this.operationVariable.get("byInit")) && EmptyUtil.isNoEmpty((DynamicObjectCollection)feeDetailEntrys)) {
                this.saveEntryData2FeeBill(info, new ArrayList<DynamicObject>((Collection<DynamicObject>)feeDetailEntrys), formId, new DynamicObjectCollection());
            } else {
                QFilter feeLinkFilter = new QFilter("entry.srcbillid", "=", (Object)info.getLong("id"));
                feeLinkFilter.and(new QFilter("feesource", "=", (Object)FeeSourceEnum.LINKGEN.getValue()));
                DynamicObjectCollection feeBillDBs = QueryServiceHelper.query((String)"cfm_feebill", (String)"id,billno,org,creator,modifier,modifytime,createtime", (QFilter[])new QFilter[]{feeLinkFilter});
                DeleteServiceHelper.delete((String)"cfm_feebill", (QFilter[])new QFilter[]{feeLinkFilter});
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)feeDetailEntrys)) {
                    List<DynamicObject> needAddFeeEntrys;
                    List<DynamicObject> needUpdateFeeEntrys = feeDetailEntrys.stream().filter(o -> FeeSourceEnum.LINKGEN.getValue().equals(o.getString("feesource")) && o.getString("feeproducttype").equals(ProductTypeEnum.getEnumByFormId((String)formId).getValue()) && EmptyUtil.isNoEmpty((Long)o.getLong("feebillentryid")) && (EmptyUtil.isEmpty((String)o.getString("loanbillno")) || this.isLoanBill(formId))).collect(Collectors.toList());
                    if (EmptyUtil.isNoEmpty(needUpdateFeeEntrys)) {
                        this.saveEntryData2FeeBill(info, needUpdateFeeEntrys, formId, feeBillDBs);
                    }
                    if (EmptyUtil.isNoEmpty(needAddFeeEntrys = feeDetailEntrys.stream().filter(o -> FeeSourceEnum.LINKGEN.getValue().equals(o.getString("feesource")) && EmptyUtil.isEmpty((Long)o.getLong("feebillentryid")) && (EmptyUtil.isEmpty((String)o.getString("loanbillno")) || this.isLoanBill(formId))).collect(Collectors.toList()))) {
                        this.saveEntryData2FeeBill(info, needAddFeeEntrys, formId, new DynamicObjectCollection());
                    }
                }
            }
            String billStatus = this.getColumn(formId, info, "status");
            if (FeeDetailEntryProp.FEENUMER_LIST.contains(formId) && (BillStatusEnum.SAVE.getValue().equals(billStatus) || BillStatusEnum.SUBMIT.getValue().equals(billStatus))) {
                ArrayList<DynamicObject> needSaveFeeBillLists = new ArrayList<DynamicObject>();
                this.deletEntryFeeDetail(info);
                for (DynamicObject feeDetail : feeDetailEntrys) {
                    String feeNumber = feeDetail.getString("feenumber");
                    if (!EmptyUtil.isNoEmpty((String)feeNumber)) continue;
                    long feeBillID = feeDetail.getLong("feebillid");
                    DynamicObject feeBill = TmcDataServiceHelper.loadSingle((Object)feeBillID, (String)"cfm_feebill");
                    feeBill.set("amountrate", (Object)feeDetail.getBigDecimal("feerate"));
                    DynamicObjectCollection entrys = feeBill.getDynamicObjectCollection("entry");
                    DynamicObject entry = entrys.addNew();
                    ProductTypeEnum TypeEnum = ProductTypeEnum.getEnumByFormId((String)formId);
                    entry.set("srcbillno", (Object)this.getColumn(formId, info, "number"));
                    entry.set("srcbillid", (Object)info.getLong("id"));
                    BigDecimal payAmt = feeBill.getBigDecimal("payamt");
                    BigDecimal detailAmt = feeDetail.getBigDecimal("feeamt");
                    BigDecimal rowRatio = detailAmt.divide(payAmt, 6, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
                    entry.set("feeratio", (Object)rowRatio);
                    entry.set("feedetailamt", (Object)feeDetail.getBigDecimal("feeamt"));
                    entry.set("remark", (Object)feeDetail.getString("feeremark"));
                    entry.set("srcstatus", (Object)(billStatus.equals(BillStatusEnum.AUDIT.getValue()) ? FeeDetailSrcBillStatusEnum.AUDIT.getValue() : FeeDetailSrcBillStatusEnum.NOAUDIT.getValue()));
                    entry.set("excrate", (Object)feeDetail.getBigDecimal("excrate"));
                    entry.set("producttype", (Object)TypeEnum.getId());
                    String appSource = this.getAppSource(TypeEnum.getFormId());
                    if ("lc".equals(appSource)) {
                        this.lcBizDeal(info, entry);
                    }
                    if (this.getOperationVariable().containsKey("confirm")) {
                        this.lcArrivalConfirm(payAmt, feeBill, entrys);
                    }
                    this.dealFeeDetailSaveFieldsSecondDev(feeBill, entry, feeDetail);
                    needSaveFeeBillLists.add(feeBill);
                }
                if (EmptyUtil.isNoEmpty(needSaveFeeBillLists)) {
                    SaveServiceHelper.save((DynamicObject[])needSaveFeeBillLists.toArray(new DynamicObject[0]));
                }
            }
        }
    }

    private String getColumn(String formId, DynamicObject info, String baseColumn) {
        if ("cfm_creditlimit".equals(formId)) {
            return info.getString(baseColumn);
        }
        if ("number".equals(baseColumn)) {
            return info.getString("billno");
        }
        if ("status".equals(baseColumn)) {
            return info.getString("billstatus");
        }
        return "";
    }

    private void lcArrivalConfirm(BigDecimal payAmt, DynamicObject feeBill, DynamicObjectCollection entrys) {
        BigDecimal allFeeAmt = entrys.stream().filter(row -> !FeeDetailSrcBillStatusEnum.NOAUDIT.getValue().equals(row.getString("srcstatus"))).map(row -> row.getBigDecimal("feedetailamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        feeBill.set("enpayamt", (Object)payAmt.subtract(allFeeAmt));
    }

    private void deletEntryFeeDetail(DynamicObject info) {
        long bizBillId = info.getLong("id");
        QFilter qFilter = new QFilter("entry.srcbillid", "=", (Object)bizBillId);
        qFilter.and("entry.srcstatus", "is not null", null);
        qFilter.and("entry.srcstatus", "!=", (Object)"");
        qFilter.and("entry.srcstatus", "!=", (Object)" ");
        DynamicObject[] updateFeeBills = TmcDataServiceHelper.load((String)"cfm_feebill", (String)"id,enpayamt,payamt,entry.srcbillid,entry.srcstatus,entry.feedetailamt", (QFilter[])qFilter.toArray());
        ArrayList<DynamicObject> needSaveFeeBillLists = new ArrayList<DynamicObject>(updateFeeBills.length);
        for (DynamicObject feeBill : updateFeeBills) {
            DynamicObjectCollection entrys = feeBill.getDynamicObjectCollection("entry");
            entrys.removeIf(row -> bizBillId == row.getLong("srcbillid") && EmptyUtil.isNoEmpty((String)row.getString("srcstatus")));
            if (this.getOperationVariable().containsKey("confirm")) {
                BigDecimal payAmt = feeBill.getBigDecimal("payamt");
                this.lcArrivalConfirm(payAmt, feeBill, entrys);
            }
            needSaveFeeBillLists.add(feeBill);
        }
        if (EmptyUtil.isNoEmpty(needSaveFeeBillLists)) {
            SaveServiceHelper.save((DynamicObject[])needSaveFeeBillLists.toArray(new DynamicObject[0]));
        }
    }

    private boolean isLoanBill(String entity) {
        return ProductTypeEnum.LOANBILL_B_L.getEntity().equals(entity) || ProductTypeEnum.LOANBILL_E_L.getEntity().equals(entity) || ProductTypeEnum.LOANBILL_BOND.getEntity().equals(entity);
    }

    private void saveEntryData2FeeBill(DynamicObject info, List<DynamicObject> linkGenFeeEntrys, String formId, DynamicObjectCollection feeBillDBs) {
        Map<Long, Object> idCreatorMap = feeBillDBs.stream().collect(Collectors.toMap(o -> o.getLong("id"), o -> o.get("creator")));
        Map<Long, Object> idModifierMap = feeBillDBs.stream().collect(Collectors.toMap(o -> o.getLong("id"), o -> o.get("modifier")));
        Map<Long, Object> idCreateTimeMap = feeBillDBs.stream().collect(Collectors.toMap(o -> o.getLong("id"), o -> o.get("createtime")));
        Map<Long, Object> idModifyTimeMap = feeBillDBs.stream().collect(Collectors.toMap(o -> o.getLong("id"), o -> o.get("modifytime")));
        ArrayList<DynamicObject> needSaveFeeBillLists = new ArrayList<DynamicObject>(linkGenFeeEntrys.size());
        Long thisOrgId = info.getDynamicObject("org").getLong("id");
        ProductTypeEnum TypeEnum = ProductTypeEnum.getEnumByFormId((String)formId);
        for (DynamicObject linkGenFeeEntry : linkGenFeeEntrys) {
            DynamicObject feeBillDo = BusinessDataServiceHelper.newDynamicObject((String)"cfm_feebill");
            Long feeBillId = linkGenFeeEntry.getLong("feebillid");
            feeBillDo.set("id", (Object)feeBillId);
            feeBillDo.set("org", (Object)("gm_letterofguarantee".equals(formId) || "gm_pledgebill".equals(formId) ? this.getIdByBaseDo(linkGenFeeEntry, "feeorg") : thisOrgId));
            feeBillDo.set("feescheme", (Object)this.getIdByBaseDo(linkGenFeeEntry, "feescheme"));
            feeBillDo.set("feetype", (Object)this.getIdByBaseDo(linkGenFeeEntry, "feetype"));
            feeBillDo.set("paydate", (Object)linkGenFeeEntry.getDate("feepaydate"));
            feeBillDo.set("currency", (Object)this.getIdByBaseDo(linkGenFeeEntry, "feecurrency"));
            feeBillDo.set("payamt", (Object)linkGenFeeEntry.getBigDecimal("feeamt"));
            feeBillDo.set("amountrate", (Object)linkGenFeeEntry.getBigDecimal("feerate"));
            feeBillDo.set("settlementtype", (Object)this.getIdByBaseDo(linkGenFeeEntry, "feesettletype"));
            feeBillDo.set("feeacctbank", (Object)this.getIdByBaseDo(linkGenFeeEntry, "feeacctbank"));
            feeBillDo.set("oppunittype", (Object)linkGenFeeEntry.getString("feeoppunittype"));
            feeBillDo.set("oppunit", (Object)this.getIdByBaseDo(linkGenFeeEntry, "feeoppunit"));
            feeBillDo.set("oppunittext", (Object)linkGenFeeEntry.getString("feeoppunittext"));
            feeBillDo.set("oppacctbank", (Object)linkGenFeeEntry.getString("feeoppacctbank"));
            feeBillDo.set("oppbebank", (Object)this.getIdByBaseDo(linkGenFeeEntry, "feeoppbebank"));
            feeBillDo.set("billstatus", (Object)this.getColumn(formId, info, "status"));
            feeBillDo.set("feesource", (Object)linkGenFeeEntry.getString("feesource"));
            feeBillDo.set("issettle", (Object)linkGenFeeEntry.getBoolean("feeissettle"));
            this.setSysBillDefaultVal(idCreatorMap, idModifierMap, idCreateTimeMap, idModifyTimeMap, feeBillDo, feeBillId);
            DynamicProperty shareTypeProp = linkGenFeeEntry.getDynamicObjectType().getProperty("freesharetype");
            if (shareTypeProp != null) {
                feeBillDo.set("sharetype", (Object)linkGenFeeEntry.getString("freesharetype"));
            } else {
                feeBillDo.set("sharetype", (Object)ShareTypeEnum.NOTSHARE.getValue());
            }
            DynamicObjectCollection entrys = feeBillDo.getDynamicObjectCollection("entry");
            DynamicObject entry = entrys.addNew();
            entry.set("producttype", (Object)TypeEnum.getId());
            entry.set("srcbillno", (Object)this.getColumn(formId, info, "number"));
            String appSource = this.getAppSource(TypeEnum.getFormId());
            feeBillDo.set("appsource", (Object)appSource);
            if ("lc".equals(appSource)) {
                this.lcBizDeal(info, entry);
            }
            entry.set("srcbillid", (Object)info.getLong("id"));
            entry.set("feeratio", (Object)100);
            entry.set("feedetailamt", (Object)linkGenFeeEntry.getBigDecimal("feeamt"));
            entry.set("remark", (Object)linkGenFeeEntry.getString("feeremark"));
            entry.set("id", (Object)linkGenFeeEntry.getLong("feebillentryid"));
            if (linkGenFeeEntry.containsProperty("excrate")) {
                entry.set("excrate", (Object)linkGenFeeEntry.getBigDecimal("excrate"));
            }
            this.dealFeeDetailSaveFieldsSecondDev(feeBillDo, entry, linkGenFeeEntry);
            for (IDataEntityProperty prop : feeBillDo.getDataEntityType().getProperties()) {
                if (!(prop instanceof AmountProp) || feeBillDo.getBigDecimal(prop.getName()).compareTo(Constants.MAX_VALUE) <= 0) continue;
                throw new TmcBizException(TmcErrorCode.COMMON, new Object[]{new TmcBizResource().checkAmountMaxValue(prop.getDisplayName().getLocaleValue())});
            }
            String feeBillNum = linkGenFeeEntry.getString("feebillnum");
            if (EmptyUtil.isEmpty((String)feeBillNum)) {
                feeBillNum = CodeRuleHelper.generateNumber((String)"cfm_feebill", (DynamicObject)feeBillDo, (String)String.valueOf(thisOrgId), (String)"");
            }
            feeBillDo.set("billno", (Object)feeBillNum);
            needSaveFeeBillLists.add(feeBillDo);
        }
        if (EmptyUtil.isNoEmpty(needSaveFeeBillLists)) {
            SaveServiceHelper.save((DynamicObject[])needSaveFeeBillLists.toArray(new DynamicObject[0]));
        }
    }

    private void setSysBillDefaultVal(Map<Long, Object> idCreatorMap, Map<Long, Object> idModifierMap, Map<Long, Object> idCreateTimeMap, Map<Long, Object> idModifyTimeMap, DynamicObject feeBillDo, Long feeBillId) {
        Object createTime = idCreateTimeMap.get(feeBillId);
        if (EmptyUtil.isNoEmpty((Object)createTime)) {
            feeBillDo.set("createtime", createTime);
        } else {
            feeBillDo.set("createtime", (Object)DateUtils.getCurrentTime());
        }
        Object modifyTime = idModifyTimeMap.get(feeBillId);
        if (EmptyUtil.isNoEmpty((Object)modifyTime)) {
            feeBillDo.set("modifytime", modifyTime);
        } else {
            feeBillDo.set("modifytime", (Object)DateUtils.getCurrentTime());
        }
        long user = RequestContext.get().getCurrUserId();
        Object creator = idCreatorMap.get(feeBillId);
        if (EmptyUtil.isNoEmpty((Object)creator)) {
            feeBillDo.set("creator", creator);
        } else {
            feeBillDo.set("creator", (Object)user);
        }
        Object modifier = idModifierMap.get(feeBillId);
        if (EmptyUtil.isNoEmpty((Object)modifier)) {
            feeBillDo.set("modifier", modifier);
        } else {
            feeBillDo.set("modifier", (Object)user);
        }
    }

    private void lcBizDeal(DynamicObject info, DynamicObject entry) {
        String entityName = info.getDynamicObjectType().getName();
        if (ProductTypeEnum.LC_LETTER.getEntity().equals(entityName)) {
            entry.set("creditno", (Object)info.getString("creditno"));
        } else if (ProductTypeEnum.LC_ARRIVAL.getEntity().equals(entityName) || ProductTypeEnum.LC_PRESENT.getEntity().equals(entityName)) {
            DynamicObject letterCredit = info.getDynamicObject("lettercredit");
            if (EmptyUtil.isNoEmpty((DynamicObject)letterCredit)) {
                entry.set("creditno", (Object)letterCredit.getString("number"));
            }
            entry.set("arrisubno", (Object)info.getString("arrivalno"));
        } else if (ProductTypeEnum.LC_FORFAIT.getEntity().equals(entityName)) {
            DynamicObject arrivalNo;
            DynamicObject letterCredit = info.getDynamicObject("lettercredit");
            if (EmptyUtil.isNoEmpty((DynamicObject)letterCredit)) {
                entry.set("creditno", (Object)letterCredit.getString("number"));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(arrivalNo = info.getDynamicObject("arrivalno")))) {
                entry.set("arrisubno", (Object)arrivalNo.getString("arrivalno"));
            }
        }
    }

    private String getAppSource(String formId) {
        return TmcBusinessBaseHelper.getAppSource((String)formId);
    }

    private Long getIdByBaseDo(DynamicObject info, String propKey) {
        DynamicObject propVal = info.getDynamicObject(propKey);
        return EmptyUtil.isEmpty((DynamicObject)propVal) ? 0L : propVal.getLong("id");
    }

    private void dealFeeDetailSaveFieldsSecondDev(DynamicObject feeBill, DynamicObject row, DynamicObject feeDetailRow) {
        PluginProxy pluginProxy = PluginProxy.create(IFeeDetailSaveAndSubmitAddFields.class, (String)"kd.sdk.tmc.fbp.extpoint.IFeeDetailSaveAndSubmitAddFields");
        pluginProxy.callReplace(proxy -> {
            proxy.feeDetailSaveAndSubmitAddFields(feeBill, row, feeDetailRow);
            return new Object();
        });
    }
}

