/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.init;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.extplugin.PluginProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.sdk.tmc.tda.extpoint.settle.IBigAmountDataInterface;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FundFlowTypeEnum;
import kd.tmc.fbp.common.helper.DispatchGetParamHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.init.ITmcSyncData;
import kd.tmc.fbp.common.init.SyncDataResult;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BigAmountHistoryGenUpdateService
implements ITmcSyncData {
    private static final String TRADETEXTFIELD = "tradetextfield_tag";
    private static final String RECTEXTFIELD = "rectextfield_tag";
    private static final String PAYTEXTFIELD = "paytextfield_tag";
    private static final String ENTITY_TDA_BIGAMOUNTSET = "tda_bigamountset";
    private static final String ENTITY_TDA_BIGAMOUNTBILL = "tda_bigamountbill";
    private static final String BigAmountGetWay = "bigamountgetterway";
    private static final String BigAmountThreshold = "bigamountthreshold";
    private static final int DEFAULT_THRESHOD = 1000000;

    public SyncDataResult syncData() {
        SyncDataResult result = new SyncDataResult();
        result.setBeginDate(new Date());
        ArrayList genBigAmountBills = new ArrayList();
        String bigAmountSetSelectProperties = "bigamountthreshold,bigamountgetterway,tradetextfield_tag,rectextfield_tag,paytextfield_tag";
        DynamicObject bigAmountSet = TmcDataServiceHelper.loadSingle((String)ENTITY_TDA_BIGAMOUNTSET, (String)bigAmountSetSelectProperties, (QFilter[])new QFilter[0]);
        BigDecimal thresholdAmount = bigAmountSet.getBigDecimal(BigAmountThreshold);
        DynamicObject[] finOrgInfos = TmcDataServiceHelper.load((String)"bd_finorginfo", (String)"id,country", (QFilter[])new QFilter[0]);
        DynamicObject[] countries = TmcDataServiceHelper.load((String)"bd_country", (String)"id,twocountrycode", (QFilter[])new QFilter[0]);
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        int pageSize = this.getThreshold(rootOrgId);
        if ("1".equals(bigAmountSet.getString(BigAmountGetWay))) {
            DeleteServiceHelper.delete((String)ENTITY_TDA_BIGAMOUNTBILL, (QFilter[])new QFilter[]{new QFilter("entityname", "=", (Object)"bei_transdetail")});
            QFilter qFilter = this.getExtendFilter().and("bizdate", "<=", (Object)DateUtils.getCurrentDate());
            QFilter filterFromTag = this.getFilterFromTag("bei_transdetail", bigAmountSet.getString(TRADETEXTFIELD));
            if (filterFromTag != null) {
                qFilter.and(filterFromTag);
            }
            String transDetailSelectProperties = "id,org,bizdate,accountbank,bank,oppbanknumber,oppunit,oppbank,debitamount,creditamount,description,company,billno,currency";
            HashMap rateMap = new HashMap(16);
            BigAmountHistoryGenUpdateService.batchQueryByCriticalId("bei_transdetail", transDetailSelectProperties, qFilter, pageSize, transDetails -> {
                for (DynamicObject transDetail : (DynamicObject[])transDetails) {
                    long currencyId = transDetail.getLong("currency.id");
                    long orgId = transDetail.getLong("company.id");
                    BigDecimal debitAmount = transDetail.getBigDecimal("debitamount");
                    BigDecimal creditAmount = transDetail.getBigDecimal("creditamount");
                    BigDecimal transAmount = debitAmount.intValue() == 0 ? creditAmount : debitAmount;
                    BigDecimal rmbAmount = this.transToRmbAmount(transAmount, currencyId, orgId, rateMap);
                    if (rmbAmount.compareTo(thresholdAmount) < 0) continue;
                    DynamicObject bigAmountBill = TmcDataServiceHelper.newDynamicObject((String)ENTITY_TDA_BIGAMOUNTBILL);
                    this.setCommonProperty(transDetail, bigAmountBill);
                    this.setTransDetailProperty(transDetail, bigAmountBill, finOrgInfos, countries);
                    genBigAmountBills.add(bigAmountBill);
                }
            });
        } else if ("0".equals(bigAmountSet.getString(BigAmountGetWay))) {
            DeleteServiceHelper.delete((String)ENTITY_TDA_BIGAMOUNTBILL, (QFilter[])new QFilter[]{new QFilter("entityname", "in", Arrays.asList("cas_recbill", "cas_paybill"))});
            QFilter recFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.PAYED.getValue());
            QFilter recFilterFromTag = this.getFilterFromTag("cas_recbill", bigAmountSet.getString(RECTEXTFIELD));
            if (recFilterFromTag != null) {
                recFilter.and(recFilterFromTag);
            }
            String recBillSelectProperties = "id,org,accountbank,payeebank,payeedate,entry,payeracctbanknum,payerbankname,payername,actrecamt,exchangerate,billno,currency,txt_description";
            BigAmountHistoryGenUpdateService.batchQueryByCriticalId("cas_recbill", recBillSelectProperties, recFilter, pageSize, recBills -> {
                List recBillList = Arrays.stream((DynamicObject[])recBills).filter(e -> e.getBigDecimal("actrecamt").multiply(e.getBigDecimal("exchangerate")).compareTo(thresholdAmount) >= 0).collect(Collectors.toList());
                for (DynamicObject recBill : recBillList) {
                    DynamicObject bigAmountBill = TmcDataServiceHelper.newDynamicObject((String)ENTITY_TDA_BIGAMOUNTBILL);
                    this.setCommonProperty(recBill, bigAmountBill);
                    this.setRecBillProperty(recBill, bigAmountBill, finOrgInfos, countries);
                    genBigAmountBills.add(bigAmountBill);
                }
            });
            String payBillSelectProperties = "id,org,payeracctbank,payerbank,paydate,entry,payeebanknum,payeename,payeebankname,actpayamt,exchangerate,billno,currency,description";
            QFilter payqFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.PAYED.getValue());
            QFilter payFilterFromTag = this.getFilterFromTag("cas_paybill", bigAmountSet.getString(PAYTEXTFIELD));
            if (payFilterFromTag != null) {
                payqFilter.and(payFilterFromTag);
            }
            BigAmountHistoryGenUpdateService.batchQueryByCriticalId("cas_paybill", payBillSelectProperties, payqFilter, pageSize, payBills -> {
                List payBillList = Arrays.stream((DynamicObject[])payBills).filter(e -> e.getBigDecimal("actpayamt").multiply(e.getBigDecimal("exchangerate")).compareTo(thresholdAmount) >= 0).collect(Collectors.toList());
                for (DynamicObject payBill : payBillList) {
                    DynamicObject bigAmountBill = TmcDataServiceHelper.newDynamicObject((String)ENTITY_TDA_BIGAMOUNTBILL);
                    this.setCommonProperty(payBill, bigAmountBill);
                    this.setPayBillProperty(payBill, bigAmountBill, finOrgInfos, countries);
                    genBigAmountBills.add(bigAmountBill);
                }
            });
        }
        SaveServiceHelper.save((DynamicObject[])genBigAmountBills.toArray(new DynamicObject[0]));
        result.setEndDate(new Date());
        result.setResult("execute success");
        return result;
    }

    private int getThreshold(long rootOrgId) {
        int threshold = (Integer)DispatchGetParamHelper.getParamValue((String)"transdetailthreshold", Integer.class);
        if (EmptyUtil.isEmpty((Integer)threshold)) {
            threshold = 1000000;
        }
        return threshold;
    }

    private QFilter getExtendFilter() {
        PluginProxy pluginProxy = PluginProxy.create(IBigAmountDataInterface.class, (String)"kd.sdk.tmc.tda.extpoint.settle.IBigAmountDataInterface");
        List lists = pluginProxy.callReplace(IBigAmountDataInterface::getExtendFilter);
        if (EmptyUtil.isNoEmpty((Object)lists) && EmptyUtil.isNoEmpty(lists.get(0))) {
            return (QFilter)lists.get(0);
        }
        return QFilter.of((String)"1=1", (Object[])new Object[0]);
    }

    private void setCommonProperty(DynamicObject transData, DynamicObject bigAmountBill) {
        bigAmountBill.set("billno", transData.get("billno"));
        bigAmountBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        bigAmountBill.set("creator", (Object)RequestContext.get().getCurrUserId());
        bigAmountBill.set("createtime", (Object)DateUtils.getCurrentTime());
        bigAmountBill.set("currency", transData.get("currency"));
        bigAmountBill.set("entityname", (Object)transData.getDataEntityType().getName());
    }

    private void setTransDetailProperty(DynamicObject transDetail, DynamicObject bigAmountBill, DynamicObject[] finOrgInfos, DynamicObject[] countries) {
        bigAmountBill.set("org", transDetail.get("company"));
        bigAmountBill.set("bizdate", (Object)transDetail.getDate("bizdate"));
        bigAmountBill.set("accountbank", transDetail.get("accountbank"));
        DynamicObject bank = transDetail.getDynamicObject("bank");
        bigAmountBill.set("bank", (Object)bank);
        this.setRegion(bank, bigAmountBill, finOrgInfos, countries);
        bigAmountBill.set("oppaccountbank", transDetail.get("oppbanknumber"));
        bigAmountBill.set("oppname", transDetail.get("oppunit"));
        bigAmountBill.set("oppbank", transDetail.get("oppbank"));
        BigDecimal debitAmount = transDetail.getBigDecimal("debitamount");
        BigDecimal creditAmount = transDetail.getBigDecimal("creditamount");
        bigAmountBill.set("debitamount", (Object)debitAmount);
        bigAmountBill.set("creditamount", (Object)creditAmount);
        if (debitAmount.intValue() != 0) {
            bigAmountBill.set("moneyflow", (Object)FundFlowTypeEnum.OUT_FLOW.getValue());
        } else if (creditAmount.intValue() != 0) {
            bigAmountBill.set("moneyflow", (Object)FundFlowTypeEnum.IN_FLOW.getValue());
        }
        bigAmountBill.set("usage", transDetail.get("description"));
    }

    private void setPayBillProperty(DynamicObject payBill, DynamicObject bigAmountBill, DynamicObject[] finOrgInfos, DynamicObject[] countries) {
        bigAmountBill.set("org", payBill.get("org"));
        bigAmountBill.set("accountbank", payBill.get("payeracctbank"));
        DynamicObject payerBank = payBill.getDynamicObject("payerbank");
        bigAmountBill.set("bank", (Object)payerBank);
        this.setRegion(payerBank, bigAmountBill, finOrgInfos, countries);
        bigAmountBill.set("bizdate", (Object)payBill.getDate("paydate"));
        bigAmountBill.set("oppaccountbank", payBill.get("payeebanknum"));
        bigAmountBill.set("oppname", payBill.get("payeename"));
        bigAmountBill.set("oppbank", payBill.get("payeebankname"));
        bigAmountBill.set("debitamount", payBill.get("actpayamt"));
        bigAmountBill.set("moneyflow", (Object)FundFlowTypeEnum.OUT_FLOW.getValue());
        bigAmountBill.set("usage", payBill.get("description"));
    }

    private void setRecBillProperty(DynamicObject recBill, DynamicObject bigAmountBill, DynamicObject[] finOrgInfos, DynamicObject[] countries) {
        bigAmountBill.set("org", recBill.get("org"));
        bigAmountBill.set("accountbank", recBill.get("accountbank"));
        DynamicObject payeeBank = recBill.getDynamicObject("payeebank");
        this.setRegion(payeeBank, bigAmountBill, finOrgInfos, countries);
        bigAmountBill.set("bank", (Object)payeeBank);
        Date recDate = recBill.getDate("payeedate");
        bigAmountBill.set("bizdate", (Object)DateUtils.getDataFormat((Date)recDate, (boolean)true));
        bigAmountBill.set("oppaccountbank", recBill.get("payeracctbanknum"));
        bigAmountBill.set("oppbank", recBill.get("payerbankname"));
        bigAmountBill.set("oppname", recBill.get("payername"));
        bigAmountBill.set("creditamount", recBill.get("actrecamt"));
        bigAmountBill.set("moneyflow", (Object)FundFlowTypeEnum.IN_FLOW.getValue());
        bigAmountBill.set("usage", recBill.get("txt_description"));
    }

    private BigDecimal transToRmbAmount(BigDecimal amount, Long fromCurrencyId, Long orgId, Map<Long, BigDecimal> rateMap) {
        BigDecimal rate;
        long tarCurrencyId = 1L;
        if (fromCurrencyId.equals(tarCurrencyId)) {
            rate = BigDecimal.ONE;
        } else {
            rate = rateMap.get(fromCurrencyId);
            if (rate == null) {
                rate = TmcBusinessBaseHelper.getExchangeRate((long)fromCurrencyId, (long)tarCurrencyId, (long)orgId, (Date)DateUtils.getCurrentDate());
                if (rate == null) {
                    rate = BigDecimal.ONE;
                }
                rateMap.put(fromCurrencyId, rate);
            }
        }
        return amount.multiply(rate);
    }

    private void setRegion(DynamicObject finOrgInfo, DynamicObject bigAmountBill, DynamicObject[] finOrgInfos, DynamicObject[] countries) {
        List banks;
        if (finOrgInfo != null && !(banks = Arrays.stream(finOrgInfos).filter(e -> finOrgInfo.getLong("id") == e.getLong("id")).collect(Collectors.toList())).isEmpty()) {
            DynamicObject bank = (DynamicObject)banks.get(0);
            DynamicObject country = bank.getDynamicObject("country");
            if (country == null) {
                bigAmountBill.set("region", (Object)"domestic");
            } else {
                List countryInfos = Arrays.stream(countries).filter(e -> country.getLong("id") == e.getLong("id")).collect(Collectors.toList());
                if (!countryInfos.isEmpty()) {
                    DynamicObject countryInfo = (DynamicObject)countryInfos.get(0);
                    String twoCountryCode = countryInfo.getString("twocountrycode");
                    if (twoCountryCode.equals("CN")) {
                        bigAmountBill.set("region", (Object)"domestic");
                    } else {
                        bigAmountBill.set("region", (Object)"overseas");
                    }
                }
            }
        }
    }

    private static Long[] getMinAndMaxId(String entityName) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)entityName, (String)"min(id) minId, max(id) maxId", (QFilter[])new QFilter[]{new QFilter("1", "=", (Object)1)});
        Long minId = 0L;
        Long maxId = 0L;
        if (query != null && query.get(0) != null) {
            DynamicObject dynamicObject = (DynamicObject)query.get(0);
            minId = dynamicObject.getLong("minId");
            maxId = dynamicObject.getLong("maxId");
        }
        return new Long[]{minId, maxId};
    }

    private static void batchQueryByCriticalId(String entityName, String selects, QFilter qFilter, int pageSize, Consumer consumer) {
        Long[] minAndMaxId = BigAmountHistoryGenUpdateService.getMinAndMaxId(entityName);
        if (minAndMaxId[1].equals(0L) && minAndMaxId[0].equals(minAndMaxId[1])) {
            return;
        }
        boolean isFirst = Boolean.TRUE;
        int objectsLength = 0;
        while (isFirst || pageSize == objectsLength) {
            Long criticalId;
            QFilter idFilter = new QFilter("1", "=", (Object)1);
            if (isFirst) {
                isFirst = Boolean.FALSE;
                idFilter.and("id", ">=", (Object)minAndMaxId[0]);
            } else {
                idFilter.and("id", ">", (Object)minAndMaxId[0]);
            }
            DynamicObject[] objects = TmcDataServiceHelper.load((String)entityName, (String)selects, (QFilter[])new QFilter[]{qFilter, idFilter}, (String)"id", (int)0, (int)pageSize);
            objectsLength = objects.length;
            if (objectsLength == 0) break;
            consumer.accept(objects);
            minAndMaxId[0] = criticalId = (Long)objects[objects.length - 1].get("id");
        }
    }

    private QFilter getFilterFromTag(String entryName, String filterTag) {
        if (EmptyUtil.isEmpty((String)filterTag)) {
            return null;
        }
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)filterTag, CRCondition.class);
        FilterCondition filterCondition = condition.getFilterCondition();
        MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)entryName);
        FilterBuilder fb = new FilterBuilder(dataType, filterCondition, true);
        fb.buildFilter(true);
        return fb.getQFilter();
    }
}

