/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.init;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.init.ITmcSyncData;
import kd.tmc.fbp.common.init.SyncDataResult;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CfmContractUpgradeDataService
implements ITmcSyncData {
    private static final Log logger = LogFactory.getLog(CfmContractUpgradeDataService.class);

    public SyncDataResult syncData() {
        SyncDataResult result = new SyncDataResult();
        result.setBeginDate(new Date());
        this.upgradeContractName();
        this.upgradeTerm();
        this.upgradeFinType();
        this.upgradeProject();
        this.upgradeLoanExtendBillByContract();
        this.upgradeRepaymentInterestBillByLoanBill();
        result.setResult("upgrade success");
        result.setEndDate(new Date());
        return result;
    }

    private void upgradeContractName() {
        logger.info("\u5408\u540cNAME\u5b57\u6bb5\u5347\u7ea7============");
        QFilter tFilter = new QFilter("billstatus", "!=", (Object)"A");
        tFilter.and(QFilter.isNotNull((String)"billno")).and(QFilter.isNull((String)"contractname").or(new QFilter("contractname", "=", (Object)"").or(new QFilter("contractname", "=", (Object)" ")))).and(new QFilter("loantype", "!=", (Object)"bond"));
        int totalCnt = TmcDataServiceHelper.count((String)"cfm_loancontractbill", (QFilter[])tFilter.toArray());
        int pageSize = 200;
        int pages = totalCnt / pageSize + 1;
        for (int pageIndex = 0; pageIndex < pages; ++pageIndex) {
            Object[] contractBills = TmcDataServiceHelper.load((String)"cfm_loancontractbill", (String)"contractname,billno", (QFilter[])new QFilter[]{tFilter}, (String)"id", (int)pageIndex, (int)pageSize);
            if (!EmptyUtil.isNoEmpty((Object[])contractBills)) continue;
            for (Object contractBill : contractBills) {
                String billno = contractBill.getString("billno");
                contractBill.set("contractname", (Object)billno);
            }
            TmcDataServiceHelper.save((DynamicObject[])contractBills);
        }
        logger.info("\u5408\u540cNAME\u5b57\u6bb5\u5347\u7ea7\u7ed3\u675f" + totalCnt);
    }

    private void upgradeTerm() {
        logger.info("\u5408\u540c\u5355\u671f\u9650\u5b57\u6bb5\u5347\u7ea7============");
        QFilter tFilter = new QFilter("term", "=", (Object)"").or(new QFilter("term", "=", (Object)" ")).and(QFilter.isNotNull((String)"startdate")).and(QFilter.isNotNull((String)"enddate"));
        int totalCnt = TmcDataServiceHelper.count((String)"cfm_loancontractbill", (QFilter[])tFilter.toArray());
        int pageSize = 200;
        int pages = totalCnt / pageSize + 1;
        for (int pageIndex = 0; pageIndex < pages; ++pageIndex) {
            Object[] contractBills = TmcDataServiceHelper.load((String)"cfm_loancontractbill", (String)"startdate,enddate,term", (QFilter[])new QFilter[]{tFilter}, (String)"id", (int)pageIndex, (int)pageSize);
            if (!EmptyUtil.isNoEmpty((Object[])contractBills)) continue;
            for (Object contractBill : contractBills) {
                Date bizDate = contractBill.getDate("startdate");
                Date expireDate = contractBill.getDate("enddate");
                contractBill.set("term", (Object)DateUtils.getDiff_ymd((Date)bizDate, (Date)expireDate));
            }
            TmcDataServiceHelper.save((DynamicObject[])contractBills);
        }
        logger.info("\u5408\u540c\u5355\u671f\u9650\u5b57\u6bb5\u5347\u7ea7\u7ed3\u675f" + totalCnt);
    }

    private void upgradeFinType() {
        logger.info("\u5408\u540c\u503a\u6743\u503a\u52a1\u4eba\u7c7b\u578b\u5b57\u6bb5\u5347\u7ea7START============");
        DataSet ds = DB.queryDataSet((String)"upgradeFinType", (DBRoute)DBRoute.of((String)"tmc"), (String)"select fid, ffinorginfoid from t_cfm_loancontractbill where ffinorginfoid>0 and flendernature ='outgroup'");
        Iterator it = ds.iterator();
        HashSet<DynamicObject[]> finIdSet = new HashSet<DynamicObject[]>(10);
        HashMap<DynamicObject[], HashSet<Long>> finIdToBillIdSetMap = new HashMap<DynamicObject[], HashSet<Long>>(10);
        HashSet<Long> allBillIdSet = new HashSet<Long>(10);
        while (it.hasNext()) {
            Row row = (Row)it.next();
            Long billId = row.getLong("fid");
            allBillIdSet.add(billId);
            DynamicObject[] finId = row.getLong("ffinorginfoid");
            finIdSet.add(finId);
            HashSet<Long> billIds = (HashSet<Long>)finIdToBillIdSetMap.get(finId);
            if (billIds == null) {
                billIds = new HashSet<Long>();
                billIds.add(billId);
                finIdToBillIdSetMap.put(finId, billIds);
                continue;
            }
            billIds.add(billId);
        }
        if (allBillIdSet.isEmpty()) {
            return;
        }
        DynamicObject[] finorgs = TmcDataServiceHelper.load((Object[])finIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_finorginfo"));
        HashSet billIdCreditorTypeBankSet = new HashSet(10);
        for (DynamicObject fin : finorgs) {
            Long finId = fin.getLong("id");
            if (!FinOrgTypeEnum.BANK.getValue().equals(fin.getString("finorgtype.type"))) continue;
            billIdCreditorTypeBankSet.addAll((Collection)finIdToBillIdSetMap.get(finId));
        }
        allBillIdSet.removeAll(billIdCreditorTypeBankSet);
        QFilter bankQ = new QFilter("id", "in", billIdCreditorTypeBankSet);
        this.updateCredtorType("cfm_loancontractbill", bankQ, "creditortype", "bank");
        QFilter otherbankQ = new QFilter("id", "in", allBillIdSet);
        this.updateCredtorType("cfm_loancontractbill", otherbankQ, "creditortype", "finorg");
        logger.info("\u5408\u540c\u503a\u6743\u503a\u52a1\u4eba\u7c7b\u578b\u5b57\u6bb5\u5347\u7ea7END============");
    }

    private void upgradeLoanExtendBillByContract() {
        logger.info("\u5347\u7ea7\u5408\u540c\u76f4\u63a5\u4e0b\u6e38 \u6b3e\u548c\u5c55\u671f\u5408\u540c\u503a\u6743\u503a\u52a1\u4eba\u7c7b\u578b\u5b57\u6bb5\u5347\u7ea7Start============");
        int totalCnt = TmcDataServiceHelper.count((String)"cfm_loancontractbill", null);
        int pageSize = 200;
        int pages = totalCnt / pageSize + 1;
        for (int pageIndex = 0; pageIndex < pages; ++pageIndex) {
            DynamicObject[] contractBills = TmcDataServiceHelper.load((String)"cfm_loancontractbill", (String)"loantype, creditortype, creditor, textcreditor,debtortype,debtor,textdebtor, creditorg, org", null, (String)"id", (int)pageIndex, (int)pageSize);
            this.upgradeCreditorDebtorBySourceBill(contractBills, "cfm_loanbill");
            this.upgradeCreditorDebtorBySourceBill(contractBills, "cfm_contractextendbill");
        }
        logger.info("\u5347\u7ea7\u5408\u540c\u76f4\u63a5\u4e0b\u6e38 \u63d0\u6b3e\u548c\u5c55\u671f \u503a\u6743\u503a\u52a1\u4eba\u7c7b\u578b\u5b57\u6bb5\u5347\u7ea7END============");
    }

    private void upgradeRepaymentInterestBillByLoanBill() {
        logger.info("\u5347\u7ea7\u63d0\u6b3e\u76f4\u63a5\u4e0b\u6e38 \u8fd8\u6b3e\u5355\u548c\u5229\u606f\u5355 \u503a\u6743\u503a\u52a1\u4eba\u7c7b\u578b\u5b57\u6bb5\u5347\u7ea7Start============");
        int totalCnt = TmcDataServiceHelper.count((String)"cfm_loanbill", null);
        int pageSize = 200;
        int pages = totalCnt / pageSize + 1;
        for (int pageIndex = 0; pageIndex < pages; ++pageIndex) {
            DynamicObject[] loanBills = TmcDataServiceHelper.load((String)"cfm_loanbill", (String)"loantype, creditortype, creditor, textcreditor, debtortype,  debtor, textdebtor, creditorg, org", null, (String)"id", (int)pageIndex, (int)pageSize);
            this.upgradeCreditorDebtorBySourceBill(loanBills, "cfm_repaymentbill");
            this.upgradeCreditorDebtorBySourceBill(loanBills, "cfm_interestbill");
            this.upgradeCreditorDebtorBySourceBill(loanBills, "cfm_preinterestbill");
        }
        logger.info("\u5347\u7ea7\u63d0\u6b3e\u76f4\u63a5\u4e0b\u6e38 \u8fd8\u6b3e\u5355\u548c\u5229\u606f\u5355 \u503a\u6743\u503a\u52a1\u4eba\u7c7b\u578b\u5b57\u6bb5\u5347\u7ea7End===========");
    }

    private void upgradeCreditorDebtorBySourceBill(DynamicObject[] bills, String targetentity) {
        logger.info("upgradeCreditorDebtorBySourceBill Start===========");
        HashSet<Long> srcIdSet = new HashSet<Long>(16);
        HashMap<Long, DynamicObject> srcIdMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject bill : bills) {
            Long id = bill.getLong("id");
            srcIdSet.add(bill.getLong("id"));
            srcIdMap.put(id, bill);
        }
        QFilter qf = new QFilter("sourcebillid", "in", srcIdSet);
        Object[] billsToUpgrade = null;
        billsToUpgrade = "cfm_preinterestbill".equals(targetentity) ? TmcDataServiceHelper.load((String)targetentity, (String)"loantype,creditortype, creditor, textcreditor, org, sourcebillid", (QFilter[])qf.toArray()) : TmcDataServiceHelper.load((String)targetentity, (String)"loantype, creditortype, creditor, textcreditor, debtortype,  debtor, textdebtor, creditorg, org, sourcebillid", (QFilter[])qf.toArray());
        for (Object bill : billsToUpgrade) {
            DynamicObject srcDO = (DynamicObject)srcIdMap.get(bill.getLong("sourcebillid"));
            bill.set("creditortype", srcDO.get("creditortype"));
            bill.set("creditor", srcDO.get("creditor"));
            bill.set("textcreditor", srcDO.get("textcreditor"));
            bill.set("org", srcDO.get("org"));
            bill.set("loantype", srcDO.get("loantype"));
            if ("cfm_preinterestbill".equals(targetentity)) continue;
            bill.set("debtortype", srcDO.get("debtortype"));
            bill.set("debtor", srcDO.get("debtor"));
            bill.set("textdebtor", srcDO.get("textdebtor"));
            bill.set("creditorg", srcDO.get("creditorg"));
        }
        if (EmptyUtil.isNoEmpty((Object[])billsToUpgrade)) {
            TmcDataServiceHelper.save((DynamicObject[])billsToUpgrade);
        }
        logger.info("upgradeCreditorDebtorBySourceBill End===========");
    }

    private void updateCredtorType(String entityname, QFilter qFilter, String propname, String val) {
        Object[] bills;
        for (Object bill : bills = TmcDataServiceHelper.load((String)entityname, (String)propname, (QFilter[])qFilter.toArray())) {
            bill.set(propname, (Object)val);
        }
        if (EmptyUtil.isNoEmpty((Object[])bills)) {
            SaveServiceHelper.save((DynamicObject[])bills);
        }
    }

    private void upgradeProject() {
        Object[] bills;
        logger.info("\u5408\u540c\u9879\u76ee\u5206\u5f55\u5b57\u6bb5\u5347\u7ea7START============");
        DataSet ds = DB.queryDataSet((String)"upgradeProject", (DBRoute)DBRoute.of((String)"tmc"), (String)"select c.fid, c.fprojectid from t_cfm_loancontractbill  c where c.fprojectid>0 and \u3000not exists (select 1 from t_cfm_loancontractbill_pj p where p.fid= c.fid)");
        Iterator it = ds.iterator();
        HashSet<Long> allBillIdSet = new HashSet<Long>(16);
        HashMap<Long, Long> billProjectMap = new HashMap<Long, Long>(10);
        while (it.hasNext()) {
            Row row = (Row)it.next();
            Long billId = row.getLong("fid");
            allBillIdSet.add(billId);
            Long projectId = row.getLong("fprojectid");
            billProjectMap.put(billId, projectId);
        }
        QFilter qFilter = new QFilter("id", "in", allBillIdSet);
        for (Object bill : bills = TmcDataServiceHelper.load((String)"cfm_loancontractbill", (String)"project_entry.seq,project_entry.e_project", (QFilter[])qFilter.toArray())) {
            DynamicObjectCollection pEntrys = bill.getDynamicObjectCollection("project_entry");
            DynamicObject entry = pEntrys.addNew();
            entry.set("seq", (Object)1);
            entry.set("e_project", billProjectMap.get(bill.getPkValue()));
        }
        if (EmptyUtil.isNoEmpty((Object[])bills)) {
            SaveServiceHelper.save((DynamicObject[])bills);
        }
        logger.info("\u5408\u540c\u9879\u76ee\u5206\u5f55\u5b57\u6bb5\u5347\u7ea7END============");
    }
}

