/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.init;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.init.ITmcSyncData;
import kd.tmc.fbp.common.init.SyncDataResult;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CfmInitBillUpgradeDataService
implements ITmcSyncData {
    private static final Log logger = LogFactory.getLog(CfmInitBillUpgradeDataService.class);

    public SyncDataResult syncData() {
        SyncDataResult result = new SyncDataResult();
        result.setBeginDate(new Date());
        this.upgradeTerm();
        this.upgradeLoanTerm();
        this.upgradeFinType();
        this.upgradeProject();
        result.setResult("upgrade success");
        result.setEndDate(new Date());
        return result;
    }

    private void upgradeTerm() {
        logger.info("\u671f\u9650\u5b57\u6bb5\u5347\u7ea7============");
        QFilter tFilter = new QFilter("term", "=", (Object)"").or(new QFilter("term", "=", (Object)" ")).or(QFilter.isNull((String)"term")).and(QFilter.isNotNull((String)"startdate")).and(QFilter.isNotNull((String)"enddate"));
        int totalCnt = TmcDataServiceHelper.count((String)"cfm_initbill", (QFilter[])tFilter.toArray());
        int pageSize = 200;
        int pages = totalCnt / pageSize + 1;
        for (int pageIndex = 0; pageIndex < pages; ++pageIndex) {
            Object[] initBills = TmcDataServiceHelper.load((String)"cfm_initbill", (String)"startdate,enddate,term", (QFilter[])new QFilter[]{tFilter}, (String)"id", (int)pageIndex, (int)pageSize);
            if (!EmptyUtil.isNoEmpty((Object[])initBills)) continue;
            for (Object initBill : initBills) {
                Date bizDate = initBill.getDate("startdate");
                Date expireDate = initBill.getDate("enddate");
                initBill.set("term", (Object)DateUtils.getDiff_ymd((Date)bizDate, (Date)expireDate));
            }
            TmcDataServiceHelper.save((DynamicObject[])initBills);
        }
        logger.info("\u671f\u9650\u5b57\u6bb5\u5347\u7ea7\u7ed3\u675f" + totalCnt);
    }

    private void upgradeLoanTerm() {
        logger.info("\u63d0\u6b3e\u671f\u9650\u5b57\u6bb5\u5347\u7ea7============");
        QFilter tFilter = new QFilter("loanentry.loanterm", "=", (Object)"").or(new QFilter("loanentry.loanterm", "=", (Object)" ")).or(QFilter.isNull((String)"loanentry.loanterm")).and(QFilter.isNotNull((String)"loanentry.expiredate")).and(QFilter.isNotNull((String)"loanentry.loaddate"));
        DynamicObject[] billDOs = TmcDataServiceHelper.load((String)"cfm_initbill", (String)"id", (QFilter[])tFilter.toArray());
        if (billDOs == null || billDOs.length == 0) {
            return;
        }
        int totalCnt = billDOs.length;
        int pageSize = 200;
        int pages = totalCnt / pageSize + 1;
        for (int pageIndex = 0; pageIndex < pages; ++pageIndex) {
            Object[] initBills = TmcDataServiceHelper.load((String)"cfm_initbill", (String)"loanentry.loaddate,loanentry.expiredate,loanentry.loanterm", (QFilter[])new QFilter[]{tFilter}, (String)"id", (int)pageIndex, (int)pageSize);
            if (!EmptyUtil.isNoEmpty((Object[])initBills)) continue;
            for (Object initBill : initBills) {
                DynamicObjectCollection entrys = initBill.getDynamicObjectCollection("loanentry");
                for (DynamicObject loan : entrys) {
                    Date bizDate = loan.getDate("loaddate");
                    Date expireDate = loan.getDate("expiredate");
                    loan.set("loanterm", (Object)DateUtils.getDiff_ymd((Date)bizDate, (Date)expireDate));
                }
            }
            TmcDataServiceHelper.save((DynamicObject[])initBills);
        }
        logger.info("\u63d0\u6b3e\u671f\u9650\u5b57\u6bb5\u5347\u7ea7\u7ed3\u675f" + totalCnt);
    }

    private void upgradeFinType() {
        logger.info("\u503a\u52a1\u4eba\u7c7b\u578b\u5b57\u6bb5\u5347\u7ea7START============");
        DataSet ds = DB.queryDataSet((String)"upgradeFinType", (DBRoute)DBRoute.of((String)"tmc"), (String)"select fid, ffinorginfoid from t_cfm_initbill where ffinorginfoid>0 and flendernature ='outgroup'");
        Iterator it = ds.iterator();
        HashSet<DynamicObject[]> finIdSet = new HashSet<DynamicObject[]>(10);
        HashMap<DynamicObject[], HashSet<Long>> finIdToBillIdSetMap = new HashMap<DynamicObject[], HashSet<Long>>(10);
        HashSet<Long> allBillIdSet = new HashSet<Long>(10);
        while (it.hasNext()) {
            Row row = (Row)it.next();
            Long billId = row.getLong("fid");
            allBillIdSet.add(billId);
            DynamicObject[] finId = row.getLong("ffinorginfoid");
            finIdSet.add(finId);
            HashSet<Long> billIds = (HashSet<Long>)finIdToBillIdSetMap.get(finId);
            if (billIds == null) {
                billIds = new HashSet<Long>();
                billIds.add(billId);
                finIdToBillIdSetMap.put(finId, billIds);
                continue;
            }
            billIds.add(billId);
        }
        if (allBillIdSet.isEmpty()) {
            return;
        }
        DynamicObject[] finorgs = TmcDataServiceHelper.load((Object[])finIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_finorginfo"));
        HashSet billIdCreditorTypeBankSet = new HashSet(10);
        for (DynamicObject fin : finorgs) {
            Long finId = fin.getLong("id");
            if (!FinOrgTypeEnum.BANK.getValue().equals(fin.getString("finorgtype.type"))) continue;
            billIdCreditorTypeBankSet.addAll((Collection)finIdToBillIdSetMap.get(finId));
        }
        allBillIdSet.removeAll(billIdCreditorTypeBankSet);
        QFilter bankQ = new QFilter("id", "in", billIdCreditorTypeBankSet);
        this.updateCredtorType("cfm_initbill", bankQ, "creditortype", "bank");
        QFilter otherbankQ = new QFilter("id", "in", allBillIdSet);
        this.updateCredtorType("cfm_initbill", otherbankQ, "creditortype", "finorg");
        logger.info("\u5408\u540c\u503a\u6743\u503a\u52a1\u4eba\u7c7b\u578b\u5b57\u6bb5\u5347\u7ea7END============");
    }

    private void updateCredtorType(String entityname, QFilter qFilter, String propname, String val) {
        Object[] bills;
        for (Object bill : bills = TmcDataServiceHelper.load((String)entityname, (String)propname, (QFilter[])qFilter.toArray())) {
            bill.set(propname, (Object)val);
        }
        if (EmptyUtil.isNoEmpty((Object[])bills)) {
            SaveServiceHelper.save((DynamicObject[])bills);
        }
    }

    private void upgradeProject() {
        Object[] bills;
        logger.info("\u5408\u540c\u9879\u76ee\u5206\u5f55\u5b57\u6bb5\u5347\u7ea7START============");
        DataSet ds = DB.queryDataSet((String)"upgradeProject", (DBRoute)DBRoute.of((String)"tmc"), (String)"select c.fid, c.fprojectid from t_cfm_initbill  c where c.fprojectid>0 and \u3000not exists (select 1 from t_cfm_loancontractbill_pj p where p.fid= c.fid)");
        Iterator it = ds.iterator();
        HashSet<Long> allBillIdSet = new HashSet<Long>(16);
        HashMap<Long, Long> billProjectMap = new HashMap<Long, Long>(10);
        while (it.hasNext()) {
            Row row = (Row)it.next();
            Long billId = row.getLong("fid");
            allBillIdSet.add(billId);
            Long projectId = row.getLong("fprojectid");
            billProjectMap.put(billId, projectId);
        }
        QFilter qFilter = new QFilter("id", "in", allBillIdSet);
        for (Object bill : bills = TmcDataServiceHelper.load((String)"cfm_initbill", (String)"project_entry.seq,project_entry.e_project", (QFilter[])qFilter.toArray())) {
            DynamicObjectCollection pEntrys = bill.getDynamicObjectCollection("project_entry");
            DynamicObject entry = pEntrys.addNew();
            entry.set("seq", (Object)1);
            entry.set("e_project", billProjectMap.get(bill.getPkValue()));
        }
        if (EmptyUtil.isNoEmpty((Object[])bills)) {
            SaveServiceHelper.save((DynamicObject[])bills);
        }
        logger.info("\u5408\u540c\u9879\u76ee\u5206\u5f55\u5b57\u6bb5\u5347\u7ea7END============");
    }
}

