/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.init;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.init.ITmcSyncData;
import kd.tmc.fbp.common.init.SyncDataResult;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CfmLoanSyncDataService
implements ITmcSyncData {
    private static final Log logger = LogFactory.getLog(CfmLoanSyncDataService.class);

    public SyncDataResult syncData() throws KDException {
        SyncDataResult result = new SyncDataResult();
        result.setBeginDate(new Date());
        logger.info("\u63d0\u6b3e\u5355\u6570\u636e\u5347\u7ea7\u5f00\u59cb============");
        QFilter loanFilter = new QFilter("term", "=", (Object)"").or(new QFilter("term", "=", (Object)" ")).and(QFilter.isNotNull((String)"expiredate")).and(QFilter.isNotNull((String)"bizdate"));
        int totalCnt = TmcDataServiceHelper.count((String)"cfm_loanbill", (QFilter[])loanFilter.toArray());
        int pageSize = 200;
        int pages = totalCnt / pageSize + 1;
        for (int pageIndex = 0; pageIndex < pages; ++pageIndex) {
            Object[] loanBills = TmcDataServiceHelper.load((String)"cfm_loanbill", (String)"bizdate,expiredate,term", (QFilter[])new QFilter[]{loanFilter}, (String)"id", (int)pageIndex, (int)pageSize);
            if (!EmptyUtil.isNoEmpty((Object[])loanBills)) continue;
            for (Object loanBill : loanBills) {
                Date bizDate = loanBill.getDate("bizdate");
                Date expireDate = loanBill.getDate("expiredate");
                loanBill.set("term", (Object)DateUtils.getDiff_ymd((Date)bizDate, (Date)expireDate));
            }
            TmcDataServiceHelper.save((DynamicObject[])loanBills);
        }
        logger.info("\u63d0\u6b3e\u5355\u671f\u9650\u5b57\u6bb5\u5347\u7ea7\u7ed3\u675f" + totalCnt);
        result.setSuccessCount(totalCnt);
        result.setResult("upgrade success");
        result.setEndDate(new Date());
        return result;
    }
}

