/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.init;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.init.ITmcSyncData;
import kd.tmc.fbp.common.init.SyncDataResult;

public class CheckItemStatusUpService
implements ITmcSyncData {
    private static final Log logger = LogFactory.getLog(CheckItemStatusUpService.class);
    private static final String CS087 = "cs087";
    private static final String CS092 = "cs092";
    private static final String CS091 = "cs091";
    private static final String CS093 = "cs093";

    public SyncDataResult syncData() {
        Map<Long, Boolean> cs093Map;
        Map<Long, Boolean> cs091Map;
        Map<Long, Boolean> cs092Map;
        Map<Long, Boolean> cs087Map;
        SyncDataResult result = new SyncDataResult();
        result.setBeginDate(new Date());
        String orgSql = "select fid from t_ORG_ORG where fenable ='1' and FIsBankroll = '1'";
        DataSet orgDataSet = DB.queryDataSet((String)"queryOrgIds", (DBRoute)new DBRoute("sys"), (String)orgSql);
        ArrayList<Long> orgIds = new ArrayList<Long>(1000);
        if (orgDataSet != null && !orgDataSet.isEmpty()) {
            for (Row row : orgDataSet) {
                orgIds.add(row.getLong("fid"));
            }
        }
        if ((cs087Map = CheckItemStatusUpService.getSystemParamsByOrgIds(orgIds, CS087)).containsValue(true)) {
            this.updateCheckItemEfective("1.3-RecBillInTransitCheck");
        }
        if ((cs092Map = CheckItemStatusUpService.getSystemParamsByOrgIds(orgIds, CS092)).containsValue(true)) {
            this.updateCheckItemEfective("1.1-PaymentBillInTransitCheck");
        }
        if ((cs091Map = CheckItemStatusUpService.getSystemParamsByOrgIds(orgIds, CS091)).containsValue(true)) {
            this.updateCheckItemEfective("4.2-CheckWithGLChecker");
        }
        if ((cs093Map = CheckItemStatusUpService.getSystemParamsByOrgIds(orgIds, CS093)).containsValue(true)) {
            this.updateCheckItemEfective("4.1-CheckWithFinishInitChecker");
        }
        result.setResult("upgrade success");
        result.setEndDate(new Date());
        return result;
    }

    public static Map<Long, Boolean> getSystemParamsByOrgIds(List<Long> orgIds, String key) {
        long start = System.currentTimeMillis();
        String sql = "select a.fdata parm,a.forgid org from T_bas_sysparameter a left join t_bas_sysparaconsole b on a.fparamid = b.fid where a.fviewtypeid = '08' and b.fappid = 'd2bb1733000000ac'";
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(16);
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.fcm.upgradeservice.CheckItemStatusUpgradeService", (DBRoute)DBRoute.of((String)"sys"), (String)sql);){
            for (Row row : queryDataSet) {
                String data = row.getString("parm");
                Long orgId = row.getLong("org");
                if (data == null || !orgIds.contains(orgId)) continue;
                Map fromJsonString = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                Object value = fromJsonString.get(key);
                boolean rr = value != null && (Boolean)value != false;
                result.put(orgId, rr);
            }
        }
        long end = System.currentTimeMillis();
        logger.info("---\u8bb0\u5f55\u672c\u6b21\u83b7\u53d6\u5168\u90e8\u53c2\u6570\u7684\u65f6\u95f4\uff0c\u7ec4\u7ec7\u6570\u91cf\uff1a" + orgIds.size() + ";\u65f6\u95f4:" + (end - start));
        return result;
    }

    private void updateCheckItemEfective(String checkItemNumber) {
        String sql = "select fid from t_fcm_checkitem where fenable = '1' and fbizappid = 'd2bb1733000000ac' and fnumber = ?";
        DataSet checkItemDs = DB.queryDataSet((String)"queryCheckItems", (DBRoute)new DBRoute("fi"), (String)sql, (Object[])new Object[]{checkItemNumber});
        ArrayList<Object[]> queryStatusParam = new ArrayList<Object[]>(10);
        if (checkItemDs != null && !checkItemDs.isEmpty()) {
            for (Row row : checkItemDs) {
                queryStatusParam.add(new Object[]{row.getLong("fid")});
            }
        }
        this.executeBatch(queryStatusParam);
    }

    private void executeBatch(List<Object[]> batchParam) {
        String sql = "UPDATE t_fcm_checkitemstatus SET fiseffective = '1' where  fcheckitemid = ? ";
        DB.executeBatch((DBRoute)new DBRoute("fi"), (String)sql, batchParam);
    }
}

