/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.init;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.init.ITmcSyncData;
import kd.tmc.fbp.common.init.SyncDataResult;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditTypeUpdateService
implements ITmcSyncData {
    public SyncDataResult syncData() {
        SyncDataResult result = new SyncDataResult();
        result.setBeginDate(new Date());
        int idCount = this.updateCreditType();
        result.setSuccessCount(idCount);
        return result;
    }

    private int updateCreditType() {
        Object[] creditTypes = TmcDataServiceHelper.load((String)"cfm_credittype", (String)"id,entryentity.basetype,entryentity.basedata", (QFilter[])new QFilter[]{QFilter.isNotNull((String)"creditvarietyold")});
        if (EmptyUtil.isEmpty((Object[])creditTypes)) {
            return 0;
        }
        Set<Object> creditTypeIds = Arrays.stream(creditTypes).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        Map<Long, List<DynamicObject>> cmdBillTypes = this.getCreditUse(creditTypeIds, "cdm_billtype");
        Map<Long, List<DynamicObject>> cfmFinas = this.getCreditUse(creditTypeIds, "cfm_financingvarieties");
        for (Object creditType : creditTypes) {
            long typeId = creditType.getLong("id");
            List<DynamicObject> creditCdmuse = cmdBillTypes.get(typeId);
            List<DynamicObject> creditCfmuse = cfmFinas.get(typeId);
            this.setEntrys(creditCdmuse, (DynamicObject)creditType);
            this.setEntrys(creditCfmuse, (DynamicObject)creditType);
        }
        TmcDataServiceHelper.save((DynamicObject[])creditTypes);
        return creditTypeIds.size();
    }

    private void setEntrys(List<DynamicObject> creditCdmuse, DynamicObject creditType) {
        if (EmptyUtil.isEmpty(creditCdmuse)) {
            return;
        }
        DynamicObjectCollection entryentitys = creditType.getDynamicObjectCollection("entryentity");
        entryentitys.clear();
        for (DynamicObject credit : creditCdmuse) {
            DynamicObject entry = entryentitys.addNew();
            entry.set("basetype", (Object)credit.getDataEntityType().getName());
            entry.set("basedata", credit.getPkValue());
        }
    }

    private Map<Long, List<DynamicObject>> getCreditUse(Set<Object> creditTypeIds, String formId) {
        HashMap<Long, List<DynamicObject>> map = new HashMap<Long, List<DynamicObject>>(creditTypeIds.size());
        Object[] billTypes = TmcDataServiceHelper.load((String)formId, (String)"id,name,credittype", (QFilter[])new QFilter[]{new QFilter("credittype", "in", creditTypeIds)});
        if (EmptyUtil.isNoEmpty((Object[])billTypes)) {
            for (Object billType : billTypes) {
                long creditTypeId = billType.getDynamicObject("credittype").getLong("id");
                List types = map.getOrDefault(creditTypeId, new ArrayList());
                types.add(billType);
                map.put(creditTypeId, types);
            }
        }
        return map;
    }
}

