/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.init;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.init.ITmcSyncData;
import kd.tmc.fbp.common.init.SyncDataResult;

public class DeductionUpdateService
implements ITmcSyncData {
    public SyncDataResult syncData() throws KDException {
        SyncDataResult result = new SyncDataResult();
        result.setBeginDate(new Date());
        DynamicObject[] bills = TmcDataServiceHelper.load((String)"ifm_deduction", (String)"id,payee,payeeaccountbank,payeename,payeebanknum", (QFilter[])new QFilter[]{new QFilter("deductiontype", "=", (Object)"A")});
        Set payeeIds = Arrays.stream(bills).map(o -> o.getLong("payee")).collect(Collectors.toSet());
        Set accountBankIds = Arrays.stream(bills).map(o -> o.getLong("payeeaccountbank")).collect(Collectors.toSet());
        Map orgMap = TmcDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", payeeIds)});
        Map accountBankMap = TmcDataServiceHelper.loadFromCache((String)"bd_accountbanks", (String)"id,bankaccountnumber", (QFilter[])new QFilter[]{new QFilter("id", "in", accountBankIds)});
        ArrayList<DynamicObject> saveBills = new ArrayList<DynamicObject>(200);
        for (DynamicObject bill : bills) {
            long payeeId = bill.getLong("payee");
            long accountId = bill.getLong("payeeaccountbank");
            DynamicObject org = (DynamicObject)orgMap.get(payeeId);
            DynamicObject accountBank = (DynamicObject)accountBankMap.get(accountId);
            bill.set("payeename", (Object)(org != null ? org.getString("name") : ""));
            bill.set("payeebanknum", (Object)(accountBank != null ? accountBank.getString("bankaccountnumber") : ""));
            saveBills.add(bill);
            if (saveBills.size() != 200) continue;
            SaveServiceHelper.save((DynamicObject[])saveBills.toArray(new DynamicObject[0]));
            saveBills.clear();
        }
        if (saveBills.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])saveBills.toArray(new DynamicObject[0]));
        }
        result.setSuccessCount(bills.length);
        result.setResult("upgrade success");
        result.setEndDate(new Date());
        return result;
    }
}

