/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.init;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.init.ITmcSyncData;
import kd.tmc.fbp.common.init.SyncDataResult;

public class DepositUpdateService
implements ITmcSyncData {
    private static Log logger = LogFactory.getLog(DepositUpdateService.class);

    public SyncDataResult syncData() {
        SyncDataResult result = new SyncDataResult();
        result.setBeginDate(new Date());
        List<String> entityList = Arrays.asList("cim_deposit", "cim_noticedeposit");
        QFilter qFilter = new QFilter("sourcebilltype", "in", entityList);
        DynamicObjectCollection payBillCols = QueryServiceHelper.query((String)"cas_paybill", (String)"id,sourcebillid", (QFilter[])qFilter.toArray());
        Map<Long, Long> payResult = payBillCols.stream().collect(Collectors.toMap(r -> r.getLong("id"), r -> r.getLong("sourcebillid")));
        if (Objects.isNull(payResult) || payResult.isEmpty()) {
            result.setResult(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u66f4\u65b0\u7684\u6570\u636e\u3002", (String)"FinSubscribeUpdateService_1", (String)"tmc-fbp-business", (Object[])new Object[0]));
            return result;
        }
        logger.info("\u4ed8\u6b3e\u5904\u7406\u5355\u4e2d\u67e5\u8be2\u4e0a\u6e38\u5355\u4e3a\u5b58\u6b3e\u5355\u7684\u6570\u636e\uff1a{}\u884c", (Object)payResult.size());
        String updateSql = "update t_cim_deposit_e set fpaybillid=? where fid=?";
        ArrayList<Object[]> list = new ArrayList<Object[]>(payResult.size());
        for (Map.Entry<Long, Long> entry : payResult.entrySet()) {
            Object[] param = new Object[]{entry.getKey(), entry.getValue()};
            list.add(param);
        }
        int[] batchResult = DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)updateSql, list);
        result.setEndDate(new Date());
        long successNum = Arrays.stream(batchResult).filter(r -> r == 1).count();
        int sucNum = Integer.parseInt(successNum + "");
        result.setSuccessCount(sucNum);
        result.setFailCount(batchResult.length - sucNum);
        result.setResult(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"FinSubscribeUpdateService_3", (String)"tmc-fbp-business", (Object[])new Object[0]));
        return result;
    }
}

