/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.init;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.init.ITmcSyncData;
import kd.tmc.fbp.common.init.SyncDataResult;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class HistoryDepositCreateRevenueService
implements ITmcSyncData {
    public SyncDataResult syncData() {
        SyncDataResult result = new SyncDataResult();
        result.setBeginDate(new Date());
        result.setResult("");
        this.dealReleaseBillPart(result);
        this.dealRedepositBillPart(result);
        result.setEndDate(new Date());
        return result;
    }

    private void dealRedepositBillPart(SyncDataResult result) {
        StringBuilder sb = new StringBuilder(result.getResult());
        QFilter qFilter = new QFilter("isredepositgenerate", "=", (Object)Boolean.TRUE);
        qFilter.and("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue());
        qFilter.and(new QFilter("investvarieties", ">", (Object)0L));
        qFilter.and(new QFilter("finorginfo", ">", (Object)0L));
        DynamicObjectCollection oriDepositCols = QueryServiceHelper.query((String)"cim_deposit", (String)"billno,srcdepositno,investvarieties.investtype investtype,intdate,expireredeposit,srcinterest,billstatus,finorginfo", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)oriDepositCols)) {
            sb.append(ResManager.loadKDString((String)"\u7eed\u5b58\u5355\u90e8\u5206\u5386\u53f2\u6570\u636e\u65e0\u9700\u5347\u7ea7\u3002", (String)"HistoryDepositCreateRevenueService_1", (String)"tmc-fbp-business", (Object[])new Object[0]));
            result.setResult(sb.toString());
            return;
        }
        List srcDepositNos = oriDepositCols.stream().map(r -> r.getString("srcdepositno")).collect(Collectors.toList());
        QFilter revenueFilter = new QFilter("loanbillno", "in", srcDepositNos);
        revenueFilter.and(new QFilter("revenuesort", "=", (Object)"redeposit_revenue"));
        DynamicObjectCollection dptRevenueCols = QueryServiceHelper.query((String)"cim_dptrevenue", (String)"loanbillno", (QFilter[])new QFilter[]{revenueFilter});
        List revenuedList = dptRevenueCols.stream().map(r -> r.getString("loanbillno")).collect(Collectors.toList());
        List filterdDeposits = oriDepositCols.stream().filter(r -> !revenuedList.contains(r.getString("srcdepositno"))).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(filterdDeposits)) {
            sb.append(ResManager.loadKDString((String)"\u7eed\u5b58\u5355\u90e8\u5206\u5386\u53f2\u6570\u636e\u5df2\u5168\u90e8\u5347\u7ea7\u3002", (String)"HistoryDepositCreateRevenueService_2", (String)"tmc-fbp-business", (Object[])new Object[0]));
            result.setResult(sb.toString());
            return;
        }
        int i = 0;
        for (DynamicObject redeposit : filterdDeposits) {
            List srcDepositIds = QueryServiceHelper.queryPrimaryKeys((String)"cim_deposit", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)redeposit.getString("srcdepositno"))}, (String)"", (int)-1);
            if (EmptyUtil.isEmpty((Collection)srcDepositIds)) continue;
            OperateOption option = OperateOption.create();
            option.setVariableValue("const_operate_var", "fromRedeposit");
            option.setVariableValue("bizdate", DateUtils.formatString((Date)redeposit.getDate("intdate"), (String)"yyyy-MM-dd"));
            option.setVariableValue("expireredeposit", redeposit.getString("expireredeposit"));
            option.setVariableValue("actpreinstamt", redeposit.getBigDecimal("srcinterest").toString());
            option.setVariableValue("ishistorybuild", "1");
            String upstreamEntity = this.getUpstreamEntity(redeposit);
            if (EmptyUtil.isEmpty((String)upstreamEntity)) {
                sb.append(String.format(ResManager.loadKDString((String)"\u7eed\u5b58\u5355\u90e8\u5206\u7eed\u5b58\u5355\u53f7[%s]\u751f\u6210\u6536\u76ca\u5355\u5931\u8d25,\u7591\u662f\u810f\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"HistoryDepositCreateRevenueService_3", (String)"tmc-fbp-business", (Object[])new Object[0]), redeposit.getString("billno")));
                continue;
            }
            try {
                TmcOperateServiceHelper.execOperate((String)"push2revenue", (String)upstreamEntity, (Object[])srcDepositIds.toArray(), (OperateOption)option);
                if ("C".equals(redeposit.getString("billstatus"))) {
                    String revenueEntity = upstreamEntity.startsWith("cim_") ? "cim_dptrevenue" : "ifm_dptrevenue";
                    QFilter filter = new QFilter("loanbillno", "=", (Object)redeposit.getString("srcdepositno"));
                    filter.and(new QFilter("revenuesort", "=", (Object)"redeposit_revenue"));
                    List revenueIds = QueryServiceHelper.queryPrimaryKeys((String)revenueEntity, (QFilter[])new QFilter[]{filter}, (String)"", (int)-1);
                    option = OperateOption.create();
                    option.setVariableValue("const_operate_var", "fromRedeposit");
                    TmcOperateServiceHelper.execOperate((String)"audit", (String)revenueEntity, (Object[])revenueIds.toArray(), (OperateOption)option);
                }
                ++i;
            }
            catch (Exception e) {
                sb.append(String.format(ResManager.loadKDString((String)"\u7eed\u5b58\u5355\u90e8\u5206\u7eed\u5b58\u5355\u53f7[%1$s]\u751f\u6210\u6536\u76ca\u5355\u5931\u8d25:%2$s\u3002", (String)"HistoryDepositCreateRevenueService_4", (String)"tmc-fbp-business", (Object[])new Object[0]), redeposit.getString("billno"), e.getMessage()));
            }
        }
        sb.append(String.format(ResManager.loadKDString((String)"\u7eed\u5b58\u5355\u90e8\u5206\u6210\u529f\u8865\u5145\u751f\u6210\u6536\u76ca\u5355\u5171[%d]\u7b14\u3002", (String)"HistoryDepositCreateRevenueService_5", (String)"tmc-fbp-business", (Object[])new Object[0]), i));
        result.setResult(sb.toString());
    }

    private void dealReleaseBillPart(SyncDataResult result) {
        StringBuilder sb = new StringBuilder(result.getResult());
        QFilter qFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue());
        qFilter.and(new QFilter("isrevenue", "=", (Object)Boolean.TRUE));
        qFilter.and(new QFilter("finbillno", ">", (Object)0L));
        qFilter.and(new QFilter("investvarieties", ">", (Object)0L));
        qFilter.and(new QFilter("finorginfo", ">", (Object)0L));
        qFilter.and(QFilter.of((String)"tradechannel !='' and tradechannel !=' '", (Object[])new Object[0]));
        DynamicObjectCollection oriReleaseCols = QueryServiceHelper.query((String)"cim_release", (String)"id,billno,finbillno,investvarieties.investtype investtype,billstatus,tradechannel,bebankstatus,redeemdate,finorginfo", (QFilter[])new QFilter[]{qFilter}, (String)"finbillno,redeemdate");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)oriReleaseCols)) {
            sb.append(ResManager.loadKDString((String)"\u89e3\u6d3b\u5355\u90e8\u5206\u5386\u53f2\u6570\u636e\u65e0\u9700\u5347\u7ea7\u3002", (String)"HistoryDepositCreateRevenueService_6", (String)"tmc-fbp-business", (Object[])new Object[0]));
            result.setResult(sb.toString());
            return;
        }
        List releaseIds = oriReleaseCols.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
        QFilter revenueFilter = new QFilter("srcreleaseid", "in", releaseIds);
        DynamicObjectCollection revenueCols = QueryServiceHelper.query((String)"cim_dptrevenue", (String)"id,srcreleaseid", (QFilter[])new QFilter[]{revenueFilter});
        List revenuedReleaseIds = revenueCols.stream().map(r -> r.getLong("srcreleaseid")).collect(Collectors.toList());
        List filterdReleaseBills = oriReleaseCols.stream().filter(r -> !revenuedReleaseIds.contains(r)).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(filterdReleaseBills)) {
            sb.append(ResManager.loadKDString((String)"\u89e3\u6d3b\u5355\u90e8\u5206\u5386\u53f2\u6570\u636e\u5df2\u5168\u90e8\u5347\u7ea7\u3002", (String)"HistoryDepositCreateRevenueService_7", (String)"tmc-fbp-business", (Object[])new Object[0]));
            result.setResult(sb.toString());
            return;
        }
        int i = 0;
        for (DynamicObject releaseBill : filterdReleaseBills) {
            long depositId = releaseBill.getLong("finbillno");
            OperateOption option = OperateOption.create();
            option.setVariableValue("const_operate_var", "fromRelease");
            option.setVariableValue("srcreleaseid", String.valueOf(releaseBill.getLong("id")));
            option.setVariableValue("revenuesort", "redeem_revenue");
            option.setVariableValue("bizdate", DateUtils.formatString((Date)releaseBill.getDate("redeemdate"), (String)"yyyy-MM-dd"));
            option.setVariableValue("ishistorybuild", "1");
            String upstreamEntity = this.getUpstreamEntity(releaseBill);
            if (EmptyUtil.isEmpty((String)upstreamEntity)) {
                sb.append(String.format(ResManager.loadKDString((String)"\u89e3\u6d3b\u5355\u90e8\u5206\u5355\u53f7[%s]\u751f\u6210\u6536\u76ca\u5355\u5931\u8d25,\u7591\u662f\u810f\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"HistoryDepositCreateRevenueService_8", (String)"tmc-fbp-business", (Object[])new Object[0]), releaseBill.getString("billno")));
                continue;
            }
            try {
                TmcOperateServiceHelper.execOperate((String)"push2revenue", (String)upstreamEntity, (Object[])new Object[]{depositId}, (OperateOption)option);
                this.bindBotpRelation(releaseBill);
                String billStatus = releaseBill.getString("billstatus");
                String tradeChannel = releaseBill.getString("tradechannel");
                String beBankStatus = releaseBill.getString("bebankstatus");
                if ("offline".equals(tradeChannel) && "C".equals(billStatus) || "online".equals(tradeChannel) && "C".equals(billStatus) && "TS".equals(beBankStatus)) {
                    String revenueEntity = upstreamEntity.startsWith("cim_") ? "cim_dptrevenue" : "ifm_dptrevenue";
                    List revenueIds = QueryServiceHelper.queryPrimaryKeys((String)revenueEntity, (QFilter[])new QFilter[]{new QFilter("srcreleaseid", "=", (Object)releaseBill.getLong("id"))}, (String)"", (int)-1);
                    option = OperateOption.create();
                    option.setVariableValue("fromReleaseAudit", "true");
                    TmcOperateServiceHelper.execOperate((String)"audit", (String)revenueEntity, (Object[])revenueIds.toArray(), (OperateOption)option);
                }
                ++i;
            }
            catch (Exception e) {
                sb.append(String.format(ResManager.loadKDString((String)"\u89e3\u6d3b\u5355\u90e8\u5206\u5355\u53f7[%1$s]\u751f\u6210\u6536\u76ca\u5355\u5931\u8d25\uff1a%2$s\u3002", (String)"HistoryDepositCreateRevenueService_9", (String)"tmc-fbp-business", (Object[])new Object[0]), releaseBill.getString("billno"), e.getMessage()));
            }
        }
        sb.append(String.format(ResManager.loadKDString((String)"\u89e3\u6d3b\u5355\u90e8\u5206\u6210\u529f\u8865\u5145\u751f\u6210\u6536\u76ca\u5355\u5171[%d]\u7b14\u3002", (String)"HistoryDepositCreateRevenueService_10", (String)"tmc-fbp-business", (Object[])new Object[0]), i));
        result.setResult(sb.toString());
    }

    private String getUpstreamEntity(DynamicObject releaseBill) {
        String investType;
        String upstreamEntity = "";
        DynamicObject finOrgInfo = TmcDataServiceHelper.loadSingleFromCache((Object)releaseBill.getLong("finorginfo"), (String)"bd_finorginfo");
        if (EmptyUtil.isEmpty((DynamicObject)finOrgInfo)) {
            return upstreamEntity;
        }
        DynamicObject finorgType = finOrgInfo.getDynamicObject("finorgtype");
        if (EmptyUtil.isEmpty((DynamicObject)finorgType)) {
            return upstreamEntity;
        }
        boolean isSettleCenter = FinOrgTypeEnum.CLEARINGHOUSE.getValue().equals(finorgType.getString("type"));
        upstreamEntity = isSettleCenter ? (InvestTypeEnum.isNotice((String)(investType = releaseBill.getString("investtype"))) ? "ifm_notice_deposit" : "ifm_deposit") : (InvestTypeEnum.isNotice((String)(investType = releaseBill.getString("investtype"))) ? "cim_noticedeposit" : "cim_deposit");
        return upstreamEntity;
    }

    private String getReleaseUpstreamEntity(DynamicObject releaseBill) {
        String investType;
        String upstreamEntity = "";
        DynamicObject finOrgInfo = TmcDataServiceHelper.loadSingleFromCache((Object)releaseBill.getLong("finorginfo"), (String)"bd_finorginfo");
        if (EmptyUtil.isEmpty((DynamicObject)finOrgInfo)) {
            return upstreamEntity;
        }
        DynamicObject finorgType = finOrgInfo.getDynamicObject("finorgtype");
        if (EmptyUtil.isEmpty((DynamicObject)finorgType)) {
            return upstreamEntity;
        }
        boolean isSettleCenter = FinOrgTypeEnum.CLEARINGHOUSE.getValue().equals(finorgType.getString("type"));
        upstreamEntity = isSettleCenter ? (InvestTypeEnum.isNotice((String)(investType = releaseBill.getString("investtype"))) ? "ifm_notice_release" : "ifm_release") : (InvestTypeEnum.isNotice((String)(investType = releaseBill.getString("investtype"))) ? "cim_noticerelease" : "cim_release");
        return upstreamEntity;
    }

    private void bindBotpRelation(DynamicObject release) {
        long releaseId = release.getLong("id");
        QFilter qFilter = new QFilter("srcreleaseid", "=", (Object)releaseId);
        qFilter.and(new QFilter("revenuesort", "=", (Object)"redeem_revenue"));
        List revenueIds = QueryServiceHelper.queryPrimaryKeys((String)"cim_dptrevenue", (QFilter[])new QFilter[]{qFilter}, (String)"", (int)-1);
        if (EmptyUtil.isEmpty((Collection)revenueIds)) {
            return;
        }
        String upstreamEntity = this.getReleaseUpstreamEntity(release);
        if (EmptyUtil.isEmpty((String)upstreamEntity)) {
            return;
        }
        String revenueEntity = upstreamEntity.startsWith("cim_") ? "cim_dptrevenue" : "ifm_dptrevenue";
        TmcBotpHelper.saveRelation((String)upstreamEntity, (Long)releaseId, (String)revenueEntity, (Long)((Long)revenueIds.get(0)));
    }

    private List<Object> getClearHouseIds() {
        QFilter qFilter = new QFilter("finorgtype.type", "=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
        return QueryServiceHelper.queryPrimaryKeys((String)"bd_finorginfo", (QFilter[])new QFilter[]{qFilter}, (String)"", (int)-1);
    }
}

