/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.init;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.init.ITmcSyncData;
import kd.tmc.fbp.common.init.SyncDataResult;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class IfmLocalAmtUpdateService
implements ITmcSyncData {
    private static final Log logger = LogFactory.getLog(IfmLocalAmtUpdateService.class);
    private static Map<String, Pair<String, BigDecimal>> rateMap = new HashMap<String, Pair<String, BigDecimal>>();

    public SyncDataResult syncData() {
        SyncDataResult result = new SyncDataResult();
        result.setBeginDate(new Date());
        int payAccSum = this.updatePayacceptanceBills();
        int transSum = this.updateTranshandleBills();
        int deductionSum = this.updateDeductionBills();
        int recSum = this.updateRectransBills();
        result.setSuccessCount(payAccSum + transSum + deductionSum + recSum);
        result.setEndDate(new Date());
        result.setResult(String.format(ResManager.loadKDString((String)"\u5185\u90e8\u7ed3\u7b97\u53d7\u7406\u3010%1$s\u3011\u5355,\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u3010%2$s\u3011\u5355,\u7ed3\u7b97\u4e2d\u5fc3\u6263\u6b3e\u3010%3$s\u3011\u5355,\u7ed3\u7b97\u4e2d\u5fc3\u6536\u6b3e\u3010%4$s\u3011\u5355", (String)"IfmLocalAmtUpdateService_0", (String)"tmc-fbp-business", (Object[])new Object[0]), payAccSum, transSum, deductionSum, recSum));
        return result;
    }

    private int updatePayacceptanceBills() {
        int payAccCount = 0;
        Map<Long, Pair<Long, Long>> orgInits = this.getOrgInits("ifm_payacceptancebill");
        for (Map.Entry<Long, Pair<Long, Long>> init : orgInits.entrySet()) {
            this.updateAllRate("t_ifm_payacceptance", "FActPayAmount", init.getKey(), init.getValue());
            int count = this.updateDiffCurrency("ifm_payacceptancebill", "currency", "actpayamt", init.getKey(), init.getValue());
            payAccCount += count;
        }
        return payAccCount;
    }

    private int updateTranshandleBills() {
        int transHandelCount = 0;
        Map<Long, Pair<Long, Long>> orgInits = this.getOrgInits("ifm_transhandlebill");
        for (Map.Entry<Long, Pair<Long, Long>> init : orgInits.entrySet()) {
            this.updateAllRate("t_ifm_transhandle", "factpayamount", init.getKey(), init.getValue());
            int count = this.updateDiffCurrency("ifm_transhandlebill", "currency", "actpayamt", init.getKey(), init.getValue());
            transHandelCount += count;
        }
        return transHandelCount;
    }

    private int updateDeductionBills() {
        int deductionCount = 0;
        this.insertEdatas("t_ifm_deduction");
        Map<Long, Pair<Long, Long>> orgInits = this.getOrgInits("ifm_deduction");
        for (Map.Entry<Long, Pair<Long, Long>> init : orgInits.entrySet()) {
            this.updateAllRate("t_ifm_deduction", "freceiveamount", init.getKey(), init.getValue());
            int count = this.updateDiffCurrency("ifm_deduction", "receivecurrency", "receiveamount", init.getKey(), init.getValue());
            deductionCount += count;
        }
        return deductionCount;
    }

    private int updateRectransBills() {
        int recCount = 0;
        this.insertEdatas("t_ifm_rectransbill");
        Map<Long, Pair<Long, Long>> orgInits = this.getOrgInits("ifm_rectransbill");
        for (Map.Entry<Long, Pair<Long, Long>> init : orgInits.entrySet()) {
            this.updateAllRate("t_ifm_rectransbill", "factrecamt", init.getKey(), init.getValue());
            int count = this.updateDiffCurrency("ifm_rectransbill", "currency", "actrecamt", init.getKey(), init.getValue());
            recCount += count;
        }
        return recCount;
    }

    private Map<Long, Pair<Long, Long>> getOrgInits(String entityName) {
        HashMap<Long, Pair<Long, Long>> initsMap = new HashMap<Long, Pair<Long, Long>>();
        QFilter filters = new QFilter("localamt", "=", (Object)0).or(QFilter.isNull((String)"localamt"));
        DataSet scorgDs = QueryServiceHelper.queryDataSet((String)"getOrgInits", (String)entityName, (String)"scorg", (QFilter[])new QFilter[]{filters}, null).groupBy(new String[]{"scorg"}).finish();
        HashSet scorgIds = new HashSet();
        scorgDs.forEach(o -> scorgIds.add(o.getLong("scorg")));
        QFilter initFilter = new QFilter("org", "in", scorgIds);
        Map initMap = BusinessDataServiceHelper.loadFromCache((String)"cas_cashmgtinit", (String)"org,standardcurrency,exratetable", (QFilter[])new QFilter[]{initFilter});
        initMap.values().parallelStream().filter(v -> !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{v.getLong("standardcurrency.id"), v.getLong("exratetable.id")})).forEach(o -> initsMap.put(o.getLong("org.id"), Pair.of((Object)o.getLong("standardcurrency.id"), (Object)o.getLong("exratetable.id"))));
        return initsMap;
    }

    private void updateAllRate(String table, String amtProp, Long orgId, Pair<Long, Long> curExtable) {
        StringBuilder strSql = new StringBuilder("update ");
        strSql.append(table).append("_e ").append(" t set fbasecurrencyid=").append(curExtable.getLeft()).append(", fexratetableid=").append(curExtable.getRight()).append(",fquotation='1'").append(",fexrate=1").append(",flocalamt=(select ").append(amtProp).append(" from ").append(table).append(" t1 where t1.fid=t.fid)").append(" where fid in (select fid from ").append(table).append(" where fscorgid =").append(orgId).append(")").append(" and (flocalamt=0 or flocalamt is null)");
        DB.update((DBRoute)DBRouteConst.TMC, (String)strSql.toString());
    }

    private int updateDiffCurrency(String entityName, String currProp, String amtProp, Long orgId, Pair<Long, Long> curExtable) {
        ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>();
        String fields = amtProp + "," + currProp + ",bizdate,basecurrency,exratetable,quotation,exrate,localamt,billno";
        DynamicObject[] bills = TmcDataServiceHelper.load((String)entityName, (String)fields, (QFilter[])new QFilter[]{new QFilter("scorg", "=", (Object)orgId), new QFilter(currProp, "!=", curExtable.getLeft()), new QFilter("exrate", "=", (Object)1), new QFilter(currProp, "!=", (Object)0), QFilter.isNotNull((String)"bizdate")});
        int sums = 0;
        for (DynamicObject bill : bills) {
            DynamicObject currency = bill.getDynamicObject(currProp);
            Date bizdate = bill.getDate("bizdate");
            if (EmptyUtil.isEmpty((DynamicObject)currency) || EmptyUtil.isEmpty((Object)bizdate)) {
                logger.warn("currency/bizdate is null, billno={}", (Object)bill.getString("billno"));
                continue;
            }
            String key = String.valueOf(orgId) + currency.getPkValue() + DateUtils.formatString((Date)bizdate, (String)"yyyyMMdd");
            Pair ratePair = rateMap.get(key);
            if (ratePair == null) {
                Map exchangeRateMap = BaseDataServiceHelper.getExchangeRateMap((Long)currency.getLong("id"), (Long)((Long)curExtable.getLeft()), (Long)((Long)curExtable.getRight()), (Date)bizdate);
                if (exchangeRateMap == null) {
                    logger.warn("exchangeRateMap is null, billno={}", (Object)bill.getString("billno"));
                    continue;
                }
                BigDecimal rate = (BigDecimal)exchangeRateMap.get("exchangeRate");
                if (EmptyUtil.isEmpty((BigDecimal)rate)) {
                    logger.warn("rate is null, billno={}", (Object)bill.getString("billno"));
                    continue;
                }
                boolean quoteType = (Boolean)exchangeRateMap.get("quoteType");
                ratePair = Pair.of((Object)(quoteType ? "1" : "0"), (Object)rate);
                rateMap.put(key, (Pair<String, BigDecimal>)ratePair);
            }
            bill.set("basecurrency", curExtable.getLeft());
            bill.set("exratetable", curExtable.getRight());
            bill.set("quotation", ratePair.getLeft());
            bill.set("exrate", ratePair.getRight());
            BigDecimal amt = bill.getBigDecimal(amtProp);
            if (EmptyUtil.isEmpty((BigDecimal)amt)) {
                bill.set("localamt", (Object)BigDecimal.ZERO);
            } else {
                DynamicObject baseCurrency = TmcDataServiceHelper.loadSingleFromCache((Object)curExtable.getLeft(), (String)"bd_currency", (String)"id,amtprecision");
                bill.set("localamt", (Object)this.getLocalAmt((String)ratePair.getLeft(), (BigDecimal)ratePair.getRight(), amt, baseCurrency.getInt("amtprecision")));
            }
            objs.add(bill);
            if (objs.size() != 1000) continue;
            SaveServiceHelper.update((DynamicObject[])objs.toArray(new DynamicObject[0]));
            sums += objs.size();
            objs.clear();
        }
        if (objs.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])objs.toArray(new DynamicObject[0]));
            sums += objs.size();
        }
        return sums;
    }

    private BigDecimal getLocalAmt(String quotaTion, BigDecimal rate, BigDecimal amt, int round) {
        BigDecimal localAmt = amt;
        localAmt = "1".equals(quotaTion) ? amt.divide(rate, round, RoundingMode.HALF_UP) : amt.multiply(rate).setScale(round, RoundingMode.HALF_UP);
        if (localAmt.compareTo(Constants.MAX_AMOUNT) > 0) {
            return amt;
        }
        return localAmt;
    }

    private void insertEdatas(String tableName) {
        StringBuilder upSql = new StringBuilder("insert into ");
        upSql.append(tableName).append("_e(fid) values (?);");
        StringBuilder eSql = new StringBuilder("select fid from ");
        eSql.append(tableName).append(" t where not exists (select fid from ").append(tableName).append("_e e where e.fid=t.fid);");
        ResultSetHandler<Set<Long>> action = new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws Exception {
                HashSet<Long> set = new HashSet<Long>(10);
                while (rs.next()) {
                    set.add(rs.getLong(1));
                }
                return set;
            }
        };
        Set ids = (Set)DB.query((DBRoute)DBRouteConst.TMC, (String)eSql.toString(), null, (ResultSetHandler)action);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
        for (Long id : ids) {
            paramList.add(new Object[]{id});
            if (paramList.size() != 1000) continue;
            DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)upSql.toString(), paramList);
            paramList.clear();
        }
        if (paramList.size() > 0) {
            DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)upSql.toString(), paramList);
        }
    }
}

