/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.init;

import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDigestHelper;
import kd.tmc.fbp.common.init.ITmcSyncData;
import kd.tmc.fbp.common.init.SyncDataResult;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InnerAcctBalanceUpdateService
implements ITmcSyncData {
    private static final Log logger = LogFactory.getLog(InnerAcctBalanceUpdateService.class);

    public SyncDataResult syncData() {
        SyncDataResult result = new SyncDataResult();
        result.setBeginDate(new Date());
        int idCount = this.updateBalance();
        this.initAcceptDate();
        result.setSuccessCount(idCount);
        return result;
    }

    private int updateBalance() {
        DynamicObject[] balances;
        QFilter filter = new QFilter("accountbank.finorgtype", "=", (Object)"1");
        filter.and(QFilter.isNull((String)"keycol").or(new QFilter("keycol", "=", (Object)" ")));
        for (DynamicObject balance : balances = TmcDataServiceHelper.load((String)"ifm_accountbalance", (String)"id,company.id,accountbank.id,currency.id,bizdate,keycol", (QFilter[])filter.toArray())) {
            Long companyId = balance.getLong("company.id");
            Long accountBankId = balance.getLong("accountbank.id");
            Long currencyId = balance.getLong("currency.id");
            Date bizDate = balance.getDate("bizdate");
            String keycol = this.genKeyCol(companyId, accountBankId, currencyId, bizDate);
            balance.set("keycol", (Object)keycol);
        }
        Object[] obj = SaveServiceHelper.save((DynamicObject[])balances);
        return obj.length;
    }

    private String genKeyCol(Long companyId, Long innerAcctId, Long currencyId, Date bizDate) {
        StringBuilder builder = new StringBuilder();
        builder.append("accountbank:").append(innerAcctId).append(",");
        builder.append("bizdate:").append(bizDate).append(",");
        builder.append("company:").append(companyId).append(",");
        builder.append("currency:").append(currencyId).append(",");
        return TmcDigestHelper.getSHA256Base64Str((String)builder.toString());
    }

    private void initAcceptDate() {
        Object[] settleCenters = TmcDataServiceHelper.load((String)"ifm_settcentersetting", (String)"settlecenter.id,acceptdate", (QFilter[])new QFilter[]{QFilter.isNull((String)"acceptdate")});
        logger.info("---\u5f00\u59cb\u521d\u59cb\u5316\u7ed3\u7b97\u4e2d\u5fc3\u8bbe\u7f6e\u5355\u636e\u4e2d\u7684\u53d7\u7406\u65e5\u671f---");
        logger.info("---\u627e\u5230\u5f85\u5904\u7406\u6570\u636e{}\u6761---", (Object)settleCenters.length);
        if (EmptyUtil.isNoEmpty((Object[])settleCenters)) {
            Object[] finOrgIds = (Long[])Arrays.stream(settleCenters).map(d -> d.getDynamicObject("settlecenter").getLong("id")).toArray(Long[]::new);
            Map finOrgMap = TmcDataServiceHelper.loadFromCache((Object[])finOrgIds, (String)"bd_finorginfo");
            for (Object sc : settleCenters) {
                Long finOrgId = sc.getDynamicObject("settlecenter").getLong("id");
                Date enableTime = ((DynamicObject)finOrgMap.get(finOrgId)).getDate("enable_time");
                sc.set("acceptdate", (Object)DateUtils.truncateDate((Date)enableTime));
            }
            Object[] result = SaveServiceHelper.save((DynamicObject[])settleCenters);
            logger.info("---\u53d7\u7406\u65e5\u671f\u521d\u59cb\u5316\u5b8c\u6210{}\u6761---", (Object)result.length);
        }
        logger.info("---\u53d7\u7406\u65e5\u671f\u521d\u59cb\u5316\u7ed3\u675f---");
    }
}

