/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.init;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.init.ITmcSyncData;
import kd.tmc.fbp.common.init.SyncDataResult;

public class LetterCreditDataUpgradeService
implements ITmcSyncData {
    private static final Log logger = LogFactory.getLog(LetterCreditDataUpgradeService.class);

    public SyncDataResult syncData() {
        SyncDataResult result = new SyncDataResult();
        result.setBeginDate(new Date());
        logger.info("start upgrade lettercredit closecarddate and repealdate");
        try {
            this.dataUpgrade();
            result.setSuccessCount(1);
        }
        catch (Exception e) {
            result.setResult(e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
        }
        result.setEndDate(new Date());
        logger.info("end upgrade lettercredit closecarddate and repealdate");
        return result;
    }

    private void dataUpgrade() {
        String repealQuerySql;
        DataSet repealData;
        ArrayList<String> upgradeIds = new ArrayList<String>();
        String closeQuerySql = "select lc.fid,lc.fmodifytime from t_lc_lettercredit lc, t_lc_lettercredit_e lce where lc.fid = lce.fid and lc.fbillstatus = 'C' and lc.fcreditstatus = 'done_close' and lc.fmodifytime is not null and lce.fclosecarddate is null";
        DataSet closeCardData = DB.queryDataSet((String)"LetterCreditDataUpgradeService", (DBRoute)DBRouteConst.TMC, (String)closeQuerySql);
        if (!closeCardData.isEmpty()) {
            String updateSql = "update t_lc_lettercredit_e lce set fclosecarddate = ? where lce.fid = ?";
            for (Row closeCardRow : closeCardData.copy()) {
                Object[] params = new Object[]{closeCardRow.getDate("fmodifytime"), closeCardRow.getLong("fid")};
                upgradeIds.add(closeCardRow.getString("fid"));
                DB.execute((DBRoute)DBRouteConst.TMC, (String)updateSql, (Object[])params);
            }
        }
        if (!(repealData = DB.queryDataSet((String)"LetterCreditDataUpgradeService", (DBRoute)DBRouteConst.TMC, (String)(repealQuerySql = "select lc.fid,lc.fmodifytime from t_lc_lettercredit lc, t_lc_lettercredit_e lce where lc.fid = lce.fid and lc.fbillstatus = 'C' and lc.fcreditstatus = 'done_repeal' and lc.fmodifytime is not null and lce.frepealdate is null"))).isEmpty()) {
            String updateSql = "update t_lc_lettercredit_e lce set frepealdate = ? where lce.fid = ?";
            for (Row repealRow : repealData.copy()) {
                Object[] params = new Object[]{repealRow.getDate("fmodifytime"), repealRow.getLong("fid")};
                upgradeIds.add(repealRow.getString("fid"));
                DB.execute((DBRoute)DBRouteConst.TMC, (String)updateSql, (Object[])params);
            }
        }
        logger.info("upgrade upgradeIds:{}", (Object)String.join((CharSequence)",", upgradeIds));
    }
}

