/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.init;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.init.ITmcSyncData;
import kd.tmc.fbp.common.init.SyncDataResult;

public class PermUpdateService
implements ITmcSyncData {
    private static Log logger = LogFactory.getLog(PermUpdateService.class);

    public SyncDataResult syncData() {
        SyncDataResult result = new SyncDataResult();
        result.setBeginDate(new Date());
        Map permItems = this.init();
        permItems.forEach((entity, permList) -> permList.forEach(permitem -> {
            String sSQL = "select fid from t_perm_permitem where fnumber = ? and fbizappid = '03BPAMUHBB22'";
            DataSet ds = DB.queryDataSet((String)"permitem", (DBRoute)DBRouteConst.SYS, (String)sSQL, (Object[])new Object[]{permitem});
            if (ds.hasNext()) {
                Row row = ds.next();
                String newPermItem = row.getString("fid");
                this.updateUserPerm((String)entity, newPermItem);
                this.updateUserRolePerm((String)entity, newPermItem);
                this.updateBizUserRolePerm((String)entity, newPermItem);
            }
        }));
        result.setEndDate(new Date());
        return result;
    }

    private Map init() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("cfm_loanbill", Arrays.asList("QXCFM0001", "QXCFM0002"));
        map.put("cfm_interestbill", Arrays.asList("QXCFM0014", "QXCFM0015", "QXCFM0016"));
        map.put("cfm_repaymentbill", Arrays.asList("QXCFM0020", "QXCFM0021", "QXCFM0022"));
        map.put("cfm_preinterestbill", Arrays.asList("QXCFM0017", "QXCFM0018", "QXCFM0019"));
        map.put("cfm_loancontractbill", Arrays.asList("QXCFM0005", "QXCFM0006"));
        map.put("cfm_contractextendbill", Arrays.asList("QXCFM0007", "QXCFM0008"));
        return map;
    }

    private void updateUserPerm(String entity, String newPermItem) {
        String pSql = "select fid from t_perm_userpermdetail where fpermitemid = ?";
        DataSet pDs = DB.queryDataSet((String)"permitem", (DBRoute)DBRouteConst.SYS, (String)pSql, (Object[])new Object[]{newPermItem});
        ArrayList<String> fids = new ArrayList<String>(16);
        while (pDs.hasNext()) {
            Row row = pDs.next();
            fids.add(row.getString("fid"));
        }
        if (fids.size() == 0) {
            return;
        }
        String sSQL = "select fid,fseq,fcontrolmode,fentitytypeid,fbizappid,fsource,fbizroleid  from t_perm_userpermdetail where fentitytypeid = ? and fpermitemid = '47150e89000000ac'and fbizappid = '03BPAMUHBB22' and fid not in  (" + PermUpdateService.idsToInClause(fids) + ")";
        DataSet ds = DB.queryDataSet((String)"permitem", (DBRoute)DBRouteConst.SYS, (String)sSQL, (Object[])new Object[]{entity});
        while (ds.hasNext()) {
            Row row = ds.next();
            String id = DBServiceHelper.genStringId();
            sSQL = "insert into t_perm_userpermdetail(fentryid,fpermitemid,fid,fseq,fcontrolmode,fentitytypeid,fbizappid,fsource,fbizroleid) values(?, ?, ?, ?, ?, ?, ?, ?, ?)";
            DB.execute((DBRoute)DBRouteConst.SYS, (String)sSQL, (Object[])new Object[]{id, newPermItem, row.get("fid"), row.get("fseq"), row.get("fcontrolmode"), row.get("fentitytypeid"), row.get("fbizappid"), row.get("fsource"), row.get("fbizroleid")});
        }
    }

    private void updateUserRolePerm(String entity, String newPermItem) {
        String sSQL = "select fid,fseq,fcontrolmode,fentitytypeid,fbizappid,finheritmode  from t_perm_rolepermdetial where fentitytypeid = ? and fpermitemid = '47150e89000000ac'and fbizappid = '03BPAMUHBB22' and fid not in (select fid from t_perm_rolepermdetial where fpermitemid = ?)";
        DataSet ds = DB.queryDataSet((String)"permitem", (DBRoute)DBRouteConst.SYS, (String)sSQL, (Object[])new Object[]{entity, newPermItem});
        while (ds.hasNext()) {
            Row row = ds.next();
            String id = DBServiceHelper.genStringId();
            sSQL = "insert into t_perm_rolepermdetial(fentryid,fpermitemid,fid,fseq,fcontrolmode,fentitytypeid,fbizappid,finheritmode) values(?, ?, ?, ?, ?, ?, ?, ?)";
            DB.execute((DBRoute)DBRouteConst.SYS, (String)sSQL, (Object[])new Object[]{id, newPermItem, row.get("fid"), row.get("fseq"), row.get("fcontrolmode"), row.get("fentitytypeid"), row.get("fbizappid"), row.get("finheritmode")});
        }
    }

    private void updateBizUserRolePerm(String entity, String newPermItem) {
        String sSQL = "select fid,fseq,fentitytypeid,fbizappid  from t_perm_bizroledisperm where fentitytypeid = ? and fpermitemid = '47150e89000000ac'and fbizappid = '03BPAMUHBB22' and fid not in (select fid from t_perm_bizroledisperm where fpermitemid = ?)";
        DataSet ds = DB.queryDataSet((String)"permitem", (DBRoute)DBRouteConst.SYS, (String)sSQL, (Object[])new Object[]{entity, newPermItem});
        while (ds.hasNext()) {
            Row row = ds.next();
            Long id = DBServiceHelper.genGlobalLongId();
            sSQL = "insert into t_perm_bizroledisperm(fentryid,fpermitemid,fid,fseq,fentitytypeid,fbizappid) values(?, ?, ?, ?, ?, ?)";
            DB.execute((DBRoute)DBRouteConst.SYS, (String)sSQL, (Object[])new Object[]{id, newPermItem, row.get("fid"), row.get("fseq"), row.get("fentitytypeid"), row.get("fbizappid")});
        }
    }

    public static String idsToInClause(List<String> idList) {
        StringBuilder sb = new StringBuilder();
        if (idList.size() == 0) {
            throw new IllegalArgumentException("intList.size cannot be 0!");
        }
        Iterator<String> it = idList.iterator();
        for (int i = 0; i < idList.size(); ++i) {
            sb.append('\'');
            sb.append(it.next());
            sb.append('\'');
            sb.append(',');
        }
        return sb.toString().substring(0, sb.length() - 1);
    }
}

