/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.init;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.init.ITmcSyncData;
import kd.tmc.fbp.common.init.SyncDataResult;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReceiptUpgradeService
implements ITmcSyncData {
    private static final Log logger = LogFactory.getLog(ReceiptUpgradeService.class);

    public SyncDataResult syncData() {
        SyncDataResult result = new SyncDataResult();
        result.setBeginDate(new Date());
        logger.info("start upgrade receipt type and value");
        try {
            result.setSuccessCount(this.dataUpgrade());
        }
        catch (Exception e) {
            result.setResult(e.getMessage());
            logger.info(e.getMessage());
        }
        result.setEndDate(new Date());
        logger.info("end upgrade receipt type and value");
        return result;
    }

    private int dataUpgrade() {
        String receiptQuerySql = "select flettercreditid,fid from t_lc_receipt_h";
        DataSet receiptData = DB.queryDataSet((String)"ReceiptUpgradeService", (DBRoute)DBRouteConst.TMC, (String)receiptQuerySql);
        if (receiptData.isEmpty()) {
            return 0;
        }
        ArrayList<Long> existIds = new ArrayList<Long>();
        for (Row receiptDatum : receiptData.copy()) {
            existIds.add(receiptDatum.getLong("flettercreditid"));
        }
        logger.info("existIds:{}", (Object)existIds.stream().map(String::valueOf).collect(Collectors.joining()));
        Set<Long> fidEntrySet = this.getEntryMap(existIds);
        ArrayList<String> upgradeIds = new ArrayList<String>();
        for (Row receiptDatum : receiptData.copy()) {
            if (fidEntrySet.contains(receiptDatum.getLong("fid"))) continue;
            upgradeIds.add(receiptDatum.getString("fid"));
            DynamicObject receiptBill = TmcDataServiceHelper.loadSingle((Object)receiptDatum.get("flettercreditid"), (String)"lc_receipt");
            BillChangeHistoryHelper.addChangeHistory((Long)receiptDatum.getLong("flettercreditid"), (String)"lc_receipt", (String)receiptBill.getString("billno"), (String)receiptBill.getString("applyreason"), (String)"SZGZ", (DynamicObject)receiptBill);
        }
        logger.info("upgrade upgradeIds:{}", (Object)String.join((CharSequence)",", upgradeIds));
        return upgradeIds.size();
    }

    private Set<Long> getEntryMap(List<Long> ids) {
        String querySql = "select fid from t_fcs_changehistory where fbizentity = 'lc_receipt' and fbizid in (%s)";
        StringJoiner sj = new StringJoiner(",");
        ids.forEach(v -> sj.add(v.toString()));
        DataSet receiptDataSet = DB.queryDataSet((String)"getEntryMap", (DBRoute)DBRouteConst.TMC, (String)String.format(querySql, sj.toString()));
        HashSet<Long> fidSet = new HashSet<Long>();
        if (EmptyUtil.isEmpty((Object)receiptDataSet)) {
            return fidSet;
        }
        for (Row row : receiptDataSet) {
            Long fid = row.getLong("fid");
            fidSet.add(fid);
        }
        return fidSet;
    }
}

