/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.init;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.init.ITmcSyncData;
import kd.tmc.fbp.common.init.SyncDataResult;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyFinOrgInfoUpdate
implements ITmcSyncData {
    private static final Log logger = LogFactory.getLog(SuretyFinOrgInfoUpdate.class);
    private static final String SURETY_PROP = "id,finorginfo,finorgother,investorgtype";
    private static final String BD_FIORGINFO_PROP = "id,name";

    public SyncDataResult syncData() {
        SyncDataResult result = new SyncDataResult();
        result.setBeginDate(new Date());
        logger.info("\u4fdd\u8bc1\u91d1\u5b58\u5165\u5355\u5b58\u6b3e\u673a\u6784\u6570\u636e\u5347\u7ea7\u5f00\u59cb============");
        QFilter orgTypeFilter = new QFilter("investorgtype", "is null", null).or("investorgtype", "=", (Object)" ").or("finorgother", "is null", null).or("finorgother", "=", (Object)" ");
        DynamicObjectCollection suretys = QueryServiceHelper.query((String)"fbd_suretybill", (String)SURETY_PROP, (QFilter[])new QFilter[]{orgTypeFilter});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)suretys)) {
            result.setResult(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u66f4\u65b0\u7684\u6570\u636e\u3002", (String)"SuretyFinOrgInfoUpdate_1", (String)"tmc-fbp-business", (Object[])new Object[0]));
            return result;
        }
        Set finorginfoIds = suretys.stream().map(entry -> entry.get("finorginfo")).collect(Collectors.toSet());
        QFilter bdQfilter = new QFilter("id", "in", finorginfoIds);
        DynamicObject[] orgInfos = TmcDataServiceHelper.load((String)"bd_finorginfo", (String)BD_FIORGINFO_PROP, (QFilter[])new QFilter[]{bdQfilter});
        Map<Long, DynamicObject> orgInfosById = Arrays.stream(orgInfos).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        if (EmptyUtil.isEmpty(orgInfosById)) {
            result.setResult(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u66f4\u65b0\u7684\u6570\u636e\u3002", (String)"SuretyFinOrgInfoUpdate_1", (String)"tmc-fbp-business", (Object[])new Object[0]));
            return result;
        }
        for (Object surety : suretys) {
            DynamicObject bdOrg = orgInfosById.get(surety.getLong("finorginfo"));
            if (EmptyUtil.isEmpty((DynamicObject)bdOrg)) continue;
            surety.set("investorgtype", (Object)"bd_finorginfo");
            if (!EmptyUtil.isEmpty((Object)surety.get("finorgother"))) continue;
            surety.set("finorgother", (Object)bdOrg.getString("name"));
        }
        ArrayList<Object[]> list = new ArrayList<Object[]>(suretys.size());
        for (DynamicObject dynamicObject : suretys) {
            Object[] param = new Object[]{dynamicObject.getString("investorgtype"), dynamicObject.getString("finorgother"), dynamicObject.getLong("id")};
            list.add(param);
        }
        String updateSql = "update t_fbd_suretybill_F set finvestorgtype = ? ,ffinorgother = ? where fid = ?";
        int[] batchResult = DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)updateSql, list);
        result.setEndDate(new Date());
        long successNum = Arrays.stream(batchResult).filter(r -> r == 1).count();
        int sucNum = Integer.parseInt(successNum + "");
        result.setSuccessCount(sucNum);
        result.setFailCount(batchResult.length - sucNum);
        result.setResult(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"SuretyFinOrgInfoUpdate_2", (String)"tmc-fbp-business", (Object[])new Object[0]));
        logger.info("\u4fdd\u8bc1\u91d1\u5b58\u5165\u5355\u5b58\u6b3e\u673a\u6784\u6570\u636e\u5347\u7ea7\u7ed3\u675f============");
        return result;
    }
}

