/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.init;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.init.ITmcSyncData;
import kd.tmc.fbp.common.init.SyncDataResult;
import org.apache.commons.lang3.tuple.Pair;

public class TransBillRefunBoptUpdateService
implements ITmcSyncData {
    public SyncDataResult syncData() {
        SyncDataResult result = new SyncDataResult();
        result.setBeginDate(new Date());
        result.setSuccessCount(this.updateBotpLink());
        result.setEndDate(new Date());
        return result;
    }

    private int updateBotpLink() {
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"ifm_transhandlebill", (String)"id,recbill", (QFilter[])new QFilter[]{new QFilter("paidstatus", "in", (Object)new String[]{"E", "F"}), QFilter.isNotNull((String)"recbill")});
        Map<Long, Long> tranRecMap = bills.parallelStream().collect(Collectors.toMap(o -> o.getLong("recbill"), o -> o.getLong("id")));
        Map sourceBillRows = BFTrackerServiceHelper.findDirtSourceBills((String)"ifm_transhandlebill", (Long[])tranRecMap.keySet().toArray(new Long[0]));
        Set transBillIds = sourceBillRows.keySet();
        for (Long transBillId : transBillIds) {
            tranRecMap.remove(transBillId);
        }
        ArrayList<Pair> srcTarPairList = new ArrayList<Pair>(tranRecMap.size());
        for (Map.Entry<Long, Long> longLongEntry : tranRecMap.entrySet()) {
            srcTarPairList.add(Pair.of((Object)longLongEntry.getKey(), (Object)longLongEntry.getValue()));
        }
        if (srcTarPairList.size() > 0) {
            TmcBotpHelper.batchSaveRelation((String)"cas_recbill", (String)"ifm_transhandlebill", srcTarPairList);
        }
        return tranRecMap.size();
    }
}

