/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.validate.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class Push2PayBillValidator
extends AbstractTmcBizOppValidator {
    private static final Set<String> EXCLUDE_ENTITYS = new HashSet<String>(Collections.singleton("tm_businessbill"));

    @Override
    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        Map<String, QFilter> filterMap;
        String entityName = dataEntitys[0].getDataEntity().getDynamicObjectType().getName();
        if (EXCLUDE_ENTITYS.contains(entityName)) {
            return;
        }
        Set<String> includeTargetEntitys = Collections.singleton("cas_paybill");
        List billIds = Arrays.stream(dataEntitys).map(d -> d.getDataEntity().getLong("id")).collect(Collectors.toList());
        Map targetBillNoMap = TmcBotpHelper.getTargetBillNoMap((String)entityName, billIds, null, includeTargetEntitys, filterMap = Collections.singletonMap("cas_paybill", new QFilter("billstatus", "not in", Arrays.asList("G", "F"))));
        if (targetBillNoMap.isEmpty()) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            List billNos;
            long billId = dataEntity.getDataEntity().getLong("id");
            Map billNoMap = (Map)targetBillNoMap.get(billId);
            if (!EmptyUtil.isNoEmpty((Object)billNoMap) || !EmptyUtil.isNoEmpty((Object)(billNos = (List)billNoMap.get("cas_paybill")))) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4e0b\u6e38\u4ed8\u6b3e\u5904\u7406\u5355\u636e:%s\u3002", (String)"Push2PayBillValidator_01", (String)"tmc-fbp-business", (Object[])new Object[0]), String.join((CharSequence)",", billNos)));
        }
    }
}

