/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.validate.feedetail;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.FeeSourceEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FeeDetailUnAuditValidator
extends AbstractTmcBizOppValidator {
    @Override
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Set bizBillIds = Arrays.stream(dataEntity).map(s -> s.getDataEntity().getLong("id")).collect(Collectors.toSet());
        QFilter feeFilter = new QFilter("entry.srcbillid", "in", bizBillIds);
        DynamicObjectCollection feeBills = QueryServiceHelper.query((String)"cfm_feebill", (String)"id,billstatus,feesource,billno,entry.srcstatus srcstatus,entry.srcbillid srcbillid", (QFilter[])new QFilter[]{feeFilter});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)feeBills)) {
            Map bizBillGroup = feeBills.stream().collect(Collectors.groupingBy(s -> s.getLong("srcbillid"), Collectors.mapping(o -> o.getLong("id"), Collectors.toSet())));
            Map feeBillGroup = feeBills.stream().collect(Collectors.groupingBy(s -> s.getLong("id"), Collectors.mapping(o -> o, Collectors.toList())));
            Set feeTargetIds = BFTrackerServiceHelper.findDirtTargetBills((String)"cfm_feebill", (Long[])feeBillGroup.keySet().toArray(new Long[0])).keySet();
            Set<Long> foundFeeBizBillIds = bizBillGroup.keySet();
            Set errorFeeIds = feeBills.stream().filter(s -> EmptyUtil.isNoEmpty((String)s.getString("feesource"))).filter(s -> !FeeSourceEnum.LINKGEN.getValue().equals(s.getString("feesource"))).filter(s -> EmptyUtil.isEmpty((String)s.getString("srcstatus"))).map(s -> s.getLong("id")).collect(Collectors.toSet());
            for (ExtendedDataEntity extendedDataEntity : dataEntity) {
                String feeBillno;
                HashSet<Object> tempSet;
                DynamicObject info = extendedDataEntity.getDataEntity();
                long bizBillId = info.getLong("id");
                if (!foundFeeBizBillIds.contains(bizBillId)) continue;
                Set feeBillIds = bizBillGroup.get(bizBillId);
                if (EmptyUtil.isNoEmpty(feeTargetIds)) {
                    tempSet = new HashSet(feeTargetIds);
                    tempSet.retainAll(feeBillIds);
                    for (Long l : tempSet) {
                        feeBillno = ((DynamicObject)feeBillGroup.get(l).get(0)).getString("billno");
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8d39\u7528\u5355\u636e[%s]\u5df2\u505a\u540e\u7eed\u4e1a\u52a1\u64cd\u4f5c\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"FeeDetailUnAuditValidator_01", (String)"tmc-fbp-business", (Object[])new Object[]{feeBillno}));
                    }
                }
                if (!EmptyUtil.isNoEmpty(errorFeeIds)) continue;
                tempSet = new HashSet(errorFeeIds);
                tempSet.retainAll(feeBillIds);
                for (Long l : tempSet) {
                    feeBillno = ((DynamicObject)feeBillGroup.get(l).get(0)).getString("billno");
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5df2\u88ab\u8d39\u7528\u5355\u636e[%s]\u5173\u8054\uff0c\u8bf7\u5148\u89e3\u9664\u5173\u8054\u3002", (String)"FeeDetailUnAuditValidator_02", (String)"tmc-fbp-business", (Object[])new Object[]{feeBillno}));
                }
            }
        }
    }
}

