/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.ebservice.http.impl;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.enums.AlgorithmEnum;
import kd.tmc.fbp.service.ebservice.errorcode.BeErrorCode;
import kd.tmc.fbp.service.ebservice.errorcode.EBBizErrorCode;
import kd.tmc.fbp.service.ebservice.errorcode.EBErrorCode;
import kd.tmc.fbp.service.ebservice.exception.BESecurityException;
import kd.tmc.fbp.service.ebservice.exception.EBAuthException;
import kd.tmc.fbp.service.ebservice.exception.EBBizNCException;
import kd.tmc.fbp.service.ebservice.exception.EBConnectException;
import kd.tmc.fbp.service.ebservice.exception.EBSignException;
import kd.tmc.fbp.service.ebservice.http.HttpHelper;
import kd.tmc.fbp.service.ebservice.http.IEBRequestHandler;
import kd.tmc.fbp.service.ebservice.log.BankLogService;
import kd.tmc.fbp.service.ebservice.security.utils.DefaultSignature;
import kd.tmc.fbp.service.ebservice.token.TokenManager;
import kd.tmc.fbp.service.ebservice.utils.JsonUtil;
import kd.tmc.fbp.webapi.ebentity.EBRequest;
import kd.tmc.fbp.webapi.ebentity.api.EBServiceRequest;
import kd.tmc.fbp.webapi.ebentity.api.EBServiceResponse;

public class OldEBRequestHandler
implements IEBRequestHandler {
    private static Log logger = LogFactory.getLog(OldEBRequestHandler.class);
    private static final String SUCCESS = "success";
    private static final String OLD_SERVICE_URL = "/services/business";
    private DefaultSignature signature;
    protected BankLogService log;
    private String customerID;
    private String serverAddress;
    private DynamicObject serviceConfig;

    public OldEBRequestHandler(BankLogService log) {
        this.log = log;
        log.setComment(ResManager.loadKDString((String)"\u94f6\u4f01\u670d\u52a1\u72ec\u7acb\u7cfb\u7edf\u8c03\u7528", (String)"RPCRequestHandler_3", (String)"tmc-fbp-mservice", (Object[])new Object[0]));
        QFilter qFilter = new QFilter("isenable", "=", (Object)Boolean.TRUE);
        Object[] services = TmcDataServiceHelper.load((String)"bei_serviceconfig", (String)"id, customerid, cafile_tag, customerprivatekey, serveraddress, mcup", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isEmpty((Object[])services) || services.length <= 0) {
            throw new EBBizNCException(new BeErrorCode().BE5000());
        }
        this.serviceConfig = services[0];
        this.customerID = this.serviceConfig.getString("customerid");
        this.serverAddress = this.serviceConfig.getString("serveraddress");
    }

    @Override
    public String executeEBRequest(EBRequest request, String serviceUrl, int timeout) {
        try {
            logger.info("------begin execute old EBG request------");
            logger.info("serviceConfig==[customerID=" + this.customerID + ",serverAddress=" + this.serverAddress + "]");
            logger.info("request=============" + SerializationUtils.toJsonString((Object)request));
            try {
                this.signature = new DefaultSignature();
                this.signature.init(this.serviceConfig);
            }
            catch (Exception e) {
                throw new EBSignException(e, new EBErrorCode().COMMON(), e.getMessage());
            }
            String token = TokenManager.getToken();
            String response = this.getEBResponseData(request, OLD_SERVICE_URL, token, timeout);
            logger.info("response=================" + SerializationUtils.toJsonString((Object)response));
            if (response == null) {
                throw new EBBizNCException(new EBBizErrorCode().RESPONSE_ISNULL());
            }
            this.log.setResponse(response);
            logger.info("-------execute old EBG request end and response success------");
            logger.info(SerializationUtils.toJsonString((Object)response));
            return response;
        }
        catch (BESecurityException | EBAuthException | EBConnectException | EBSignException e) {
            this.log.setRequestException((Exception)((Object)e));
            logger.info("-------execute old EBG request error--" + ((Object)((Object)e)).getClass() + "------");
            if (e instanceof EBConnectException) {
                throw new EBConnectException(new EBBizErrorCode().CONNECT(), new Object[]{e.getMessage()});
            }
            if (e instanceof EBSignException) {
                throw new EBSignException(new EBBizErrorCode().SIGN(), new Object[]{e.getMessage()});
            }
            throw e;
        }
        catch (Exception e) {
            logger.info("-------execute old EBG request error-otherException" + e.getClass() + "------");
            this.log.setResponseException(e);
            throw e;
        }
    }

    @Override
    public String getCustomerId() {
        return this.customerID;
    }

    private String getEBResponseData(EBRequest request, String serviceUrl, String token, int timeout) {
        EBServiceRequest serviceRequest = new EBServiceRequest();
        serviceRequest.setBizType(request.getHeader().getBizType());
        serviceRequest.setCustomerID(this.customerID);
        serviceRequest.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        serviceRequest.setToken(token);
        serviceRequest.setSignAlgorithm(AlgorithmEnum.SHA1withRAS.getAlgorithm());
        serviceRequest.setCustomerID(request.getHeader().getCustomId());
        serviceRequest.setData(JsonUtil.toJson(request));
        this.signRequest(serviceRequest);
        String url = this.serverAddress + OLD_SERVICE_URL;
        HttpHelper httpHelper = new HttpHelper();
        logger.info(" url is :" + url + " request is :" + JsonUtil.toJson(serviceRequest));
        String responseStr = httpHelper.post(url, JsonUtil.toJson(serviceRequest), timeout);
        logger.info(" responseStr is :'" + responseStr + "'");
        EBServiceResponse serviceResponse = JsonUtil.json2Obj(responseStr, EBServiceResponse.class);
        if (serviceResponse != null) {
            if (StringUtils.isEmpty((String)serviceResponse.getData()) && !SUCCESS.equals(serviceResponse.getResponseCode())) {
                throw new EBBizNCException(new EBBizErrorCode().RESPONSE(), new Object[]{serviceResponse.getResponseMsg()});
            }
        } else {
            throw new EBBizNCException(new EBBizErrorCode().RESPONSE_ISNULL());
        }
        return serviceResponse.getData();
    }

    private String getPlainText(EBServiceRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append(request.getToken()).append(request.getCustomerID()).append(request.getBizType()).append(request.getTimestamp()).append(request.getEncryptAlgorithm()).append(request.getEncryptKey()).append(request.getData()).append(request.getSignAlgorithm()).append(request.getExtData());
        return sb.toString();
    }

    private void signRequest(EBServiceRequest request) throws BESecurityException {
        try {
            String content = this.getPlainText(request);
            String signData = this.signature.sign(content);
            request.setSignData(signData);
        }
        catch (Exception e) {
            throw new EBSignException(e, new EBErrorCode().SIGN(), e.getMessage());
        }
    }
}

