/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.ebservice.http.impl;

import java.util.Arrays;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.enums.AlgorithmEnum;
import kd.tmc.fbp.service.ebservice.enums.EBExceptionMsgEnum;
import kd.tmc.fbp.service.ebservice.errorcode.BeErrorCode;
import kd.tmc.fbp.service.ebservice.errorcode.EBBizErrorCode;
import kd.tmc.fbp.service.ebservice.errorcode.EBErrorCode;
import kd.tmc.fbp.service.ebservice.exception.BESecurityException;
import kd.tmc.fbp.service.ebservice.exception.EBAuthException;
import kd.tmc.fbp.service.ebservice.exception.EBBizNCException;
import kd.tmc.fbp.service.ebservice.exception.EBConnectException;
import kd.tmc.fbp.service.ebservice.exception.EBSignException;
import kd.tmc.fbp.service.ebservice.http.IEBRequestHandler;
import kd.tmc.fbp.service.ebservice.log.BankLogService;
import kd.tmc.fbp.service.ebservice.security.utils.AESDencryptUtil;
import kd.tmc.fbp.service.ebservice.security.utils.AESEncryptUtil;
import kd.tmc.fbp.service.ebservice.security.utils.SignUtil;
import kd.tmc.fbp.service.ebservice.security.utils.VerifySignUtil;
import kd.tmc.fbp.service.ebservice.utils.CommonUtils;
import kd.tmc.fbp.service.ebservice.utils.JsonUtil;
import kd.tmc.fbp.webapi.ebentity.EBRequest;
import kd.tmc.fbp.webapi.ebentity.api.EBServiceRequest;
import kd.tmc.fbp.webapi.ebentity.api.EBServiceResponse;
import org.apache.commons.lang.RandomStringUtils;

public class RPCRequestHandler
implements IEBRequestHandler {
    private static Log logger = LogFactory.getLog(RPCRequestHandler.class);
    private static final String SUCCESS = "success";
    private static final IAppCache APP_CACHE = AppCache.get((String)"fbp");
    protected BankLogService log;
    private String customerID2;
    static List<String> receiptService = Arrays.asList("receipt", "balanceReconciliate", "balanceReconciliationQuery", "reconciliation");
    static List<String> noteService = Arrays.asList("noteReceivable", "queryNoteDetail", "queryNoteReceivable", "notePayable", "queryNotePayable", "queryNoteInfo");

    public RPCRequestHandler(BankLogService log) {
        this.log = log;
        QFilter qFilter = new QFilter("isenable2", "=", (Object)Boolean.TRUE);
        DynamicObject serviceConfig = TmcDataServiceHelper.loadSingleFromCache((String)"bei_serviceconfig", (String)"id, customerid2, cafile_tag, customerprivatekey, serveraddress2, mcup", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isEmpty((DynamicObject)serviceConfig)) {
            throw new EBBizNCException(new BeErrorCode().BE5000());
        }
        this.customerID2 = RequestContext.get().getTenantId();
    }

    @Override
    public String executeEBRequest(EBRequest request, String serverUrl, int timeout) {
        try {
            logger.info("------begin execute mservice EBG request------");
            String response = this.getEBResponseData(request, null);
            if (response == null) {
                throw new EBBizNCException(new EBBizErrorCode().RESPONSE_ISNULL());
            }
            this.log.setResponse(response);
            logger.info("-------execute mservice EBG request end and response success------");
            return response;
        }
        catch (BESecurityException | EBAuthException | EBConnectException | EBSignException e) {
            this.log.setRequestException((Exception)((Object)e));
            logger.info("-------execute mservice EBG request error--" + ((Object)((Object)e)).getClass() + "------");
            if (e instanceof EBConnectException) {
                throw new EBConnectException(new EBBizErrorCode().CONNECT(), new Object[]{e.getMessage()});
            }
            if (e instanceof EBSignException) {
                throw new EBSignException(new EBBizErrorCode().SIGN(), new Object[]{e.getMessage()});
            }
            throw e;
        }
        catch (Exception e) {
            logger.info("-------execute mservice EBG request error-otherException" + e.getClass() + "------");
            this.log.setResponseException(e);
            throw e;
        }
    }

    @Override
    public String getCustomerId() {
        return this.customerID2;
    }

    private String getEBResponseData(EBRequest request, String signAlgorithm) {
        String ebgAppId;
        String service;
        String requestJson;
        Boolean isFirst = Boolean.TRUE;
        try {
            EBServiceRequest serviceRequest = new EBServiceRequest();
            serviceRequest.setBizType(request.getHeader().getBizType());
            serviceRequest.setCustomerID(this.customerID2);
            serviceRequest.setTimestamp(Long.valueOf(System.currentTimeMillis()));
            if (EmptyUtil.isEmpty((String)signAlgorithm)) {
                signAlgorithm = (String)APP_CACHE.get("beiSignAlgorithm", String.class);
                if (EmptyUtil.isEmpty((String)signAlgorithm)) {
                    signAlgorithm = AlgorithmEnum.SHA256withRSA.getAlgorithm();
                }
            } else {
                isFirst = Boolean.FALSE;
            }
            serviceRequest.setSignAlgorithm(signAlgorithm);
            serviceRequest.setCustomerID(request.getHeader().getCustomId());
            serviceRequest.setData(JsonUtil.toJson(request));
            serviceRequest.setEncryptAlgorithm("AES");
            serviceRequest.setEncryptKey(RPCRequestHandler.getRandomEncryptKey());
            serviceRequest.setVersion("1.0");
            AESEncryptUtil.setEncrypt(serviceRequest);
            AESEncryptUtil.setEncryptSKey(serviceRequest);
            String signData = SignUtil.signRequest(serviceRequest);
            serviceRequest.setSignData(signData);
            requestJson = JsonUtil.toJson(serviceRequest);
            service = this.getService(serviceRequest);
            ebgAppId = this.getEbgAppId(serviceRequest);
        }
        catch (Exception e) {
            throw new EBBizNCException(e, new EBErrorCode().EB_BIZ_EXCEPTION(), e.getMessage());
        }
        try {
            String response = this.invokeRpcService(ebgAppId, service, requestJson);
            ApiResult apiResult = JsonUtil.fromJson(response, ApiResult.class);
            Object dataObj = apiResult.getData();
            if (dataObj == null) {
                throw new EBBizNCException(new EBBizErrorCode().RESPONSE_ISNULL(), new Object[]{apiResult.getMessage()});
            }
            String data = JsonUtil.toJson(dataObj);
            if (StringUtils.isEmpty((String)data)) {
                logger.info("openApi \u8fd4\u56de\u9519\u8bef\u4fe1\u606f:" + response);
                return null;
            }
            EBServiceResponse ebServiceResponse = RPCRequestHandler.parseResponse(data, signAlgorithm);
            if (ebServiceResponse != null) {
                if (!SUCCESS.equals(ebServiceResponse.getResponseCode()) && StringUtils.isEmpty((String)ebServiceResponse.getData())) {
                    throw new EBBizNCException(new EBBizErrorCode().RESPONSE(), new Object[]{ebServiceResponse.getResponseMsg()});
                }
            } else {
                throw new EBBizNCException(new EBBizErrorCode().RESPONSE_ISNULL());
            }
            return ebServiceResponse.getData();
        }
        catch (Exception e) {
            if (e instanceof EBBizNCException && ((EBBizNCException)((Object)e)).getErrorCode().equals((Object)EBExceptionMsgEnum.getErrorCode(EBExceptionMsgEnum.EBGCLOUD_KD_000003.getErrorCode())) && isFirst.booleanValue()) {
                signAlgorithm = AlgorithmEnum.SHA256withRSA.getAlgorithm().equalsIgnoreCase(signAlgorithm) ? AlgorithmEnum.SHA1withRAS.getAlgorithm() : AlgorithmEnum.SHA256withRSA.getAlgorithm();
                logger.info("change signAlgorithm to reconnect:" + signAlgorithm);
                return this.getEBResponseData(request, signAlgorithm);
            }
            throw new EBBizNCException(e, new EBErrorCode().EB_BIZ_EXCEPTION(), e.getMessage());
        }
    }

    private String invokeRpcService(String ebgAppId, String service, String request) {
        try (TXHandle ignore = TX.notSupported();){
            String result;
            String string = result = (String)DispatchServiceHelper.invokeBizService((String)"ebg", (String)ebgAppId, (String)service, (String)service, (Object[])new Object[]{request});
            return string;
        }
    }

    private static String getRandomEncryptKey() {
        return RandomStringUtils.randomAlphanumeric((int)10);
    }

    private static EBServiceResponse parseResponse(String data, String signAlgorithm) {
        try {
            if (data != null) {
                logger.info("data\u4fe1\u606f:" + data);
                EBServiceResponse ebServiceResponse = JsonUtil.fromJson(data, EBServiceResponse.class);
                if ("security_error".equals(ebServiceResponse.getResponseCode())) {
                    APP_CACHE.remove("beiSignAlgorithm");
                    ErrorCode errorCode = EBExceptionMsgEnum.getErrorCodeByCode(false, ebServiceResponse.getResponseMsg());
                    throw new EBBizNCException(errorCode);
                }
                logger.info("beiSignAlgorithm:" + signAlgorithm);
                if (EmptyUtil.isEmpty((String)((String)APP_CACHE.get("beiSignAlgorithm", String.class)))) {
                    APP_CACHE.put("beiSignAlgorithm", (Object)signAlgorithm);
                }
                if (ebServiceResponse.getSignData() != null) {
                    if (VerifySignUtil.verifyRequest(ebServiceResponse, signAlgorithm)) {
                        if (ebServiceResponse.getEncryptKey() != null) {
                            ebServiceResponse.setVersion("1.0");
                            AESDencryptUtil.getDecryptSkey(ebServiceResponse, signAlgorithm);
                            AESDencryptUtil.getAESDecrypt(ebServiceResponse);
                        }
                    } else {
                        logger.info("\u94f6\u4f01\u54cd\u5e94\u62a5\u6587\u89e3\u5bc6\uff0c\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25");
                        ErrorCode errorCode = EBExceptionMsgEnum.getErrorCodeByCode(false, ebServiceResponse.getResponseMsg());
                        throw new EBBizNCException(errorCode);
                    }
                }
                logger.info("\u94f6\u4f01\u54cd\u5e94\u62a5\u6587data= " + CommonUtils.prettyJson(ebServiceResponse.getData()));
                return ebServiceResponse;
            }
            logger.info("openApi\u54cd\u5e94\u62a5\u6587data\u4e3a\u7a7a\u503c");
            return null;
        }
        catch (Exception e) {
            if (e instanceof EBBizNCException && ((EBBizNCException)((Object)e)).getErrorCode().equals((Object)EBExceptionMsgEnum.getErrorCode(EBExceptionMsgEnum.EBGCLOUD_KD_000003.getErrorCode()))) {
                throw new EBBizNCException(EBExceptionMsgEnum.getErrorCode(EBExceptionMsgEnum.EBGCLOUD_KD_000003.getErrorCode()));
            }
            logger.info("getEBResponseData data =" + data);
            throw new EBBizNCException(e, new EBErrorCode().RESPONSE(), e.getMessage());
        }
    }

    private String getService(EBServiceRequest request) {
        if (receiptService.contains(request.getBizType())) {
            return "receiptService";
        }
        if (noteService.contains(request.getBizType())) {
            return "noteService";
        }
        return "aqapService";
    }

    private String getEbgAppId(EBServiceRequest request) {
        if (receiptService.contains(request.getBizType())) {
            return "receipt";
        }
        if (noteService.contains(request.getBizType())) {
            return "note";
        }
        return "aqap";
    }
}

