/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.ebservice.security.atomic;

import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import kd.tmc.fbp.service.ebservice.security.atomic.AbstractEBSecurityBase;
import kd.tmc.fbp.service.ebservice.security.atomic.IEncrypt;
import kd.tmc.fbp.service.ebservice.security.exception.SecurityUnhandleException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public abstract class AbstractEBEncrypt
extends AbstractEBSecurityBase
implements IEncrypt {
    protected Cipher encryptCipher;
    protected Cipher decryptCipher;

    public AbstractEBEncrypt(byte[] key) {
        super(key);
        this.init();
    }

    @Override
    public final void init() {
        try {
            if (!ebInit) {
                Security.addProvider((Provider)new BouncyCastleProvider());
                ebInit = true;
            }
            this.encryptCipher = Cipher.getInstance(this.getAlgorithm());
            this.encryptCipher.init(1, this.getKey());
            this.decryptCipher = Cipher.getInstance(this.getAlgorithm());
            this.decryptCipher.init(2, this.getKey());
        }
        catch (Exception e) {
            throw new SecurityUnhandleException(e);
        }
    }

    @Override
    public String encrypt(byte[] source) {
        String encryptStr = null;
        byte[] result = new byte[]{};
        try {
            result = this.encryptCipher.doFinal(source);
        }
        catch (Exception e) {
            throw new SecurityUnhandleException(e);
        }
        encryptStr = Base64.toBase64String((byte[])result);
        return encryptStr;
    }

    @Override
    public byte[] decrypt(String source) {
        byte[] decryptData = null;
        byte[] plain = Base64.decode((String)source);
        try {
            decryptData = this.decryptCipher.doFinal(plain);
        }
        catch (Exception e) {
            throw new SecurityUnhandleException(e);
        }
        return decryptData;
    }
}

