/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.ebservice.security.register;

import java.util.HashMap;
import java.util.Map;
import kd.tmc.fbp.service.ebservice.enums.AlgorithmEnum;
import kd.tmc.fbp.service.ebservice.security.atomic.IEncrypt;
import kd.tmc.fbp.service.ebservice.security.atomic.ISignature;
import kd.tmc.fbp.service.ebservice.security.impl.RSA256EBSignature;
import kd.tmc.fbp.service.ebservice.security.impl.RSAEBSignature;

public class EBSecurityCatalog {
    private static Map<String, Class<? extends IEncrypt>> EBEncryptStore = new HashMap<String, Class<? extends IEncrypt>>(10);
    private static Map<String, Class<? extends ISignature>> EBSignatureStore = new HashMap<String, Class<? extends ISignature>>(10);

    public static void registerEncrypt(String algorithm, Class<IEncrypt> encrypterClass) {
        EBEncryptStore.put(algorithm, encrypterClass);
    }

    public static void registerSignature(String algorithm, Class<ISignature> signaturerClass) {
        EBSignatureStore.put(algorithm, signaturerClass);
    }

    public static Class<? extends IEncrypt> getEncrypt(String algorithm) {
        return EBEncryptStore.get(algorithm);
    }

    public static Class<? extends ISignature> getSignature(String algorithm) {
        return EBSignatureStore.get(algorithm);
    }

    static {
        EBSignatureStore.put(AlgorithmEnum.SHA1withRAS.getAlgorithm(), RSAEBSignature.class);
        EBSignatureStore.put(AlgorithmEnum.SHA256withRSA.getAlgorithm(), RSA256EBSignature.class);
    }
}

