/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.ebservice.security.utils;

import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.cert.X509Certificate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.BeiServiceConfigHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.service.ebservice.enums.AlgorithmEnum;
import kd.tmc.fbp.service.ebservice.security.utils.HufuManager;
import kd.tmc.fbp.service.ebservice.security.utils.XOREncrypter;
import kd.tmc.fbp.webapi.ebentity.api.EBServiceRequest;
import org.apache.commons.codec.binary.Base64;

public class AESEncryptUtil {
    private static final Log logger = LogFactory.getLog(AESEncryptUtil.class);
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/GCM/PKCS5Padding";
    private static final String KEY_ALGORITHM = "AES";
    private static boolean isJDKSupportAES256 = AESEncryptUtil.testAES256();

    private static byte[] getCertPublicKey() {
        QFilter qFilter = new QFilter("isenable2", "=", (Object)Boolean.TRUE);
        DynamicObject serviceConfig = TmcDataServiceHelper.loadSingle((String)"bei_serviceconfig", (String)"publiccafile_tag", (QFilter[])new QFilter[]{qFilter});
        String fileContent = serviceConfig.getString("publiccafile_tag");
        String customerKey = HufuManager.getCustomerKey();
        return XOREncrypter.decode(customerKey, fileContent);
    }

    public static void setEncrypt(EBServiceRequest request) {
        String data = request.getData();
        String skey = request.getEncryptKey();
        logger.info("\u8bf7\u6c42\u62a5\u6587\u52a0\u5bc6\u524d data = {};", (Object)data);
        logger.info("\u8bf7\u6c42\u62a5\u6587\u52a0\u5bc6\u524d\u7684 version = {};", (Object)request.getVersion());
        try {
            data = AESEncryptUtil.encrypt(data, skey);
            logger.info("\u8bf7\u6c42\u62a5\u6587\u52a0\u5bc6\u540e data = {}", (Object)data);
            request.setData(data);
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u62a5\u6587\u8fdb\u884cAES\u52a0\u5bc6\u5f02\u5e38", (Throwable)e);
        }
    }

    public static String encrypt(String content, String encryptPass) {
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(1, AESEncryptUtil.getSecretKey(encryptPass));
            byte[] iv = cipher.getIV();
            assert (iv.length == 12);
            byte[] encryptData = cipher.doFinal(content.getBytes());
            assert (encryptData.length == content.getBytes().length + 16);
            byte[] message = new byte[12 + content.getBytes().length + 16];
            System.arraycopy(iv, 0, message, 0, 12);
            System.arraycopy(encryptData, 0, message, 12, encryptData.length);
            return Base64.encodeBase64String((byte[])message);
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u62a5\u6587\u8fdb\u884cAES\u52a0\u5bc6\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    private static SecretKeySpec getSecretKey(String encryptPass) throws NoSuchAlgorithmException {
        KeyGenerator kg = KeyGenerator.getInstance(KEY_ALGORITHM);
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(encryptPass.getBytes());
        int aesKeySize = AESEncryptUtil.getAESKeySize();
        logger.info("\u5bc6\u94a5\u4f4d\u6570\uff1a" + aesKeySize);
        logger.info("isJDKSupportAES256:" + isJDKSupportAES256);
        kg.init(aesKeySize, secureRandom);
        SecretKey secretKey = kg.generateKey();
        return new SecretKeySpec(secretKey.getEncoded(), KEY_ALGORITHM);
    }

    public static void setEncryptSKey(EBServiceRequest request) {
        try {
            X509Certificate x509Certificate = X509Certificate.getInstance(AESEncryptUtil.getCertPublicKey());
            PublicKey certPublicKey = x509Certificate.getPublicKey();
            byte[] publicKey = certPublicKey.getEncoded();
            String sKey = AESEncryptUtil.encryptSKey(request.getEncryptKey(), publicKey, request.getSignAlgorithm());
            request.setEncryptKey(sKey);
        }
        catch (Exception e) {
            logger.error("\u52a0\u5bc6\u5f02\u5e38", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u516c\u94a5\u8bc1\u4e66\u52a0\u5bc6\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u516c\u94a5\u8bc1\u4e66\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"AESEncryptUtil_0", (String)"tmc-fbp-mservice", (Object[])new Object[0]));
        }
    }

    public static String encryptSKey(String sKey, byte[] publicKey, String signAlgorithm) throws Exception {
        RSAPublicKey pubKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(publicKey));
        Cipher cipher = AlgorithmEnum.SHA256withRSA.getAlgorithm().equalsIgnoreCase(signAlgorithm) ? Cipher.getInstance("RSA/ECB/OAEPWithSHA256AndMGF1Padding") : Cipher.getInstance("RSA/ECB/OAEPWithMD5AndMGF1Padding");
        cipher.init(1, pubKey);
        return Base64.encodeBase64String((byte[])cipher.doFinal(sKey.getBytes(StandardCharsets.UTF_8)));
    }

    public static int getAESKeySize() {
        String value = "128";
        if (isJDKSupportAES256) {
            DynamicObject serviceConfig = BeiServiceConfigHelper.getServiceConfig();
            value = serviceConfig.getString("secretlength");
            return Integer.parseInt(value);
        }
        return Integer.parseInt(value);
    }

    private static boolean testAES256() {
        byte[] content = "test AES 256".getBytes();
        String pass = "test_pass";
        try {
            KeyGenerator kg = KeyGenerator.getInstance(KEY_ALGORITHM);
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(pass.getBytes());
            kg.init(256, secureRandom);
            SecretKey secretKey = kg.generateKey();
            SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey.getEncoded(), KEY_ALGORITHM);
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(1, secretKeySpec);
            byte[] iv = cipher.getIV();
            assert (iv.length == 12);
            byte[] encryptData = cipher.doFinal(content);
            return encryptData.length == content.length + 16;
        }
        catch (Throwable var10) {
            return false;
        }
    }
}

