/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.ebservice.security.utils;

import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.enums.AlgorithmEnum;
import kd.tmc.fbp.service.ebservice.errorcode.BeErrorCode;
import kd.tmc.fbp.service.ebservice.exception.BESecurityException;
import kd.tmc.fbp.service.ebservice.exception.EBBizNCException;
import kd.tmc.fbp.service.ebservice.security.atomic.ISignature;
import kd.tmc.fbp.service.ebservice.security.impl.EBSecurityFactory;
import kd.tmc.fbp.service.ebservice.security.utils.HufuManager;
import kd.tmc.fbp.service.ebservice.security.utils.XOREncrypter;

public class DefaultSignature {
    private static Log logger = LogFactory.getLog(DefaultSignature.class);
    private ISignature signature = null;

    public DefaultSignature() {
    }

    @Deprecated
    public DefaultSignature(DynamicObject config) {
        this.init(config);
    }

    @Deprecated
    public static DefaultSignature getInstance() {
        QFilter qFilter = new QFilter("isenable", "=", (Object)Boolean.TRUE);
        Object[] services = TmcDataServiceHelper.load((String)"bei_serviceconfig", (String)"id, cafile_tag, customerprivatekey, mcup", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isEmpty((Object[])services) || services.length <= 0) {
            throw new EBBizNCException(new BeErrorCode().BE5000());
        }
        Object serviceConfig = services[0];
        return new DefaultSignature((DynamicObject)serviceConfig);
    }

    public final void init(DynamicObject serviceConfig) {
        String key = RequestContext.get().getTenantId() + RequestContext.get().getAccountId();
        String p12String = HufuManager.getValueByMcUp(serviceConfig);
        if ("".equals(p12String)) {
            throw new BESecurityException(BosErrorCode.registerPasswordNotSame, new Object[]{ResManager.loadKDString((String)"\u6ca1\u6709\u8fdb\u884c\u94f6\u4f01\u670d\u52a1\u5668\u8bbe\u7f6e\uff0c\u8bf7\u5148\u8fdb\u884c\u8bbe\u7f6e\u540e\u624d\u80fd\u8c03\u7528\u94f6\u4f01\u670d\u52a1\u3002", (String)"DefaultSignature_0", (String)"tmc-fbp-mservice", (Object[])new Object[0])});
        }
        String passwordEnc = serviceConfig.getString("customerprivatekey");
        String password = new String(XOREncrypter.decode(key, passwordEnc));
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(new ByteArrayInputStream(XOREncrypter.decode(key, p12String)), password.toCharArray());
            String alias = ks.aliases().nextElement();
            PrivateKey priKey = (PrivateKey)ks.getKey(ks.aliases().nextElement(), password.toCharArray());
            Certificate cert = ks.getCertificate(alias);
            PublicKey pubKey = cert.getPublicKey();
            this.signature = EBSecurityFactory.INSTANCE.getEBSignature(AlgorithmEnum.SHA1withRAS.getAlgorithm(), priKey.getEncoded(), pubKey.getEncoded());
        }
        catch (Exception e) {
            logger.error("CA certificate or password is incorrect , go to the Connectivity Sercice Configuration to test", (Throwable)e);
            throw new BESecurityException(BosErrorCode.registerPasswordNotSame, new Object[]{ResManager.loadKDString((String)"\u94f6\u4f01\u8bc1\u4e66\u9519\u8bef\u6216\u8005\u5bc6\u7801\u4e0d\u6b63\u786e\uff0c\u8bf7\u5230\u94f6\u4f01\u670d\u52a1\u5668\u914d\u7f6e\u4e2d\u8fdb\u884c\u6d4b\u8bd5\u3002", (String)"DefaultSignature_1", (String)"tmc-fbp-mservice", (Object[])new Object[0])});
        }
    }

    public String sign(String content) {
        try {
            return this.signature.sign(content.getBytes("UTF-8"));
        }
        catch (Exception e) {
            logger.error("sign err:" + e.getMessage(), (Throwable)e);
            String s = e.getMessage();
            if (s == null) {
                s = e.getCause() != null ? e.getCause().getMessage() : e.toString();
            }
            throw new BESecurityException(e, BosErrorCode.otherUnknow, s);
        }
    }

    public boolean verify(String sign, String content) {
        try {
            return this.signature.verify(sign, content.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

