/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.ebservice.security.utils;

import java.io.UnsupportedEncodingException;
import java.security.PrivateKey;
import java.security.PublicKey;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.service.ebservice.security.exception.SecurityUnhandleException;
import kd.tmc.fbp.service.ebservice.security.impl.DefaultEBSecurityProvider;
import kd.tmc.fbp.service.ebservice.security.utils.EBKeyProvider;
import kd.tmc.fbp.service.ebservice.security.utils.HufuManager;
import kd.tmc.fbp.service.ebservice.security.utils.XOREncrypter;
import kd.tmc.fbp.webapi.ebentity.api.EBServiceRequest;

public class SignUtil {
    private static final Log logger = LogFactory.getLog(SignUtil.class);

    private static EBKeyProvider getEbKeyProvider() {
        QFilter qFilter = new QFilter("isenable2", "=", (Object)Boolean.TRUE);
        DynamicObject serviceConfig = TmcDataServiceHelper.loadSingle((String)"bei_serviceconfig", (String)"isenable2,cafile_tag,customerprivatekey,mcup", (QFilter[])new QFilter[]{qFilter});
        String fileContent = HufuManager.getValueByMcUp(serviceConfig);
        String customerPrivateKey = serviceConfig.getString("customerprivatekey");
        String customerKey = HufuManager.getCustomerKey();
        byte[] decodePW = XOREncrypter.decode(customerKey, customerPrivateKey);
        String certPwd = new String(decodePW);
        String alias = "";
        logger.info("SignUtil alias=" + alias);
        EBKeyProvider ebKeyProvider = new EBKeyProvider(fileContent, certPwd, alias);
        return ebKeyProvider;
    }

    public static String signRequest(Object obj) {
        String content = SignUtil.getPlainText(obj);
        EBServiceRequest request = (EBServiceRequest)obj;
        EBKeyProvider ebKeyProvider = SignUtil.getEbKeyProvider();
        return SignUtil.sign(content, request.getSignAlgorithm(), ebKeyProvider.getPrivateKey(), ebKeyProvider.getPublicKey());
    }

    public static String sign(String content, String signAlgorithm, PrivateKey privateKey, PublicKey publicKey) {
        DefaultEBSecurityProvider provider = new DefaultEBSecurityProvider(privateKey.getEncoded(), publicKey.getEncoded());
        byte[] data = null;
        try {
            data = content.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SecurityUnhandleException(e);
        }
        return provider.getSignature(signAlgorithm).sign(data);
    }

    private static String getPlainText(Object request) {
        StringBuilder sb = new StringBuilder();
        String toSignData = "";
        if (request instanceof EBServiceRequest) {
            EBServiceRequest req = (EBServiceRequest)request;
            toSignData = sb.append(req.getToken()).append(req.getCustomerID()).append(req.getBizType()).append(req.getTimestamp()).append(req.getEncryptAlgorithm()).append(req.getEncryptKey()).append(req.getData()).append(req.getSignAlgorithm()).append(req.getExtData()).toString();
        }
        return toSignData;
    }
}

