/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.ebservice.service.executor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.helper.BeiServiceConfigHelper;
import kd.tmc.fbp.service.ebservice.enums.EBErrorCodeEnum;
import kd.tmc.fbp.service.ebservice.errorcode.EBBizErrorCode;
import kd.tmc.fbp.service.ebservice.exception.EBBizException;
import kd.tmc.fbp.service.ebservice.exception.EBBizNCException;
import kd.tmc.fbp.service.ebservice.exception.EBRollBackableException;
import kd.tmc.fbp.service.ebservice.exception.EBSQLException;
import kd.tmc.fbp.service.ebservice.http.EBRequestHandlerFactory;
import kd.tmc.fbp.service.ebservice.http.IEBRequestHandler;
import kd.tmc.fbp.service.ebservice.log.BankLogService;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.service.ebservice.service.IEBServiceExecutor;
import kd.tmc.fbp.webapi.ebentity.EBRequest;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayBody;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayDetail;

public class EBServiceExecutor
implements IEBServiceExecutor {
    private static final Log logger = LogFactory.getLog(EBServiceExecutor.class);
    private BankLogService logService;

    @Override
    public <R> R execute(IEBService<R> service) {
        String resultBody;
        IEBRequestHandler requestHandler;
        int timeout;
        EBRequest request;
        this.logService = new BankLogService(service.getBankLogInfo());
        try {
            boolean isValid = service.validate();
            if (!isValid) {
                return service.getEBResult();
            }
            service.beforeRequest();
            request = service.getRequestBuilder().buildRequest();
            DynamicObject serviceConfig = BeiServiceConfigHelper.getServiceConfig();
            timeout = serviceConfig == null || serviceConfig.getInt("timeout") == 0 ? 600000 : serviceConfig.getInt("timeout") * 60 * 1000;
            requestHandler = EBRequestHandlerFactory.getEBRequestHandler(this.logService, service);
            request.getHeader().setCustomId(requestHandler.getCustomerId());
            this.logService.setRequest(request);
            this.logService.save();
        }
        catch (Exception e) {
            this.logService.setBizException(e);
            try {
                if (e instanceof EBSQLException) {
                    service.handleEBException(null, e.getMessage(), e);
                } else {
                    service.rollback(e.getMessage(), e);
                }
                this.logService.setBankayState(BeBillStatusEnum.SF.getValue(), BeBillStatusEnum.TF.getValue());
            }
            catch (Exception e1) {
                logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e1));
            }
            this.logService.save();
            return service.getEBResult();
        }
        try {
            String respStr = requestHandler.executeEBRequest(request, service.getServiceUrl(), timeout);
            this.logService.setResponse(respStr);
            this.checkException(respStr);
            JSONObject response = JSON.parseObject((String)respStr);
            resultBody = JSONObject.toJSONString((Object)response.get((Object)"body"));
        }
        catch (Exception e) {
            this.logService.setResponseException(e);
            try {
                if (e instanceof EBRollBackableException) {
                    service.rollback(e.getMessage(), e);
                    this.logService.setBankayState(BeBillStatusEnum.SF.getValue(), BeBillStatusEnum.TF.getValue());
                } else {
                    service.handleEBException(null, e.getMessage(), e);
                }
            }
            catch (Exception e1) {
                this.logService.setBizException(e1);
                logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e1));
            }
            this.logService.update();
            return service.getEBResult();
        }
        try {
            service.handleResultBody(resultBody);
            if (service.getClass().getName().equals("kd.tmc.bei.business.ebservice.service.pay.BankPayService")) {
                this.updateBankayState(resultBody);
            }
        }
        catch (Exception e) {
            this.logService.setBizException(e);
            try {
                service.handleEBException(resultBody, e.getMessage(), e);
            }
            catch (Exception e1) {
                this.logService.setBizException(e1);
                logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e1));
            }
        }
        this.logService.update();
        return service.getEBResult();
    }

    private void updateBankayState(String resultBody) {
        PayBody payBody = (PayBody)JSON.parseObject((String)resultBody, PayBody.class);
        List details = payBody.getDetails();
        for (PayDetail detail : details) {
            String ebStatus = detail.getEbStatus();
            if (!"EB_ROLL_BACK".equals(ebStatus)) continue;
            String detailBizNo = detail.getDetailBizNo();
            this.logService.setBankLogDetailPayState(detailBizNo, BeBillStatusEnum.TF.getValue());
        }
    }

    protected void checkException(String responseStr) {
        logger.info("responseStr = " + responseStr);
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            throw new EBBizNCException(new EBBizErrorCode().RESPONSE_ISNULL());
        }
        JSONObject response = JSON.parseObject((String)responseStr);
        logger.info("responseStr -> Json response == " + response);
        JSONObject exception = null;
        if (response.containsKey((Object)"exception")) {
            exception = (JSONObject)response.get((Object)"exception");
        }
        if (exception != null) {
            String errorCode = (String)exception.get((Object)"errorCode");
            String message = (String)exception.get((Object)"message");
            logger.info("-------execute EBG request response error : errorCode=" + errorCode + "\uff1bmessage=" + message + "------");
            if (StringUtils.isEmpty((CharSequence)errorCode)) {
                if (StringUtils.isEmpty((CharSequence)message)) {
                    throw new EBBizNCException(new EBBizErrorCode().EC_ISNULL());
                }
                throw new EBBizNCException(new EBBizErrorCode().EC_ISNULL_P(), new Object[]{message});
            }
            if (EBErrorCodeEnum.preException.name().equals(errorCode)) {
                throw new EBBizException(new EBBizErrorCode().PRE_PROCESS(), new Object[]{message});
            }
            if (EBErrorCodeEnum.serviceException.name().equals(errorCode)) {
                throw new EBBizNCException(new EBBizErrorCode().PROCESSING(), new Object[]{message});
            }
            if (EBErrorCodeEnum.afterException.name().equals(errorCode)) {
                throw new EBBizNCException(new EBBizErrorCode().AFTER_PROCESS(), new Object[]{message});
            }
            if (EBErrorCodeEnum.unknown_batch.name().equals(errorCode)) {
                throw new EBBizNCException(new EBBizErrorCode().UNKNOWN_BATCH(), new Object[]{message});
            }
            throw new EBBizNCException(new EBBizErrorCode().EC_UNKNOW(), new Object[]{message});
        }
    }
}

