/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.ebservice.token;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.service.ebservice.enums.EBExceptionMsgEnum;
import kd.tmc.fbp.service.ebservice.errorcode.EBErrorCode;
import kd.tmc.fbp.service.ebservice.exception.EBConnectException;
import kd.tmc.fbp.service.ebservice.http.NewHttpHelper;
import kd.tmc.fbp.service.ebservice.utils.CommonUtils;
import kd.tmc.fbp.service.ebservice.utils.JsonUtil;
import kd.tmc.fbp.webapi.ebentity.auth.AppTokenRequest;
import kd.tmc.fbp.webapi.ebentity.auth.LoginRequest;
import org.apache.commons.lang.ArrayUtils;

public class AccessTokenManager {
    private static final Log logger = LogFactory.getLog(AccessTokenManager.class);
    private static DistributeSessionlessCache accessTokenCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();

    public static String getAccessToken() {
        String accessToken = AccessTokenManager.getCachedAccessToken();
        if (accessToken == null || AccessTokenManager.isTokenExpired()) {
            QFilter qFilter = new QFilter("isenable2", "=", (Object)Boolean.TRUE);
            Object[] services = TmcDataServiceHelper.load((String)"bei_serviceconfig", (String)"id, customerid,customerprivatekey,serveraddress2,appid,appsecret,usertype,useraccount,accountid", (QFilter[])new QFilter[]{qFilter});
            if (ArrayUtils.isEmpty((Object[])services) || services.length <= 0) {
                throw new EBConnectException(new EBErrorCode().CONFIGURE_NOTFOUND());
            }
            Object serviceConfig = services[0];
            String serverAddress2 = serviceConfig.getString("serveraddress2");
            if (StringUtils.isNotEmpty((String)serverAddress2)) {
                String response;
                try {
                    response = AccessTokenManager.getHttpToken((DynamicObject)serviceConfig);
                }
                catch (Exception e) {
                    logger.info(" ===== getHttpToken() ERROR ===== " + e.getMessage());
                    throw new EBConnectException(e, new EBErrorCode().COMMON(), e.getMessage());
                }
                Map mapAppToken = JsonUtil.fromJson(response, Map.class);
                String tokenState = (String)mapAppToken.get("state");
                if (!tokenState.equals("success")) {
                    ErrorCode errorCode = EBExceptionMsgEnum.getErrorCodeWithMessage("acctoken_error", null);
                    throw new EBConnectException(errorCode);
                }
                String appToken = (String)((Map)mapAppToken.get("data")).get("app_token");
                response = AccessTokenManager.getLoginRequest((DynamicObject)serviceConfig, appToken);
                Map mapUserToken = JsonUtil.fromJson(response, Map.class);
                String loginState = (String)mapUserToken.get("state");
                if (!loginState.equals("success")) {
                    ErrorCode errorCode = EBExceptionMsgEnum.getErrorCodeWithMessage("user_error", null);
                    throw new EBConnectException(errorCode);
                }
                accessToken = (String)((Map)mapUserToken.get("data")).get("access_token");
                AccessTokenManager.cacheToken(accessToken);
                return accessToken;
            }
        }
        return accessToken;
    }

    private static String getHttpToken(DynamicObject serviceConfig) {
        String url = serviceConfig.getString("serveraddress2") + "/api/getAppToken.do";
        AppTokenRequest appTokenRequest = new AppTokenRequest();
        appTokenRequest.setAppId(serviceConfig.getString("appid"));
        appTokenRequest.setAppSecuret(serviceConfig.getString("appsecret"));
        appTokenRequest.setLanguage("zh_CN");
        appTokenRequest.setAccountId(serviceConfig.getString("accountid"));
        String data = JsonUtil.toJson(appTokenRequest);
        logger.info("getHttpToken url =" + url);
        logger.info("getHttpToken data =" + CommonUtils.prettyJson(data));
        try {
            String body = NewHttpHelper.tokenPost(url, data);
            logger.info("getHttpToken response body =" + body);
            return body;
        }
        catch (Exception e) {
            logger.info(" ===== getHttpToken() ERROR ===== " + e.getMessage());
            ErrorCode errorCode = EBExceptionMsgEnum.getErrorCodeWithMessage("url_error", e.getMessage());
            throw new EBConnectException(e, errorCode, new Object[0]);
        }
    }

    private static String getLoginRequest(DynamicObject serviceConfig, String appToken) {
        String url = serviceConfig.getString("serveraddress2") + "/api/login.do";
        LoginRequest loginRequest = new LoginRequest();
        loginRequest.setUser(serviceConfig.getString("useraccount"));
        loginRequest.setApptoken(appToken);
        loginRequest.setUsertype(serviceConfig.getString("usertype"));
        loginRequest.setAccountId(serviceConfig.getString("accountid"));
        String data = JsonUtil.toJson(loginRequest);
        logger.info("getLoginRequest url =" + url);
        logger.info("getLoginRequest data =" + CommonUtils.prettyJson(data));
        try {
            String body = NewHttpHelper.tokenPost(url, data);
            logger.info("getLoginRequest response body =" + body);
            return body;
        }
        catch (Exception e) {
            logger.info(" ===== getLoginRequest() ERROR ===== " + e.getMessage());
            throw new EBConnectException(e, new EBErrorCode().LOGIN_EXCEPTION(), e.getMessage());
        }
    }

    private static void cacheToken(String token) {
        int tokenTimeout = 30;
        String tokenTimeoutSetting = "30";
        if (tokenTimeoutSetting != null) {
            tokenTimeout = Integer.parseInt(tokenTimeoutSetting);
        }
        logger.info("cacheToken:tokenTimeout=" + tokenTimeout);
        accessTokenCache.put(AccessTokenManager.getRedisKey(), (Object)token, tokenTimeout, TimeUnit.MINUTES);
        String timeStr = new Date().getTime() + "";
        accessTokenCache.put(AccessTokenManager.getRedisTimeKey(), (Object)timeStr);
    }

    private static String getRedisKey() {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        return tenantId + accountId + ".eb.accesstoken";
    }

    private static String getRedisTimeKey() {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        return tenantId + accountId + ".eb.accesstoken.time";
    }

    private static String getCachedAccessToken() {
        String cachedToken = (String)accessTokenCache.get(AccessTokenManager.getRedisKey());
        return cachedToken;
    }

    private static boolean isTokenExpired() {
        String timeStr = (String)accessTokenCache.get(AccessTokenManager.getRedisTimeKey());
        if (timeStr != null) {
            try {
                long currTime = new Date().getTime();
                long prevTime = Long.parseLong(timeStr);
                long minuteDiff = (currTime - prevTime) / 1000L / 60L;
                String tokenTimeoutSetting = "30";
                return minuteDiff >= (long)Integer.parseInt(tokenTimeoutSetting);
            }
            catch (Exception ignored) {
                return true;
            }
        }
        return true;
    }

    public static void removeAccessToken() {
        accessTokenCache.remove(AccessTokenManager.getRedisKey());
        accessTokenCache.remove(AccessTokenManager.getRedisTimeKey());
    }
}

