/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.ebservice.token;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.enums.AlgorithmEnum;
import kd.tmc.fbp.service.ebservice.errorcode.BeErrorCode;
import kd.tmc.fbp.service.ebservice.errorcode.EBAuthErrorCode;
import kd.tmc.fbp.service.ebservice.errorcode.EBErrorCode;
import kd.tmc.fbp.service.ebservice.exception.BESecurityException;
import kd.tmc.fbp.service.ebservice.exception.EBAuthException;
import kd.tmc.fbp.service.ebservice.exception.EBSignException;
import kd.tmc.fbp.service.ebservice.http.HttpHelper;
import kd.tmc.fbp.service.ebservice.security.utils.DefaultSignature;
import kd.tmc.fbp.webapi.ebentity.api.EBServiceResponse;
import kd.tmc.fbp.webapi.ebentity.auth.AuthRequest;

public class TokenManager {
    private static Log logger = LogFactory.getLog(TokenManager.class);
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
    private static final int TOKEN_TIMEOUT_MINUTES = 10;

    public static String getToken() {
        String token = TokenManager.getCachedToken();
        if (token == null || TokenManager.isTokenExpired()) {
            token = TokenManager.getRemoteToken();
            TokenManager.cacheToken(token);
            return token;
        }
        return token;
    }

    private static String getRemoteToken() {
        QFilter qFilter = new QFilter("isenable", "=", (Object)Boolean.TRUE);
        Object[] services = TmcDataServiceHelper.load((String)"bei_serviceconfig", (String)"id, customerid, cafile_tag, customerprivatekey, serveraddress, mcup", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isEmpty((Object[])services) || services.length <= 0) {
            throw new BESecurityException(new BeErrorCode().BE5000());
        }
        Object serviceConfig = services[0];
        String customerID = serviceConfig.getString("customerid");
        String address = serviceConfig.getString("serveraddress");
        DefaultSignature defaultSignature = new DefaultSignature();
        defaultSignature.init((DynamicObject)serviceConfig);
        String token = TokenManager.getHttpToken(customerID, address, defaultSignature);
        return token;
    }

    private static String getCachedToken() {
        String cachedToken = (String)cache.get(TokenManager.getRedisKey());
        return cachedToken;
    }

    private static void cacheToken(String token) {
        cache.put(TokenManager.getRedisKey(), (Object)token, 10, TimeUnit.MINUTES);
        String timeStr = new Date().getTime() + "";
        cache.put(TokenManager.getRedisTimeKey(), (Object)timeStr);
    }

    private static boolean isTokenExpired() {
        String timeStr = (String)cache.get(TokenManager.getRedisTimeKey());
        if (timeStr != null) {
            try {
                long currTime = new Date().getTime();
                long prevTime = Long.parseLong(timeStr);
                long minuteDiff = (currTime - prevTime) / 1000L / 60L;
                return minuteDiff >= 10L;
            }
            catch (Exception ignored) {
                return true;
            }
        }
        return true;
    }

    private static String getRedisKey() {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        return tenantId + accountId + ".eb.token";
    }

    private static String getRedisTimeKey() {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        return tenantId + accountId + ".eb.token.time";
    }

    private static String getHttpToken(String customerID, String address, DefaultSignature signature) {
        AuthRequest authRequest = new AuthRequest();
        authRequest.setCustomerID(customerID);
        authRequest.setSignAlgorithm(AlgorithmEnum.SHA1withRAS.getAlgorithm());
        authRequest.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        authRequest.setData("auth request");
        TokenManager.signRequest(authRequest, signature);
        String url = address + "/services/auth?customerID=" + customerID;
        logger.info("getHttp: url = " + url);
        HttpHelper httpHelper = new HttpHelper();
        logger.info("getHttp: authRequest = " + JSON.toJSONString((Object)authRequest));
        String result = httpHelper.post(url, JSON.toJSONString((Object)authRequest), 10000);
        logger.info("getHttp: response = " + result);
        EBServiceResponse response = (EBServiceResponse)JSON.parseObject((String)result, EBServiceResponse.class);
        if (response != null) {
            if (!"success".equals(response.getResponseCode())) {
                throw new EBAuthException(new EBAuthErrorCode().RESPONSE(), new Object[]{response.getResponseMsg()});
            }
        } else {
            throw new EBAuthException(new EBAuthErrorCode().RESPONSE_ISNULL());
        }
        logger.info("getHttp:" + response.getData());
        return response.getData();
    }

    private static void signRequest(AuthRequest authRequest, DefaultSignature signature) {
        try {
            String content = TokenManager.getPlainText(authRequest);
            String signData = signature.sign(content);
            authRequest.setSignData(signData);
        }
        catch (Exception e) {
            throw new EBSignException(e, new EBErrorCode().SIGN(), e.getMessage());
        }
    }

    private static String getPlainText(AuthRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append(request.getCustomerID()).append(request.getTimestamp()).append(request.getEncryptAlgorithm()).append(request.getEncryptKey()).append(request.getSignAlgorithm()).append(request.getExtData());
        return sb.toString();
    }
}

