/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.inst.bean;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.tmc.fbp.common.bean.CalcBasisInfo;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.IntCalMethodEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.util.DateUtils;

public class CalcIntInfo {
    private static final BigDecimal MONTH_RATE = new BigDecimal(1200);
    private Date beginDate;
    private Date endDate;
    private BigDecimal principle;
    private BigDecimal rate;
    private BasisEnum basis;
    private IntCalMethodEnum calMethod;
    private BigDecimal curTotalInt = BigDecimal.ZERO;
    private BigDecimal lastTotalInt = BigDecimal.ZERO;
    private int days;
    private int basisDay;
    private Date startIntDate;

    public static CalcIntInfo build(Date beginDate, Date endDate, BigDecimal principle, BigDecimal rate, BasisEnum basis) {
        return CalcIntInfo.build(beginDate, endDate, principle, rate, basis, null);
    }

    public static CalcIntInfo build(BigDecimal principle, BigDecimal rate, BasisEnum basis) {
        return CalcIntInfo.build(null, null, principle, rate, basis);
    }

    public static CalcIntInfo build(Date beginDate, Date endDate, BigDecimal principle, BigDecimal rate, BasisEnum basis, IntCalMethodEnum calMethod) {
        return new CalcIntInfo().setBeginDate(beginDate).setEndDate(endDate).setPrinciple(principle).setRate(rate).setBasis(basis).setCalMethod(calMethod);
    }

    public BigDecimal callOneInt(int scale, int roundingMode) {
        CalcBasisInfo calcBasisInfo = TermHelper.getBaseBasisInfo((Date)this.beginDate, (Date)DateUtils.getNextDay((Date)this.endDate, (int)1), (BasisEnum)this.basis, (Date)this.startIntDate, null);
        int basisDay = calcBasisInfo.getBasisDay();
        this.setBasisDay(basisDay == 0 ? this.getBasisYearDay() : basisDay);
        BigDecimal basic = calcBasisInfo.getBasisAmt();
        this.setDays(calcBasisInfo.getDays());
        return this.principle.multiply(this.rate).multiply(basic).divide(Constants.ONE_HUNDRED, scale, roundingMode);
    }

    public BigDecimal callCompInt(int scale, int roundingMode) {
        int days = DateUtils.getDiffDays((Date)this.beginDate, (Date)this.endDate);
        BigDecimal totalInt = this.lastTotalInt != null ? this.lastTotalInt : BigDecimal.ZERO;
        this.setDays(days);
        BigDecimal yearRate = this.rate.multiply(Constants.ONE_FEN);
        this.basisDay = this.getBasisYearDay();
        return this.principle.add(totalInt).multiply(BigDecimal.valueOf(days)).multiply(yearRate).divide(new BigDecimal(this.basisDay), scale, roundingMode);
    }

    public BigDecimal callCompIntForZhye(int scale, int roundingMode) {
        int days = DateUtils.getDiffDays((Date)this.beginDate, (Date)this.endDate);
        BigDecimal totalInt = this.lastTotalInt != null ? this.lastTotalInt : BigDecimal.ZERO;
        totalInt = totalInt.multiply(BigDecimal.valueOf(days));
        this.setDays(days);
        BigDecimal yearRate = this.rate.multiply(Constants.ONE_FEN);
        this.basisDay = this.getBasisYearDay();
        return this.principle.add(totalInt).multiply(yearRate).divide(new BigDecimal(this.basisDay), scale, roundingMode);
    }

    public BigDecimal callTotalInt(int scale, int roundingMode) {
        int days = DateUtils.getDiffDays((Date)this.beginDate, (Date)this.endDate);
        this.setDays(days);
        BigDecimal yearRate = this.rate.multiply(Constants.ONE_FEN);
        this.basisDay = this.getBasisYearDay();
        return this.principle.multiply(new BigDecimal(days)).multiply(yearRate).divide(new BigDecimal(this.basisDay), scale, roundingMode);
    }

    public BigDecimal callTotalIntForZhye(int scale, int roundingMode) {
        this.setDays(DateUtils.getDiffDays((Date)this.beginDate, (Date)this.endDate));
        BigDecimal yearRate = this.rate.multiply(Constants.ONE_FEN);
        this.basisDay = this.getBasisYearDay();
        return this.principle.multiply(yearRate).divide(new BigDecimal(this.basisDay), scale, roundingMode);
    }

    public BigDecimal callPeriodInt(int scale, int roundingMode) {
        Date nextDay = DateUtils.getNextDay((Date)this.endDate, (int)1);
        String term = DateUtils.getDiff_ymd((Date)this.beginDate, (Date)nextDay);
        Map ymd = TermHelper.getYMD((String)term);
        int year = (Integer)ymd.get("y");
        int month = (Integer)ymd.get("m");
        int day = (Integer)ymd.get("d");
        BigDecimal months = new BigDecimal(year * 12 + month);
        BigDecimal mInt = this.principle.multiply(this.rate).multiply(months).divide(MONTH_RATE, scale, roundingMode);
        BigDecimal yearRate = this.rate.multiply(Constants.ONE_FEN);
        this.basisDay = this.getBasisYearDay();
        BigDecimal dInt = this.principle.multiply(yearRate).multiply(new BigDecimal(day)).divide(new BigDecimal(this.basisDay), scale, roundingMode);
        this.setDays(TermHelper.getBasis_BetweenDay((Date)this.beginDate, (Date)nextDay, (BasisEnum)this.basis, null));
        return mInt.add(dInt);
    }

    private int getBasisYearDay() {
        Date tmpStartIntDate = this.basis == BasisEnum.ISDA_Actual_365 ? this.beginDate : this.startIntDate;
        return TermHelper.getBasis_YearDay((Date)(tmpStartIntDate == null ? this.beginDate : tmpStartIntDate), (Date)this.beginDate, (BasisEnum)this.basis);
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public CalcIntInfo setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
        return this;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public CalcIntInfo setEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    public BigDecimal getPrinciple() {
        return this.principle;
    }

    public CalcIntInfo setPrinciple(BigDecimal principle) {
        this.principle = principle;
        return this;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public CalcIntInfo setRate(BigDecimal rate) {
        this.rate = rate;
        return this;
    }

    public BasisEnum getBasis() {
        return this.basis;
    }

    public CalcIntInfo setBasis(BasisEnum basis) {
        this.basis = basis;
        return this;
    }

    public IntCalMethodEnum getCalMethod() {
        return this.calMethod;
    }

    public CalcIntInfo setCalMethod(IntCalMethodEnum calMethod) {
        this.calMethod = calMethod;
        return this;
    }

    public BigDecimal getLastTotalInt() {
        return this.lastTotalInt;
    }

    public CalcIntInfo setLastTotalInt(BigDecimal lastTotalInt) {
        this.lastTotalInt = lastTotalInt;
        return this;
    }

    public BigDecimal getCurTotalInt() {
        return this.curTotalInt;
    }

    public CalcIntInfo setCurTotalInt(BigDecimal curTotalInt) {
        this.curTotalInt = curTotalInt;
        return this;
    }

    public int getDays() {
        return this.days;
    }

    public CalcIntInfo setDays(int days) {
        this.days = days;
        return this;
    }

    public int getBasisDay() {
        return this.basisDay;
    }

    public CalcIntInfo setBasisDay(int basisDay) {
        this.basisDay = basisDay;
        return this;
    }

    public Date getStartIntDate() {
        return this.startIntDate;
    }

    public CalcIntInfo setStartIntDate(Date startIntDate) {
        this.startIntDate = startIntDate;
        return this;
    }
}

