/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.inst.helper;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackOperateEnum;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackParam;

public class BizBill2PayBillWriteBackHelper {
    public static final Log LOG = LogFactory.getLog(BizBill2PayBillWriteBackHelper.class);
    private static final String LOCK_PAYAMT = "lockpayamt";

    public static void updateBizBillLockAmt(PayBillWriteBackParam param, DynamicObject sourceBill) {
        PayBillWriteBackOperateEnum operateEnum = PayBillWriteBackOperateEnum.getByValue(param.getOperate());
        if (operateEnum == PayBillWriteBackOperateEnum.SAVE || operateEnum == PayBillWriteBackOperateEnum.SUBMIT) {
            sourceBill.set(LOCK_PAYAMT, (Object)param.getPayBill().getAmount());
        } else if (operateEnum == PayBillWriteBackOperateEnum.DELETE || operateEnum == PayBillWriteBackOperateEnum.CHARGEBACK) {
            sourceBill.set(LOCK_PAYAMT, null);
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sourceBill});
            }
            catch (Exception e) {
                tx.markRollback();
                LOG.error("\u4e1a\u52a1\u5355\u66f4\u65b0\u53d1\u751f\u5f02\u5e38\uff1a", (Object)e.getMessage());
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public static void checkPayTypeWhenOnline(PayBillWriteBackParam param, DynamicObject sourceBill) {
        String tradeChannel = sourceBill.getString("tradechannel");
        if (!"online".equals(tradeChannel)) {
            return;
        }
        PayBillWriteBackParam.PayBillInfo payBillInfo = param.getPayBill();
        DynamicObject identifyDyn = QueryServiceHelper.queryOne((String)"cas_paymentidentify", (String)"type", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)payBillInfo.getPaymentidentify())});
        if (EmptyUtil.isEmpty((DynamicObject)identifyDyn) || !"1".equals(identifyDyn.getString("type"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ea4\u6613\u6e20\u9053\u4e3a\u94f6\u4f01\u76f4\u8054\u65f6\uff0c\u751f\u6210\u7684\u4ed8\u6b3e\u5355\u4ed8\u6b3e\u6807\u8bc6\u987b\u662f\u88ab\u52a8\u4ed8\u6b3e\u3002", (String)"BizBill2PayBillWriteBackHelper_1", (String)"tmc-fbp-mservice", (Object[])new Object[0]));
        }
    }
}

