/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.inst.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.IntHTRuleEnum;
import kd.tmc.fbp.common.enums.IntPrincipleRuleEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.model.interest.BizBillInfo;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.model.interest.RateInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class IntSegmentHelper {
    protected static final Log logger = LogFactory.getLog(IntSegmentHelper.class);

    public static List<IntBillDetailInfo> getSubRateByDebx(Set<RateInfo> rateList, Date beginDate) {
        ArrayList<IntBillDetailInfo> list = new ArrayList<IntBillDetailInfo>(10);
        TreeMap<Date, RateInfo> treeMap = new TreeMap<Date, RateInfo>(rateList.stream().collect(Collectors.toMap(RateInfo::getEffectiveDate, r -> r, (r1, r2) -> r1)));
        Map.Entry<Date, RateInfo> entry = treeMap.floorEntry(beginDate);
        if (entry != null) {
            list.add(IntBillDetailInfo.build((int)1, (Date)beginDate, (BigDecimal)entry.getValue().getRate()));
        }
        return list;
    }

    public static List<IntBillDetailInfo> getSubRate(Set<RateInfo> rateList, Date beginDate, Date endDate) {
        ArrayList<IntBillDetailInfo> effectList = new ArrayList<IntBillDetailInfo>(8);
        TreeMap<Date, RateInfo> rateMap = new TreeMap<Date, RateInfo>(rateList.stream().filter(r -> r.getEffectiveDate().compareTo(endDate) <= 0).collect(Collectors.toMap(RateInfo::getEffectiveDate, r -> r, (r1, r2) -> r1)));
        if (rateMap.isEmpty()) {
            return effectList;
        }
        Map.Entry<Date, RateInfo> floorEntry = rateMap.floorEntry(beginDate);
        if (floorEntry != null) {
            effectList.add(IntBillDetailInfo.build((int)1, (Date)beginDate, (BigDecimal)floorEntry.getValue().getRate()));
        }
        for (Map.Entry entry : rateMap.tailMap(beginDate, false).entrySet()) {
            RateInfo rateInfo = (RateInfo)entry.getValue();
            effectList.add(IntBillDetailInfo.build((int)(effectList.size() + 1), (Date)rateInfo.getEffectiveDate(), (BigDecimal)rateInfo.getRate()));
        }
        return effectList;
    }

    public static List<IntBillDetailInfo> getSubPrinciple(List<IntBillDetailInfo> detailList, BizBillInfo bizBill, List<PlanCallResult> repayPlanList, boolean isPreInt) {
        ArrayList<IntBillDetailInfo> details = new ArrayList<IntBillDetailInfo>();
        if (EmptyUtil.isNoEmpty(repayPlanList)) {
            repayPlanList.forEach(r -> r.setBizDate(DateUtils.truncateDate((Date)r.getBizDate())));
            repayPlanList.sort(Comparator.comparing(PlanCallResult::getBizDate));
            IntSegmentHelper.updateRepayBizDateByTailRule(bizBill, repayPlanList);
            for (IntBillDetailInfo detail : detailList) {
                details.addAll(IntSegmentHelper.getSubPrinciple(detail, repayPlanList));
            }
            IntSegmentHelper.callSubPrinciple(details, bizBill, repayPlanList, isPreInt);
        } else {
            IntSegmentHelper.callSubPrinciple(detailList, bizBill, repayPlanList, isPreInt);
            details.addAll(detailList);
        }
        return details;
    }

    private static void updateRepayBizDateByTailRule(BizBillInfo bizBill, List<PlanCallResult> repayPlanList) {
        if (IntHTRuleEnum.isNoTail((String)bizBill.getHtRule().getValue())) {
            return;
        }
        for (PlanCallResult repayPlan : repayPlanList) {
            if (repayPlan.getBizDate().compareTo(bizBill.getEndDate()) != 0) continue;
            repayPlan.setBizDate(DateUtils.getNextDay((Date)repayPlan.getBizDate(), (int)1));
            break;
        }
    }

    private static List<IntBillDetailInfo> getSubPrinciple(IntBillDetailInfo detail, List<PlanCallResult> repayList) {
        Date beginDate = detail.getBeginDate();
        Date endDate = detail.getEndDate();
        HashMap<Date, IntBillDetailInfo> detailMap = new HashMap<Date, IntBillDetailInfo>(10);
        for (int index = repayList.size() - 1; index >= 0; --index) {
            PlanCallResult repayPlan = repayList.get(index);
            Date bizDate = repayPlan.getBizDate();
            if (bizDate.compareTo(beginDate) <= 0 || bizDate.compareTo(endDate) > 0) continue;
            IntBillDetailInfo subDetail = IntBillDetailInfo.build((int)0, (Date)bizDate, (BigDecimal)detail.getRate());
            if (!detailMap.containsKey(bizDate)) {
                detailMap.put(bizDate, subDetail);
            }
            detail.setEndDate(DateUtils.getLastDay((Date)bizDate, (int)1));
            endDate = detail.getEndDate();
        }
        if (!detailMap.containsKey(detail.getBeginDate())) {
            detailMap.put(detail.getBeginDate(), detail);
        }
        return new ArrayList<IntBillDetailInfo>(detailMap.values());
    }

    private static void callSubPrinciple(List<IntBillDetailInfo> details, BizBillInfo bizBill, List<PlanCallResult> repayPlanList, boolean isPreInt) {
        Date endDate = bizBill.getEndDate();
        IntPrincipleRuleEnum principleRule = bizBill.getPrincipleRule();
        BigDecimal loanAmount = bizBill.getLoanAmount();
        List<IntBillDetailInfo> detailList = IntSegmentHelper.orderAGenEndDateAndDays(details, endDate);
        for (IntBillDetailInfo detail : detailList) {
            Date detailEndDate = detail.getEndDate() != null ? detail.getEndDate() : endDate;
            BigDecimal currentPlanTotalAmt = loanAmount;
            if (EmptyUtil.isNoEmpty(repayPlanList) && IntPrincipleRuleEnum.loanbal == principleRule) {
                for (PlanCallResult repayInfo : repayPlanList) {
                    boolean afterBizDate;
                    boolean bl = afterBizDate = detailEndDate.compareTo(repayInfo.getBizDate()) >= 0;
                    if (isPreInt) {
                        if (!afterBizDate) continue;
                        currentPlanTotalAmt = currentPlanTotalAmt.subtract(repayInfo.getPrinciple());
                        continue;
                    }
                    if ((!afterBizDate || repayInfo.isPayInt()) && !repayInfo.isPayInt()) continue;
                    currentPlanTotalAmt = currentPlanTotalAmt.subtract(repayInfo.getPrinciple());
                }
            }
            detail.setPrinciple(currentPlanTotalAmt);
        }
    }

    public static List<IntBillDetailInfo> orderAGenEndDateAndDays(List<IntBillDetailInfo> detailInfos, Date calIntEndDate) {
        detailInfos.sort(Comparator.comparing(IntBillDetailInfo::getBeginDate));
        for (int index = 0; index < detailInfos.size(); ++index) {
            IntBillDetailInfo detail = detailInfos.get(index);
            detail.setSeq(index + 1);
            if (index < detailInfos.size() - 1) {
                detail.setEndDate(DateUtils.getLastDay((Date)detailInfos.get(index + 1).getBeginDate(), (int)1));
            } else {
                detail.setEndDate(calIntEndDate);
            }
            detail.setDays(DateUtils.getDiffDays((Date)detail.getBeginDate(), (Date)detail.getEndDate()));
        }
        return detailInfos;
    }

    public static List<IntBillDetailInfo> splitForActAct(List<IntBillDetailInfo> detailList, Date startIntDate, BasisEnum basisEnum) {
        switch (basisEnum) {
            case Actual_actual: {
                detailList = TermHelper.splitByStartIntDate(detailList, (Date)startIntDate, (BasisEnum)basisEnum);
                logger.info("\u6309\u8d77\u606f\u65e5\u671f\u8fdb\u884c\u5206\u6bb5\uff1a" + SerializationUtils.toJsonString((Object)detailList));
                break;
            }
            case ISDA_Actual_365: {
                detailList = TermHelper.splitByLeapYear(detailList, (BasisEnum)basisEnum);
                logger.info("\u6309\u662f\u5426\u6da6\u5e74\u5929\u6570\u8fdb\u884c\u5206\u6bb5\uff1a" + SerializationUtils.toJsonString((Object)detailList));
                break;
            }
        }
        return detailList;
    }
}

