/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.inst.interest;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.InterTypeEnum;
import kd.tmc.fbp.common.model.interest.BizBillInfo;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntCalRequest;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.inst.bean.CalcIntInfo;
import kd.tmc.fbp.service.inst.helper.IntBillDetailHelper;
import kd.tmc.fbp.service.inst.interest.AbstractIntCallStragety;

public class ZHYEIntCallStragety
extends AbstractIntCallStragety {
    @Override
    protected BigDecimal callInt(List<IntBillDetailInfo> details, BizBillInfo bizBill) {
        BigDecimal totalInt = BigDecimal.ZERO;
        for (IntBillDetailInfo detail : details) {
            CalcIntInfo calcIntInfo = CalcIntInfo.build(detail.getBeginDate(), detail.getEndDate(), detail.getPrinciple(), detail.getRate(), bizBill.getBasis(), bizBill.getIntCalMethod()).setLastTotalInt(totalInt).setStartIntDate(bizBill.getStartIntDate());
            detail.setLastTotalInt(totalInt);
            BigDecimal amount = this.callInt(calcIntInfo);
            detail.setAmount(amount);
            totalInt = InterTypeEnum.overdue == detail.getIntType() ? totalInt.subtract(amount) : totalInt.add(amount);
            calcIntInfo.setCurTotalInt(totalInt);
            detail.setBasisDay(calcIntInfo.getBasisDay());
        }
        return totalInt;
    }

    @Override
    protected List<IntBillDetailInfo> mergeDetail(List<IntBillDetailInfo> detailList) {
        return IntBillDetailHelper.mergeDetailByRateAndIntType(detailList);
    }

    @Override
    protected List<IntBillDetailInfo> getSubPrinciple(IntCalRequest request, List<IntBillDetailInfo> detailList) {
        List balanceList = request.getRepayList();
        BizBillInfo bizBill = request.getBizBill();
        balanceList.sort(Comparator.comparing(PlanCallResult::getBizDate));
        boolean isCalOverInt = bizBill.isCalOverInt();
        if (isCalOverInt) {
            detailList = this.getSubPrinciple(detailList.stream().collect(Collectors.toSet()), (List<PlanCallResult>)balanceList).stream().collect(Collectors.toList());
        }
        detailList.sort(Comparator.comparing(IntBillDetailInfo::getBeginDate));
        BigDecimal principle = BigDecimal.ZERO;
        for (IntBillDetailInfo detail : detailList) {
            Date bizDate = detail.getBeginDate();
            while (bizDate.compareTo(detail.getEndDate()) <= 0) {
                BigDecimal dayBalance = this.getDayBalance(bizDate, balanceList);
                if (this.isNegativeAmt(dayBalance) && !isCalOverInt) {
                    dayBalance = Constants.ZERO;
                }
                principle = principle.add(dayBalance);
                bizDate = DateUtils.getNextDay((Date)bizDate, (int)1);
            }
            if (this.isNegativeAmt(principle)) {
                detail.setIntType(InterTypeEnum.overdue);
                BigDecimal bp = bizBill.getOverPoint().divide(Constants.ONE_HUNDRED, 10, 4);
                detail.setRate(detail.getRate().add(bp));
            } else {
                detail.setIntType(InterTypeEnum.normal);
            }
            detail.setDays(DateUtils.getDiffDays((Date)detail.getBeginDate(), (Date)detail.getEndDate()));
            detail.setPrinciple(principle.abs());
            principle = BigDecimal.ZERO;
        }
        return detailList;
    }

    private Set<IntBillDetailInfo> getSubPrinciple(Set<IntBillDetailInfo> detailList, List<PlanCallResult> balanceList) {
        HashSet<IntBillDetailInfo> allDetailList = new HashSet<IntBillDetailInfo>(10);
        for (IntBillDetailInfo detail : detailList) {
            Set<IntBillDetailInfo> addNewList = this.getSubPrinciple(detail, balanceList);
            allDetailList.addAll(addNewList);
        }
        return allDetailList;
    }

    private Set<IntBillDetailInfo> getSubPrinciple(IntBillDetailInfo detail, List<PlanCallResult> balanceList) {
        BigDecimal lastDayBalance = Constants.ZERO;
        HashSet<IntBillDetailInfo> addNewList = new HashSet<IntBillDetailInfo>(10);
        Date bizDate = detail.getBeginDate();
        while (bizDate.compareTo(detail.getEndDate()) <= 0) {
            BigDecimal dayBalance = this.getDayBalance(bizDate, balanceList);
            if (EmptyUtil.isEmpty((BigDecimal)lastDayBalance)) {
                lastDayBalance = dayBalance;
            }
            if (Boolean.compare(this.isNegativeAmt(dayBalance), this.isNegativeAmt(lastDayBalance)) != 0) {
                IntBillDetailInfo newDetail = new IntBillDetailInfo();
                newDetail.setBeginDate(bizDate);
                newDetail.setEndDate(detail.getEndDate());
                newDetail.setRate(detail.getRate());
                Set<IntBillDetailInfo> newDetailSet = this.getSubPrinciple(newDetail, balanceList);
                addNewList.addAll(newDetailSet);
                detail.setEndDate(DateUtils.getLastDay((Date)bizDate, (int)1));
            }
            lastDayBalance = dayBalance;
            bizDate = DateUtils.getNextDay((Date)bizDate, (int)1);
        }
        addNewList.add(detail);
        return addNewList;
    }

    private boolean isNegativeAmt(BigDecimal amount) {
        return amount.compareTo(Constants.ZERO) < 0;
    }

    protected BigDecimal getDayBalance(Date bizDate, List<PlanCallResult> balanceList) {
        BigDecimal amount = BigDecimal.ZERO;
        for (PlanCallResult balance : balanceList) {
            if (balance.getBizDate().compareTo(bizDate) > 0) break;
            amount = balance.getPrinciple();
        }
        return amount;
    }

    @Override
    protected BigDecimal callTotalInt(CalcIntInfo calcIntInfo) {
        return calcIntInfo.callTotalIntForZhye(this.SCALE, this.ROUND);
    }

    @Override
    protected BigDecimal callCompInt(CalcIntInfo calcIntInfo) {
        return calcIntInfo.callCompIntForZhye(this.SCALE, this.ROUND);
    }
}

