/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.inst.plan;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.RateCycleWayEnum;
import kd.tmc.fbp.common.enums.RepaySchemeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.model.interest.RepayPlanCallRequest;
import kd.tmc.fbp.common.model.interest.RepaySchemeInfo;
import kd.tmc.fbp.common.model.interest.WorkCalendarAdjustParam;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.service.inst.plan.IPlanCallStragety;

public abstract class AbstractPlanCallStragety
implements IPlanCallStragety {
    protected final Log logger = LogFactory.getLog(this.getClass());

    protected List<PlanCallResult> doCycle(RepayPlanCallRequest request) {
        return this.createPlanByCycle(request);
    }

    protected List<PlanCallResult> doByDay(RepayPlanCallRequest request) {
        ArrayList<PlanCallResult> repayList = new ArrayList<PlanCallResult>(16);
        Date beginDate = request.getBeginDate();
        Date endDate = request.getEndDate();
        Integer days = request.getSchemeInfo().getDays();
        days = days == null || days <= 0 ? 1 : days;
        beginDate = DateUtils.getNextDay((Date)beginDate, (int)(days - 1));
        while (beginDate.before(endDate)) {
            repayList.add(this.createPlanByCycle(beginDate, false, 0));
            beginDate = DateUtils.getNextDay((Date)beginDate, (int)days);
        }
        repayList.add(this.createPlanByCycle(endDate, true, 0));
        return repayList;
    }

    private List<PlanCallResult> createPlanByCycle(RepayPlanCallRequest request) {
        Date beginDate = request.getBeginDate();
        Date endDate = request.getEndDate();
        RepaySchemeInfo schemeInfo = request.getSchemeInfo();
        Boolean repayMonthSettle = schemeInfo.getRepayMonthSettle() != null ? schemeInfo.getRepayMonthSettle() : Boolean.FALSE;
        List repayMonths = schemeInfo.getRepayMonths();
        Integer repayDay = schemeInfo.getRepayDay();
        Integer offetDay = schemeInfo.getOffetDay() != null ? schemeInfo.getOffetDay() : 0;
        ArrayList<PlanCallResult> repayList = new ArrayList<PlanCallResult>(16);
        LocalDate localBeginDate = DateUtils.date2LocalDate((Date)beginDate);
        LocalDate localEndDate = DateUtils.date2LocalDate((Date)endDate);
        LocalDate tempDate = localBeginDate;
        int beginDateYear = localBeginDate.getYear();
        int beginDateMonth = localBeginDate.getMonthValue();
        while (tempDate.isBefore(localEndDate)) {
            int curYear = tempDate.getYear();
            for (int month = 1; month <= 12; ++month) {
                PlanCallResult info;
                LocalDate bizDate = LocalDate.of(curYear, month, 1);
                int maxDays = Math.min(bizDate.lengthOfMonth(), repayDay);
                if ((bizDate = LocalDate.of(curYear, month, maxDays)).isAfter(localEndDate)) break;
                if (bizDate.compareTo(localBeginDate) < 0 || !repayMonths.contains(month) || !repayMonthSettle.booleanValue() && bizDate.getYear() == beginDateYear && bizDate.getMonthValue() == beginDateMonth || !(info = this.createPlanByCycle(DateUtils.localDate2Date((LocalDate)bizDate), false, offetDay)).getBizDate().before(endDate)) continue;
                repayList.add(info);
            }
            tempDate = tempDate.plusYears(1L);
            tempDate = tempDate.with(ChronoField.MONTH_OF_YEAR, 1L).with(ChronoField.DAY_OF_MONTH, 1L);
        }
        this.updatePlanByHbfx(request, repayList, localBeginDate, localEndDate);
        repayList.add(this.createPlanByCycle(endDate, true, offetDay));
        return repayList;
    }

    private void updatePlanByHbfx(RepayPlanCallRequest request, List<PlanCallResult> repayList, LocalDate localBeginDate, LocalDate localEndDate) {
        if (!RepaymentWayEnum.isHbfx((String)request.getRepayWay().getValue())) {
            return;
        }
        int months = (localEndDate.getYear() - localBeginDate.getYear()) * 12 + (localEndDate.getMonthValue() - localBeginDate.getMonthValue());
        String repayPeriod = request.getSchemeInfo().getRepayScheme().getValue();
        int divizor = 1;
        if (RepaySchemeEnum.isQuarter((String)repayPeriod)) {
            divizor = 3;
        } else if (RepaySchemeEnum.isHalfYear((String)repayPeriod)) {
            divizor = 6;
        } else if (RepaySchemeEnum.isYear((String)repayPeriod)) {
            divizor = 12;
        }
        int repaySize = months / divizor + (months % divizor > 0 ? 1 : 0);
        if (repaySize <= repayList.size()) {
            repayList.remove(repayList.size() - 1);
        }
    }

    protected List<PlanCallResult> doToCycle(RepayPlanCallRequest request) {
        Integer months = null;
        RepaySchemeInfo schemeInfo = request.getSchemeInfo();
        switch (schemeInfo.getRepayScheme()) {
            case TOYEAR: {
                months = 12;
                break;
            }
            case TOQUARTER: {
                months = 3;
                break;
            }
            case TOMONTH: {
                months = 1;
                break;
            }
            case TOHALFYEAR: {
                months = 6;
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        WorkCalendarAdjustParam adjustParam = request.getWorkCalendarAdjustParam();
        if (adjustParam != null && adjustParam.isCanAdjust()) {
            return this.createPlanByToCycleForAdjust(request.getBeginDate(), request.getEndDate(), months, schemeInfo.getOffetDay(), adjustParam);
        }
        return this.createPlanByToCycleNoAdjust(request.getBeginDate(), request.getEndDate(), months, schemeInfo.getOffetDay());
    }

    private List<PlanCallResult> createPlanByToCycleNoAdjust(Date beginDate, Date endDate, Integer months, Integer offetDay) {
        int offsetDay = offetDay != null ? offetDay : 0;
        ArrayList<PlanCallResult> repayList = new ArrayList<PlanCallResult>(16);
        LocalDate localBeginDate = DateUtils.date2LocalDate((Date)beginDate);
        LocalDate localEndDate = DateUtils.date2LocalDate((Date)endDate);
        boolean isEndMonthDay = localBeginDate.lengthOfMonth() == localBeginDate.getDayOfMonth();
        int addMonth = months;
        LocalDate bizDate = localBeginDate.plusMonths(addMonth);
        if (isEndMonthDay) {
            bizDate = LocalDate.of(bizDate.getYear(), bizDate.getMonthValue(), bizDate.lengthOfMonth());
        }
        while (bizDate.isBefore(localEndDate)) {
            Date planDate = DateUtils.localDate2Date((LocalDate)bizDate);
            PlanCallResult plan = this.createPlanByToCycle(planDate, false, offsetDay);
            if (plan.getBizDate().before(endDate)) {
                repayList.add(plan);
            }
            bizDate = localBeginDate.plusMonths(addMonth += months.intValue());
            if (!isEndMonthDay) continue;
            bizDate = LocalDate.of(bizDate.getYear(), bizDate.getMonthValue(), bizDate.lengthOfMonth());
        }
        repayList.add(this.createPlanByToCycle(endDate, true, offsetDay));
        return repayList;
    }

    private List<PlanCallResult> createPlanByToCycleForAdjust(Date beginDate, Date endDate, Integer months, Integer offetDay, WorkCalendarAdjustParam adjustParam) {
        if (adjustParam == null || !adjustParam.isCanAdjust()) {
            return Collections.emptyList();
        }
        int offsetDay = offetDay != null ? offetDay : 0;
        ArrayList<PlanCallResult> repayList = new ArrayList<PlanCallResult>(16);
        LocalDate localBeginDate = DateUtils.date2LocalDate((Date)beginDate);
        LocalDate localEndDate = DateUtils.date2LocalDate((Date)endDate);
        LocalDate bizDate = localBeginDate.plusMonths(months.intValue());
        int addMonth = months;
        while (bizDate.isBefore(localEndDate)) {
            Date adjustBizDate = TermHelper.callAdjustSettleDate((DynamicObjectCollection)adjustParam.getWorkCalendars(), (Date)DateUtils.localDate2Date((LocalDate)bizDate), (AdjustMethodEnum)adjustParam.getAdjustMethod());
            PlanCallResult plan = this.createPlanByToCycle(adjustBizDate, false, offsetDay);
            if (plan.getBizDate().before(endDate)) {
                repayList.add(plan);
            }
            if (adjustParam.getRateCycleWay() == RateCycleWayEnum.FixCycle) {
                LocalDate localDate = DateUtils.date2LocalDate((Date)adjustBizDate);
                int day = localDate.getDayOfMonth() == localDate.lengthOfMonth() ? 31 : localDate.getDayOfMonth();
                bizDate = localDate.plusMonths(months.intValue());
                bizDate = bizDate.withDayOfMonth(Math.min(bizDate.lengthOfMonth(), day));
                continue;
            }
            bizDate = localBeginDate.plusMonths(addMonth += months.intValue());
        }
        LocalDate lastPlanDate = null;
        if (!repayList.isEmpty()) {
            lastPlanDate = DateUtils.date2LocalDate((Date)((PlanCallResult)repayList.get(repayList.size() - 1)).getBizDate());
        }
        if (lastPlanDate != null && lastPlanDate.isBefore(localEndDate)) {
            repayList.add(this.createPlanByToCycle(endDate, true, offsetDay));
        }
        return repayList;
    }

    protected abstract PlanCallResult createPlanByCycle(Date var1, boolean var2, Integer var3);

    protected PlanCallResult createPlanByToCycle(Date bizDate, boolean isLast, Integer offetDay) {
        PlanCallResult result = new PlanCallResult();
        if (isLast) {
            result.setBizDate(bizDate);
        } else {
            result.setBizDate(DateUtils.getNextDay((Date)bizDate, (int)offetDay));
        }
        return result;
    }
}

