/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.inst.plan;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.tmc.fbp.common.enums.RepaySchemeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.model.interest.RepayPlanCallRequest;
import kd.tmc.fbp.common.model.interest.RepayPlanRequest;
import kd.tmc.fbp.common.model.interest.RepaySchemeInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.ListUtils;
import kd.tmc.fbp.service.inst.plan.AbstractPlanCallStragety;

public class RepayPlanCallStragety
extends AbstractPlanCallStragety {
    public List<PlanCallResult> callPlan(RepayPlanRequest request) {
        DynamicObject currency;
        this.logger.info("\u751f\u6210\u8fd8\u6b3e\u8ba1\u5212\u8bf7\u6c42\u53c2\u6570: {}", (Object)SerializationUtils.toJsonString((Object)request));
        RepayPlanCallRequest callRequest = new RepayPlanCallRequest();
        callRequest.setBeginDate(request.getLoanDate()).setEndDate(request.getExpiredate()).setRepayWay(request.getRepayWay()).setBalance(request.getLoanAmount()).setFixedRepayAmount(request.getFixedRepayAmount());
        RepaySchemeInfo schemeInfo = this.trans2RepaySchemeInfo(request.getRepayScheme());
        callRequest.setSchemeInfo(schemeInfo);
        if (request.getRound() != null) {
            callRequest.setAmountRound(Integer.valueOf(request.getRound().getRound()));
        }
        if ((currency = request.getCurrency()) != null) {
            currency = TmcDataServiceHelper.loadSingle((Object)currency.getPkValue(), (String)"bd_currency", (String)"amtprecision");
            callRequest.setAmountScale(Integer.valueOf(currency.getInt("amtprecision")));
        }
        this.logger.info("\u751f\u6210\u8fd8\u6b3e\u8ba1\u5212\u8f6c\u6362\u540e\u7edf\u4e00\u8bf7\u6c42\u53c2\u6570: {}", (Object)SerializationUtils.toJsonString((Object)callRequest));
        return this.createPlan(callRequest);
    }

    private RepaySchemeInfo trans2RepaySchemeInfo(DynamicObject schemeObj) {
        String offetDay;
        if (schemeObj == null) {
            return null;
        }
        schemeObj = TmcDataServiceHelper.loadSingle((Object)schemeObj.getPkValue(), (String)schemeObj.getDynamicObjectType().getName());
        String period = schemeObj.getString("period");
        RepaySchemeEnum repaySchemeEnum = RepaySchemeEnum.trans2RepaySchemeEnum((String)period);
        RepaySchemeInfo schemeInfo = new RepaySchemeInfo();
        schemeInfo.setRepayScheme(repaySchemeEnum);
        schemeInfo.setRepayMonths(ListUtils.strToIntList((String)schemeObj.getString("month")));
        String day = schemeObj.getString("day");
        if (EmptyUtil.isNotBlank((CharSequence)day)) {
            schemeInfo.setRepayDay(Integer.valueOf(Integer.parseInt(day)));
        }
        if (EmptyUtil.isNotBlank((CharSequence)(offetDay = schemeObj.getString("offetday")))) {
            schemeInfo.setOffetDay(Integer.valueOf(Integer.parseInt(offetDay)));
        }
        schemeInfo.setRepayMonthSettle(Boolean.valueOf(schemeObj.getBoolean("drawmonthsettle")));
        return schemeInfo;
    }

    protected List<PlanCallResult> DQHB(RepayPlanCallRequest request) {
        PlanCallResult info = new PlanCallResult();
        info.setBizDate(request.getEndDate());
        info.setPrinciple(request.getBalance());
        return Collections.singletonList(info);
    }

    protected List<PlanCallResult> HQHK(RepayPlanCallRequest request) {
        List<PlanCallResult> repayList = null;
        RepaySchemeEnum repayScheme = request.getSchemeInfo().getRepayScheme();
        if (repayScheme == null) {
            return Collections.EMPTY_LIST;
        }
        switch (repayScheme) {
            case TOYEAR: 
            case TOQUARTER: 
            case TOMONTH: 
            case TOHALFYEAR: {
                repayList = this.doToCycle(request);
                break;
            }
            case YEAR: 
            case HALFYEAR: 
            case QUARTER: 
            case MONTH: {
                repayList = this.doCycle(request);
                break;
            }
            case DAY: {
                repayList = this.doByDay(request);
                break;
            }
            default: {
                repayList = this.DQHB(request);
            }
        }
        return this.doAmt(request, repayList);
    }

    protected List<PlanCallResult> doAmt(RepayPlanCallRequest request, List<PlanCallResult> repayList) {
        RepaymentWayEnum repayWay = request.getRepayWay();
        BigDecimal loanAmt = request.getBalance();
        BigDecimal fixedRepayAmt = request.getFixedRepayAmount();
        if (fixedRepayAmt == null || fixedRepayAmt.compareTo(BigDecimal.ZERO) <= 0) {
            switch (repayWay) {
                case debx: {
                    return repayList;
                }
            }
            return this.doAvgPrinciple(request, repayList, loanAmt);
        }
        this.doFixedPrinciple(repayList, loanAmt, fixedRepayAmt);
        return repayList;
    }

    private void doFixedPrinciple(List<PlanCallResult> repayList, BigDecimal loanAmt, BigDecimal fixedRepayAmt) {
        int size = repayList.size() - 1;
        if (size == 0) {
            repayList.get(0).setPrinciple(loanAmt);
            return;
        }
        BigDecimal leftRepayAmt = loanAmt;
        for (int i = 0; i <= size; ++i) {
            BigDecimal principle = leftRepayAmt.compareTo(fixedRepayAmt) >= 0 ? fixedRepayAmt : leftRepayAmt;
            PlanCallResult planCallResult = repayList.get(i);
            planCallResult.setPrinciple(i < size ? principle : leftRepayAmt);
            leftRepayAmt = leftRepayAmt.subtract(fixedRepayAmt);
            if (leftRepayAmt.compareTo(BigDecimal.ZERO) > 0) continue;
            for (int j = size; j > i; --j) {
                repayList.remove(j);
            }
            break;
        }
    }

    private List<PlanCallResult> doAvgPrinciple(RepayPlanCallRequest request, List<PlanCallResult> repayList, BigDecimal loanAmt) {
        int size = repayList.size();
        BigDecimal avg = loanAmt.divide(new BigDecimal(size), (int)request.getAmountScale(), request.getAmountRound());
        for (int index = 0; index < size - 1; ++index) {
            repayList.get(index).setPrinciple(avg);
        }
        repayList.get(size - 1).setPrinciple(loanAmt.subtract(avg.multiply(new BigDecimal(size - 1))));
        return repayList;
    }

    @Override
    protected PlanCallResult createPlanByCycle(Date bizDate, boolean isLast, Integer offetDay) {
        PlanCallResult result = new PlanCallResult();
        result.setBizDate(bizDate);
        return result;
    }

    @Override
    public List<PlanCallResult> createPlan(RepayPlanCallRequest request) {
        RepaymentWayEnum repayWay = request.getRepayWay();
        switch (repayWay) {
            case bqhblsbq: 
            case bqhbdqhx: 
            case zdyhk: {
                return this.DQHB(request);
            }
        }
        return this.HQHK(request);
    }
}

